/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.infinity;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import committee.nova.mods.avaritia.api.iface.IFilterItem;
import committee.nova.mods.avaritia.api.iface.ISwitchable;
import committee.nova.mods.avaritia.api.iface.ITooltip;
import committee.nova.mods.avaritia.api.iface.IUndamageable;
import committee.nova.mods.avaritia.api.iface.InitEnchantItem;
import committee.nova.mods.avaritia.api.util.ItemUtils;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModToolTiers;
import committee.nova.mods.avaritia.util.ToolUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityPickaxeItem
extends PickaxeItem
implements InitEnchantItem,
IFilterItem,
ISwitchable,
ITooltip,
IUndamageable {
    public InfinityPickaxeItem() {
        super(ModToolTiers.INFINITY, -50, 0.0f, new Item.Properties().m_41497_(ModRarities.COSMIC).m_41487_(1).m_41486_());
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(Level level, Entity location, ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.m_20185_(), location.m_20186_(), location.m_20189_(), stack);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    public float m_8102_(@NotNull ItemStack stack, @NotNull BlockState state) {
        if (this.isActive(stack, "infinity_pickaxe_hammer")) {
            return 8888.0f;
        }
        return Math.max(super.m_8102_(stack, state), 9999.0f);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            this.switchMode(world, player, hand, "infinity_pickaxe_hammer");
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44985_, (ItemStack)stack) > 0) {
            ItemUtils.clearEnchants(stack);
            stack.m_41663_(Enchantments.f_44987_, 10);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        ItemUtils.clearEnchants(stack);
        stack.m_41663_(Enchantments.f_44985_, 1);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public boolean m_7579_(@NotNull ItemStack stack, @NotNull LivingEntity victim, @NotNull LivingEntity player) {
        if (this.isActive(stack, "infinity_pickaxe_hammer") && !(victim instanceof Player)) {
            int i = 10;
            victim.m_20334_((double)(-Mth.m_14031_((float)(player.f_20883_ * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 2.0, (double)(Mth.m_14089_((float)(player.f_20883_ * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
        }
        return true;
    }

    public boolean m_6813_(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity miningEntity) {
        if (miningEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)miningEntity;
            if (this.isActive(stack, "infinity_pickaxe_hammer")) {
                ToolUtils.destroyMaterialBlocks(player, pos, (Integer)ModConfig.pickAxeBreakRange.get(), ToolUtils.materialsPick);
            }
        }
        return false;
    }

    @Override
    public int getInitEnchantLevel(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44987_ ? 20 : 0;
    }

    @Override
    public boolean hasDescTooltip() {
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.m_43314_().m_6631_(), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.m_43314_().m_6624_(), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }
}

