/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.menu;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.common.slot.FakeSlot;
import committee.nova.mods.avaritia.api.util.game.CraftingRecipeGridIndexGetter;
import committee.nova.mods.avaritia.api.util.math.InvItemCounter;
import committee.nova.mods.avaritia.common.container.DummyChannelContainer;
import committee.nova.mods.avaritia.common.menu.provider.ChannelSelectMenuProvider;
import committee.nova.mods.avaritia.common.net.channel.C2SChannelActionPack;
import committee.nova.mods.avaritia.common.tile.TesseractTile;
import committee.nova.mods.avaritia.core.channel.Channel;
import committee.nova.mods.avaritia.core.channel.ClientChannelManager;
import committee.nova.mods.avaritia.core.channel.ItemChannelTerminal;
import committee.nova.mods.avaritia.core.channel.ServerChannel;
import committee.nova.mods.avaritia.core.channel.ServerChannelManager;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import committee.nova.mods.avaritia.init.registry.ModMenus;
import committee.nova.mods.avaritia.util.StorageUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class TesseractMenu
extends AbstractContainerMenu {
    public final Channel channel;
    public final UUID owner;
    public final Player player;
    public final Level level;
    private final BlockPos blockPos;
    private final int panelItemSlotIndex;
    private final ItemStack panelItem;
    private final TransientCraftingContainer craftSlots = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    private final ResultContainer resultSlots = new ResultContainer();
    public DummyChannelContainer dummyChannelContainer = new DummyChannelContainer(this);
    public TesseractTile tesseractTile;
    public boolean locked;
    public UUID channelOwner;
    public int channelID;
    public boolean craftingMode;
    public String filter;
    public byte sortType;
    public byte viewType;
    public boolean LShifting = false;
    public Runnable craftModeSetter;
    private CraftingRecipe lastCraftingRecipe;

    public TesseractMenu(int containerId, Inventory playerInv, FriendlyByteBuf extraData) {
        super((MenuType)ModMenus.tesseract.get(), containerId);
        int j;
        int i;
        this.craftModeSetter = () -> {};
        this.lastCraftingRecipe = null;
        this.level = playerInv.f_35978_.m_9236_();
        this.player = playerInv.f_35978_;
        this.blockPos = extraData.m_130135_();
        this.panelItemSlotIndex = extraData.readInt();
        this.owner = extraData.m_130259_();
        this.locked = extraData.readBoolean();
        this.craftingMode = extraData.readBoolean();
        this.filter = extraData.m_130136_(64);
        this.sortType = extraData.readByte();
        this.viewType = extraData.readByte();
        this.channelOwner = extraData.m_130259_();
        this.channelID = extraData.readInt();
        this.panelItem = this.panelItemSlotIndex >= 0 ? this.player.m_150109_().m_8020_(this.panelItemSlotIndex) : ItemStack.f_41583_;
        this.addSlots(playerInv.f_35978_, playerInv);
        this.channel = ClientChannelManager.getInstance().getChannel(this.dummyChannelContainer);
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 11; ++j) {
                this.m_38897_(new FakeSlot((Container)this.dummyChannelContainer, i * 11 + j, 7 + j * 17, 17 + i * 17));
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 11; ++j) {
                this.m_38897_(new FakeSlot((Container)this.dummyChannelContainer, 77 + i * 11 + j, 7 + j * 17, 136 + i * 17){

                    public boolean m_6659_() {
                        return !TesseractMenu.this.craftingMode;
                    }
                });
            }
        }
    }

    public TesseractMenu(int containerId, Player player, TesseractTile blockEntity, int panelItemSlotIndex) {
        super((MenuType)ModMenus.tesseract.get(), containerId);
        this.craftModeSetter = () -> {};
        this.lastCraftingRecipe = null;
        this.level = player.m_9236_();
        this.player = player;
        this.panelItemSlotIndex = panelItemSlotIndex;
        if (panelItemSlotIndex >= 0) {
            this.blockPos = BlockPos.f_121853_;
            this.tesseractTile = null;
            this.panelItem = player.m_150109_().m_8020_(panelItemSlotIndex);
            CompoundTag nbt = this.panelItem.m_41784_();
            this.owner = nbt.m_128441_("owner") ? nbt.m_128342_("owner") : player.m_20148_();
            this.locked = nbt.m_128471_("locked");
            this.craftingMode = nbt.m_128471_("craftingMode");
            this.filter = nbt.m_128461_("filter");
            this.sortType = nbt.m_128445_("sortType");
            this.viewType = nbt.m_128445_("viewType");
            CompoundTag channel = nbt.m_128469_("channel");
            if (!channel.m_128456_()) {
                this.channelOwner = channel.m_128342_("channelOwner");
                this.channelID = channel.m_128451_("channelID");
            }
        } else {
            this.blockPos = blockEntity.m_58899_();
            this.tesseractTile = blockEntity;
            this.owner = blockEntity.getOwner() == null ? player.m_20148_() : blockEntity.getOwner();
            this.locked = blockEntity.isLocked();
            this.craftingMode = blockEntity.isCraftingMode();
            this.filter = blockEntity.getFilter();
            this.sortType = blockEntity.getSortType();
            this.viewType = blockEntity.getViewType();
            this.channelOwner = blockEntity.getChannelOwner();
            this.channelID = blockEntity.getChannelID();
            this.panelItem = ItemStack.f_41583_;
        }
        this.channel = ServerChannelManager.getInstance().getChannel(this.channelOwner, this.channelID);
        if (!this.channel.isRemoved()) {
            ((ServerChannel)this.channel).addListener((ServerPlayer)player);
        }
        this.addSlots(player, player.m_150109_());
    }

    @ParametersAreNonnullByDefault
    public boolean m_6366_(Player pPlayer, int pId) {
        switch (pId) {
            case 0: {
                if (!this.owner.equals(this.player.m_20148_()) && !this.owner.equals(Const.AVARITIA_FAKE_PLAYER.getId())) break;
                boolean bl = this.locked = !this.locked;
                if (this.panelItemSlotIndex >= 0) {
                    CompoundTag nbt = this.panelItem.m_41783_();
                    nbt.m_128379_("locked", this.locked);
                    if (this.locked) {
                        nbt.m_128379_("craftingMode", this.craftingMode);
                        nbt.m_128359_("filter", this.filter);
                        nbt.m_128405_("sortType", (int)this.sortType);
                    }
                    this.panelItem.m_41751_(nbt);
                    break;
                }
                this.tesseractTile.setLocked(this.locked);
                if (!this.locked) break;
                this.saveBlock();
                break;
            }
            case 1: {
                this.craftingMode = !this.craftingMode;
                break;
            }
            case 2: {
                this.nextSort();
                break;
            }
            case 3: {
                this.reverseSort();
                break;
            }
            case 4: {
                this.changeViewType();
                break;
            }
            case 5: {
                this.openChannelScreen();
                break;
            }
            case 6: {
                this.craftToChannel(1);
                break;
            }
            case 7: {
                this.craftToChannel(8);
                break;
            }
            case 8: {
                this.craftToChannel(64);
                break;
            }
            case 9: {
                this.craftToChannel(512);
                break;
            }
            case 10: {
                this.craftToInventory(1);
                break;
            }
            case 11: {
                this.craftToInventory(8);
                break;
            }
            case 12: {
                this.craftToInventory(64);
                break;
            }
            case 13: {
                this.craftToInventory(512);
                break;
            }
            case 14: {
                this.craftAndDrop(1);
                break;
            }
            case 15: {
                this.craftAndDrop(8);
                break;
            }
            case 16: {
                this.craftAndDrop(64);
                break;
            }
            case 17: {
                this.craftAndDrop(512);
            }
        }
        return pId < 18;
    }

    public void action(int actionId, String type, String id) {
        switch (actionId) {
            case 0: {
                this.onLeftClickDummySlot(type, id);
                break;
            }
            case 1: {
                this.onRightClickDummySlot(type, id);
                break;
            }
            case 2: {
                this.onLeftShiftDummySlot(type, id);
                break;
            }
            case 3: {
                this.onRightShiftDummySlot(type, id);
                break;
            }
            case 4: {
                this.tryThrowOneFromDummySlot(type, id);
                break;
            }
            case 5: {
                this.tryThrowStickFromDummySlot(type, id);
                break;
            }
            case 6: {
                this.onLeftDragDummySlot(type, id);
                break;
            }
            case 7: {
                this.onRightDragDummySlot(type, id);
                break;
            }
            case 8: {
                this.onCloneFormDummySlot(type, id);
                break;
            }
            case 9: {
                this.onDragCloneDummySlot(type, id);
            }
        }
    }

    public void onLeftClickDummySlot(String type, String id) {
        ItemStack carried = this.m_142621_();
        if (carried.m_41619_()) {
            if (id.equals("minecraft:air")) {
                return;
            }
            if (type.equals("item")) {
                this.m_142503_(this.channel.saveTakeItem(id, false));
            } else if (type.equals("fluid")) {
                if (!this.channel.storageFluids.containsKey(id)) {
                    return;
                }
                if (this.channel.storageFluids.get(id) < 1000L || !this.channel.storageItems.containsKey("minecraft:bucket")) {
                    return;
                }
                FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(id), 1);
                ItemStack fluidBucket = new ItemStack((ItemLike)fluidStack.getFluid().m_6859_());
                if (fluidBucket.m_41619_()) {
                    return;
                }
                this.channel.takeFluid(id, 1000);
                this.channel.takeItem("minecraft:bucket", 1);
                this.m_142503_(fluidBucket);
            }
        } else {
            if (carried.m_41613_() > 1) {
                this.channel.addItem(carried);
                return;
            }
            if (type.equals("fluid") && carried.m_41720_().equals(Items.f_42446_)) {
                if (this.channel.storageFluids.get(id) < 1000L) {
                    return;
                }
                FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(id), 1);
                ItemStack fluidBucket = new ItemStack((ItemLike)fluidStack.getFluid().m_6859_());
                if (fluidBucket.m_41619_()) {
                    return;
                }
                this.channel.takeFluid(id, 1000);
                this.m_142503_(fluidBucket);
            } else {
                AtomicBoolean canal = new AtomicBoolean(false);
                if (type.equals("fluid")) {
                    carried.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(iFluidHandlerItem -> {
                        if (!this.channel.storageFluids.containsKey(id)) {
                            return;
                        }
                        FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(id), (int)Math.min(1000L, this.channel.storageFluids.get(id)));
                        int filledAmount = iFluidHandlerItem.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                        if (filledAmount != 0) {
                            boolean succeedInput = true;
                            int tanks = iFluidHandlerItem.getTanks();
                            ItemStack testItem = carried.m_41777_();
                            AtomicReference<FluidStack> testFluid = new AtomicReference<FluidStack>(FluidStack.EMPTY);
                            for (int i = 0; i < tanks; ++i) {
                                int finalI = i;
                                testItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(testFluidHandlerItem -> testFluid.set(testFluidHandlerItem.getFluidInTank(finalI)));
                                if (testFluid.get().isFluidStackIdentical(iFluidHandlerItem.getFluidInTank(i))) continue;
                                succeedInput = false;
                                this.m_142503_(this.m_142621_().m_41777_());
                                break;
                            }
                            if (succeedInput) {
                                this.channel.takeFluid(id, filledAmount);
                            }
                        }
                        canal.set(true);
                    });
                } else if (type.equals("energy") && id.equals("blackholestorage:forge_energy")) {
                    carried.getCapability(ForgeCapabilities.ENERGY).ifPresent(iEnergyStorage -> {
                        if (!iEnergyStorage.canReceive() || this.channel.getFEAmount() == 0) {
                            return;
                        }
                        int maxInputAmount = Math.min(1000000, this.channel.getFEAmount());
                        int receiveEnergy = iEnergyStorage.receiveEnergy(maxInputAmount, false);
                        if (receiveEnergy == 0) {
                            return;
                        }
                        this.channel.removeEnergy(Long.valueOf(receiveEnergy));
                        canal.set(true);
                    });
                } else if (type.equals("item")) {
                    carried.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                        if (!this.channel.storageItems.containsKey(id)) {
                            return;
                        }
                        int slots = iItemHandler.getSlots();
                        for (int i = 0; i < slots; ++i) {
                            ItemStack remainingItem;
                            int remainingSlotSpace;
                            ItemStack tryInsertItem = new ItemStack((ItemLike)StorageUtils.getItem(id));
                            if (!ItemStack.m_150942_((ItemStack)tryInsertItem, (ItemStack)iItemHandler.getStackInSlot(i)) && !iItemHandler.getStackInSlot(i).m_41619_() || (remainingSlotSpace = iItemHandler.getSlotLimit(i) - iItemHandler.getStackInSlot(i).m_41613_()) <= 0) continue;
                            int transmitAmount = (int)Math.min(Integer.MAX_VALUE, this.channel.storageItems.get(id) / 2L);
                            transmitAmount = Math.max(transmitAmount, 64000);
                            transmitAmount = (int)Math.min((long)transmitAmount, this.channel.storageItems.get(id));
                            int markAmount = transmitAmount = Math.min(transmitAmount, remainingSlotSpace);
                            tryInsertItem.m_41764_(transmitAmount);
                            for (int j = 0; j < 64 && (transmitAmount = (remainingItem = iItemHandler.insertItem(i, tryInsertItem, false)).m_41613_()) > 0; ++j) {
                                tryInsertItem.m_41764_(transmitAmount);
                            }
                            if ((markAmount -= transmitAmount) <= 0) continue;
                            this.channel.takeItem(id, markAmount);
                            canal.set(true);
                            return;
                        }
                    });
                }
                if (canal.get()) {
                    return;
                }
                this.channel.addItem(carried);
            }
        }
    }

    public void onRightClickDummySlot(String type, String id) {
        ItemStack carried = this.m_142621_();
        if (carried.m_41619_()) {
            if (id.equals("minecraft:air")) {
                return;
            }
            if (type.equals("item")) {
                this.m_142503_(this.channel.saveTakeItem(id, true));
            }
            if (type.equals("fluid")) {
                if (this.channel.storageFluids.get(id) < 1000L || !this.channel.storageItems.containsKey("minecraft:bucket")) {
                    return;
                }
                FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(id), 1);
                ItemStack fluidBucket = new ItemStack((ItemLike)fluidStack.getFluid().m_6859_());
                if (fluidBucket.m_41619_()) {
                    return;
                }
                this.channel.takeFluid(id, 1000);
                this.channel.takeItem("minecraft:bucket", 1);
                this.m_142503_(fluidBucket);
            }
        } else {
            if (carried.m_41613_() > 1) {
                this.channel.fillItemStack(carried, -1);
                return;
            }
            AtomicBoolean canal = new AtomicBoolean(false);
            carried.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(iFluidHandlerItem -> {
                int canStoredAmount;
                FluidStack resultFluidStack = iFluidHandlerItem.drain(1000, IFluidHandler.FluidAction.SIMULATE);
                if (iFluidHandlerItem instanceof FluidBucketWrapper) {
                    this.channel.addFluid(resultFluidStack);
                    this.m_142503_(new ItemStack((ItemLike)Items.f_42446_));
                    canal.set(true);
                    return;
                }
                if (!resultFluidStack.isEmpty() && (canStoredAmount = this.channel.canStorageAmount(resultFluidStack)) > 0) {
                    resultFluidStack.setAmount(Math.min(resultFluidStack.getAmount(), canStoredAmount));
                    resultFluidStack = iFluidHandlerItem.drain(resultFluidStack, IFluidHandler.FluidAction.EXECUTE);
                    if (!resultFluidStack.isEmpty()) {
                        int tanks = iFluidHandlerItem.getTanks();
                        ItemStack testItem = carried.m_41777_();
                        AtomicReference<FluidStack> testFluid = new AtomicReference<FluidStack>(FluidStack.EMPTY);
                        for (int i = 0; i < tanks; ++i) {
                            int finalI = i;
                            testItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(testFluidHandlerItem -> testFluid.set(testFluidHandlerItem.getFluidInTank(finalI)));
                            if (testFluid.get().isFluidStackIdentical(iFluidHandlerItem.getFluidInTank(i))) continue;
                            this.m_142503_(this.m_142621_().m_41777_());
                            return;
                        }
                        this.channel.addFluid(resultFluidStack);
                        canal.set(true);
                    }
                }
            });
            if (canal.get()) {
                return;
            }
            carried.getCapability(ForgeCapabilities.ENERGY).ifPresent(iEnergyStorage -> {
                if (!iEnergyStorage.canExtract() || iEnergyStorage.getEnergyStored() == 0) {
                    return;
                }
                int extractEnergy = iEnergyStorage.extractEnergy(Math.min(1000000, this.channel.canStorageFEAmount()), false);
                if (extractEnergy == 0) {
                    return;
                }
                this.channel.addEnergy(extractEnergy);
                canal.set(true);
            });
            if (canal.get()) {
                return;
            }
            carried.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                int slots = iItemHandler.getSlots();
                for (int i = 0; i < slots; ++i) {
                    int maxExtractAmount;
                    ItemStack itemStack = iItemHandler.getStackInSlot(i);
                    if (itemStack.m_41619_() || itemStack.m_41782_() || (itemStack = iItemHandler.extractItem(i, maxExtractAmount = this.channel.canStorageAmount(itemStack), false)).m_41619_()) continue;
                    this.channel.addItem(itemStack);
                    canal.set(true);
                    break;
                }
            });
            if (canal.get()) {
                return;
            }
            this.channel.addItem(carried);
        }
    }

    public void onLeftShiftDummySlot(String type, String id) {
        if (id.equals("minecraft:air")) {
            return;
        }
        ItemStack carried = this.m_142621_();
        if (carried.m_41619_()) {
            if (type.equals("item")) {
                if (!this.channel.storageItems.containsKey(id)) {
                    return;
                }
                ItemStack itemStack = new ItemStack((ItemLike)StorageUtils.getItem(id));
                itemStack.m_41764_((int)Math.min((long)itemStack.m_41741_(), this.channel.storageItems.get(id)));
                int i = itemStack.m_41613_();
                if (this.craftingMode) {
                    this.m_38903_(itemStack, 41, 50, false);
                } else {
                    this.m_38903_(itemStack, 0, 36, false);
                }
                if ((i -= itemStack.m_41613_()) > 0) {
                    itemStack.m_41764_(i);
                    this.channel.removeItem(itemStack);
                }
            } else if (type.equals("fluid")) {
                if (!this.channel.storageFluids.containsKey(id)) {
                    return;
                }
                if (this.channel.storageFluids.get(id) < 1000L || !this.channel.storageItems.containsKey("minecraft:bucket")) {
                    return;
                }
                FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(id), 1);
                ItemStack fluidBucket = new ItemStack((ItemLike)fluidStack.getFluid().m_6859_());
                if (fluidBucket.m_41619_()) {
                    return;
                }
                if (this.craftingMode) {
                    this.m_38903_(fluidBucket, 41, 50, false);
                } else {
                    this.m_38903_(fluidBucket, 0, 36, false);
                }
                if (fluidBucket.m_41619_()) {
                    this.channel.takeFluid(id, 1000);
                    this.channel.takeItem("minecraft:bucket", 1);
                }
            }
        } else {
            if (carried.m_41613_() > 1) {
                this.channel.fillItemStack(carried, -1);
                return;
            }
            if (type.equals("fluid") && carried.m_41720_().equals(Items.f_42446_)) {
                if (this.channel.storageFluids.get(id) < 1000L) {
                    return;
                }
                FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(id), 1);
                ItemStack fluidBucket = new ItemStack((ItemLike)fluidStack.getFluid().m_6859_());
                if (fluidBucket.m_41619_()) {
                    return;
                }
                this.channel.takeFluid(id, 1000);
                this.m_142503_(fluidBucket);
            } else {
                AtomicBoolean canal = new AtomicBoolean(false);
                if (type.equals("fluid")) {
                    carried.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(iFluidHandlerItem -> {
                        if (!this.channel.storageFluids.containsKey(id)) {
                            return;
                        }
                        int tanks = iFluidHandlerItem.getTanks();
                        for (int i = 0; i < tanks; ++i) {
                            int remainingTankSpace;
                            FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(id), 1000);
                            if (!fluidStack.isFluidEqual(iFluidHandlerItem.getFluidInTank(i)) && !iFluidHandlerItem.getFluidInTank(i).isEmpty() || (remainingTankSpace = iFluidHandlerItem.getTankCapacity(i) - iFluidHandlerItem.getFluidInTank(i).getAmount()) <= 0) continue;
                            int transmitAmount = (int)Math.min(Integer.MAX_VALUE, this.channel.storageFluids.get(id) / 2L);
                            transmitAmount = Math.max(transmitAmount, 64000000);
                            transmitAmount = (int)Math.min((long)transmitAmount, this.channel.storageFluids.get(id));
                            int markAmount = transmitAmount = Math.min(transmitAmount, remainingTankSpace);
                            fluidStack.setAmount(transmitAmount);
                            for (int j = 0; j < 1024; ++j) {
                                int filledAmount = iFluidHandlerItem.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                                if (j == 0) {
                                    ItemStack testItem = carried.m_41777_();
                                    AtomicReference<FluidStack> testFluid = new AtomicReference<FluidStack>(FluidStack.EMPTY);
                                    int k = 0;
                                    while (k < tanks) {
                                        int finalI = k++;
                                        testItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(testFluidHandlerItem -> testFluid.set(testFluidHandlerItem.getFluidInTank(finalI)));
                                        if (testFluid.get().isFluidStackIdentical(iFluidHandlerItem.getFluidInTank(i))) continue;
                                        filledAmount = 0;
                                        this.m_142503_(this.m_142621_().m_41777_());
                                        break;
                                    }
                                }
                                if (filledAmount == 0 || (transmitAmount -= filledAmount) <= 0) break;
                                fluidStack.setAmount(transmitAmount);
                            }
                            if ((markAmount -= transmitAmount) > 0) {
                                this.channel.takeFluid(id, markAmount);
                                canal.set(true);
                            }
                            return;
                        }
                    });
                } else if (type.equals("energy") && id.equals("blackholestorage:forge_energy")) {
                    carried.getCapability(ForgeCapabilities.ENERGY).ifPresent(iEnergyStorage -> {
                        int receiveEnergy;
                        int maxInputAmount;
                        if (!iEnergyStorage.canReceive() || this.channel.getFEAmount() == 0) {
                            return;
                        }
                        int markAmount = maxInputAmount = this.channel.getFEAmount();
                        for (int i = 0; i < 1024 && (receiveEnergy = iEnergyStorage.receiveEnergy(maxInputAmount, false)) != 0 && (maxInputAmount -= receiveEnergy) != 0; ++i) {
                        }
                        if ((markAmount -= maxInputAmount) > 0) {
                            this.channel.removeEnergy(Long.valueOf(markAmount));
                            canal.set(true);
                        }
                    });
                } else if (type.equals("item")) {
                    carried.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                        if (!this.channel.storageItems.containsKey(id)) {
                            return;
                        }
                        int transmitAmount = (int)Math.min(Integer.MAX_VALUE, this.channel.storageItems.get(id) / 2L);
                        transmitAmount = Math.max(transmitAmount, 64000);
                        int markAmount = transmitAmount = (int)Math.min((long)transmitAmount, this.channel.storageItems.get(id));
                        ItemStack tryInsertItem = new ItemStack((ItemLike)StorageUtils.getItem(id), transmitAmount);
                        int slots = iItemHandler.getSlots();
                        for (int i = 0; i < slots; ++i) {
                            ItemStack remainingItem;
                            for (int j = 0; j < 64 && (remainingItem = iItemHandler.insertItem(i, tryInsertItem, false)).m_41613_() != transmitAmount && (transmitAmount = remainingItem.m_41613_()) > 0; ++j) {
                                tryInsertItem.m_41764_(transmitAmount);
                            }
                        }
                        if ((markAmount -= transmitAmount) > 0) {
                            this.channel.takeItem(id, markAmount);
                            canal.set(true);
                        }
                    });
                }
                if (canal.get()) {
                    return;
                }
                this.channel.addItem(carried);
            }
        }
    }

    public void onRightShiftDummySlot(String type, String id) {
        ItemStack carried = this.m_142621_();
        if (carried.m_41619_()) {
            if (id.equals("minecraft:air")) {
                return;
            }
            if (type.equals("item")) {
                if (!this.channel.storageItems.containsKey(id)) {
                    return;
                }
                ItemStack itemStack = new ItemStack((ItemLike)StorageUtils.getItem(id));
                if (this.craftingMode) {
                    this.m_38903_(itemStack, 41, 50, false);
                } else {
                    this.m_38903_(itemStack, 0, 36, false);
                }
                if (itemStack.m_41619_()) {
                    this.channel.takeItem(id, 1);
                }
            } else if (type.equals("fluid")) {
                if (!this.channel.storageFluids.containsKey(id)) {
                    return;
                }
                if (this.channel.storageFluids.get(id) < 1000L || !this.channel.storageItems.containsKey("minecraft:bucket")) {
                    return;
                }
                FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(id), 1);
                ItemStack fluidBucket = new ItemStack((ItemLike)fluidStack.getFluid().m_6859_());
                if (fluidBucket.m_41619_()) {
                    return;
                }
                if (this.craftingMode) {
                    this.m_38903_(fluidBucket, 41, 50, false);
                } else {
                    this.m_38903_(fluidBucket, 0, 36, false);
                }
                if (fluidBucket.m_41619_()) {
                    this.channel.takeFluid(id, 1000);
                    this.channel.takeItem("minecraft:bucket", 1);
                }
            }
        } else {
            if (carried.m_41613_() > 1) {
                this.channel.fillItemStack(carried, -1);
                return;
            }
            AtomicBoolean canal = new AtomicBoolean(false);
            carried.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(iFluidHandlerItem -> {
                FluidStack resultFluidStack = iFluidHandlerItem.drain(1000, IFluidHandler.FluidAction.SIMULATE);
                if (iFluidHandlerItem instanceof FluidBucketWrapper) {
                    this.channel.addFluid(resultFluidStack);
                    this.m_142503_(new ItemStack((ItemLike)Items.f_42446_));
                    return;
                }
                if (!resultFluidStack.isEmpty()) {
                    String fluid = StorageUtils.getFluidId(resultFluidStack.getFluid());
                    long canStoredAmount = this.channel.canStorageRealAmount(resultFluidStack);
                    if (canStoredAmount > 0L) {
                        long removedAmount = 0L;
                        for (int i = 0; i < 1024; ++i) {
                            resultFluidStack.setAmount((int)Math.min(Integer.MAX_VALUE, canStoredAmount));
                            resultFluidStack = iFluidHandlerItem.drain(resultFluidStack, IFluidHandler.FluidAction.EXECUTE);
                            if (resultFluidStack.isEmpty()) break;
                            if (i == 0) {
                                int tanks = iFluidHandlerItem.getTanks();
                                ItemStack testItem = carried.m_41777_();
                                AtomicReference<FluidStack> testFluid = new AtomicReference<FluidStack>(FluidStack.EMPTY);
                                for (int j = 0; j < tanks; ++j) {
                                    int finalI = j;
                                    testItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(testFluidHandlerItem -> testFluid.set(testFluidHandlerItem.getFluidInTank(finalI)));
                                    if (testFluid.get().isFluidStackIdentical(iFluidHandlerItem.getFluidInTank(j))) continue;
                                    this.m_142503_(this.m_142621_().m_41777_());
                                    return;
                                }
                            }
                            canStoredAmount -= (long)resultFluidStack.getAmount();
                            removedAmount += (long)resultFluidStack.getAmount();
                        }
                        if (removedAmount > 0L) {
                            this.channel.addFluid(fluid, removedAmount);
                            canal.set(true);
                        }
                    }
                }
            });
            if (canal.get()) {
                return;
            }
            carried.getCapability(ForgeCapabilities.ENERGY).ifPresent(iEnergyStorage -> {
                int extractEnergy;
                int maxRemoveAmount;
                if (!iEnergyStorage.canExtract() || iEnergyStorage.getEnergyStored() == 0) {
                    return;
                }
                int markAmount = maxRemoveAmount = this.channel.canStorageFEAmount();
                for (int i = 0; i < 1024 && (extractEnergy = iEnergyStorage.extractEnergy(Math.min(iEnergyStorage.getEnergyStored(), maxRemoveAmount), false)) != 0 && iEnergyStorage.getEnergyStored() > 0 && (maxRemoveAmount -= extractEnergy) > 0; ++i) {
                }
                if ((markAmount -= maxRemoveAmount) > 0) {
                    this.channel.addEnergy(markAmount);
                    canal.set(true);
                }
            });
            if (canal.get()) {
                return;
            }
            carried.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                int slots = iItemHandler.getSlots();
                for (int i = 0; i < slots; ++i) {
                    int maxExtractAmount;
                    ItemStack itemStack = iItemHandler.getStackInSlot(i);
                    if (itemStack.m_41619_() || itemStack.m_41782_() || (itemStack = iItemHandler.extractItem(i, maxExtractAmount = this.channel.canStorageAmount(itemStack), false)).m_41619_()) continue;
                    this.channel.addItem(itemStack);
                    canal.set(true);
                }
            });
            if (canal.get()) {
                return;
            }
            this.channel.addItem(carried);
        }
    }

    public void tryThrowOneFromDummySlot(String type, String id) {
        if (id.equals("minecraft:air")) {
            return;
        }
        if (type.equals("item")) {
            if (!this.channel.storageItems.containsKey(id)) {
                return;
            }
            ItemStack itemStack = this.channel.takeItem(id, 1);
            this.player.m_36176_(itemStack, false);
        } else if (type.equals("fluid")) {
            if (!this.channel.storageFluids.containsKey(id)) {
                return;
            }
            if (this.channel.storageFluids.get(id) < 1000L || !this.channel.storageItems.containsKey("minecraft:bucket")) {
                return;
            }
            FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(id), 1);
            ItemStack fluidBucket = new ItemStack((ItemLike)fluidStack.getFluid().m_6859_());
            if (fluidBucket.m_41619_()) {
                return;
            }
            this.channel.takeFluid(id, 1000);
            this.channel.takeItem("minecraft:bucket", 1);
            this.player.m_36176_(fluidBucket, false);
        }
    }

    public void tryThrowStickFromDummySlot(String type, String id) {
        if (id.equals("minecraft:air")) {
            return;
        }
        if (type.equals("item")) {
            if (!this.channel.storageItems.containsKey(id)) {
                return;
            }
            ItemStack itemStack = this.channel.saveTakeItem(id, false);
            this.player.m_36176_(itemStack, false);
        } else if (type.equals("fluid")) {
            if (!this.channel.storageFluids.containsKey(id)) {
                return;
            }
            if (this.channel.storageFluids.get(id) < 1000L || !this.channel.storageItems.containsKey("minecraft:bucket")) {
                return;
            }
            FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(id), 1);
            ItemStack fluidBucket = new ItemStack((ItemLike)fluidStack.getFluid().m_6859_());
            if (fluidBucket.m_41619_()) {
                return;
            }
            this.channel.takeFluid(id, 1000);
            this.channel.takeItem("minecraft:bucket", 1);
            this.player.m_36176_(fluidBucket, false);
        }
    }

    public void onLeftDragDummySlot(String type, String id) {
        ItemStack carried = this.m_142621_();
        if (carried.m_41619_()) {
            return;
        }
        this.channel.addItem(carried);
    }

    public void onRightDragDummySlot(String type, String id) {
        ItemStack carried = this.m_142621_();
        if (carried.m_41619_()) {
            return;
        }
        this.channel.fillItemStack(carried, -1);
    }

    public void onCloneFormDummySlot(String type, String id) {
        if (id.equals("minecraft:air") || !this.player.m_7500_()) {
            return;
        }
        switch (type) {
            case "item": {
                this.channel.addItem(id, Long.max(this.channel.getRealItemAmount(id), 64L));
                break;
            }
            case "fluid": {
                this.channel.addFluid(id, Long.max(this.channel.getRealFluidAmount(id), 1000L));
                break;
            }
            case "energy": {
                this.channel.addEnergy(id, Long.max(this.channel.getRealEnergyAmount(id), 1000L));
            }
        }
    }

    public void onDragCloneDummySlot(String type, String id) {
        ItemStack carried = this.m_142621_();
        if (carried.m_41619_()) {
            return;
        }
        ItemStack itemStack = carried.m_41777_();
        itemStack.m_41764_(itemStack.m_41741_());
        this.channel.addItem(itemStack);
    }

    private void addSlots(Player player, Inventory playerInv) {
        for (int l = 0; l < 9; ++l) {
            this.m_38897_(new Slot((Container)playerInv, l, 23 + l * 17, 258));
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.m_38897_(new Slot((Container)playerInv, i1 + k * 9 + 9, 23 + i1 * 17, 195 + k * 17));
            }
        }
        this.m_38897_(this.getArmorSlot(player, playerInv, EquipmentSlot.HEAD, 39, 7, 139));
        this.m_38897_(this.getArmorSlot(player, playerInv, EquipmentSlot.CHEST, 38, 7, 156));
        this.m_38897_(this.getArmorSlot(player, playerInv, EquipmentSlot.LEGS, 37, 58, 139));
        this.m_38897_(this.getArmorSlot(player, playerInv, EquipmentSlot.FEET, 36, 58, 156));
        this.m_38897_(new Slot((Container)playerInv, 40, 7, 173){

            public boolean m_6659_() {
                return TesseractMenu.this.craftingMode;
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_(new Slot((Container)this.craftSlots, j + i * 3, 92 + j * 17, 139 + i * 17){

                    public boolean m_6659_() {
                        return TesseractMenu.this.craftingMode;
                    }
                });
            }
        }
        this.m_38897_((Slot)new ResultSlot(player, (CraftingContainer)this.craftSlots, (Container)this.resultSlots, 0, 161, 156){

            public boolean m_6659_() {
                return TesseractMenu.this.craftingMode;
            }
        });
    }

    private Slot getArmorSlot(final Player player, Inventory inventory, final EquipmentSlot equipmentslot, int slotId, int x, int y) {
        return new Slot((Container)inventory, slotId, x, y){

            @ParametersAreNonnullByDefault
            public void m_5852_(ItemStack itemStack) {
                ItemStack itemstack = this.m_7993_();
                super.m_5852_(itemStack);
                player.m_238392_(equipmentslot, itemstack, itemStack);
            }

            public int m_6641_() {
                return 1;
            }

            @ParametersAreNonnullByDefault
            public boolean m_5857_(ItemStack itemStack) {
                return itemStack.canEquip(equipmentslot, (Entity)player);
            }

            @ParametersAreNonnullByDefault
            public boolean m_8010_(Player player1) {
                ItemStack itemstack = this.m_7993_();
                return (itemstack.m_41619_() || player1.m_7500_() || !EnchantmentHelper.m_44920_((ItemStack)itemstack)) && super.m_8010_(player1);
            }

            public boolean m_6659_() {
                return TesseractMenu.this.craftingMode;
            }
        };
    }

    protected void clearCraftSlots() {
        for (int j = 0; j < this.craftSlots.m_6643_(); ++j) {
            ItemStack itemStack = this.craftSlots.m_8016_(j);
            this.channel.addItem(itemStack);
            if (itemStack.m_41619_()) continue;
            this.pushToInventory(itemStack);
        }
    }

    public void nextSort() {
        this.sortType = (byte)(this.sortType + 2);
        if (this.sortType > 7) {
            this.sortType = (byte)(this.sortType % 8);
        }
        if (this.level.f_46443_) {
            this.dummyChannelContainer.refreshContainer(true);
        }
    }

    public void reverseSort() {
        this.sortType = this.sortType % 2 == 0 ? (byte)(this.sortType + 1) : (byte)(this.sortType - 1);
        if (this.level.f_46443_) {
            this.dummyChannelContainer.refreshContainer(true);
        }
    }

    public void changeViewType() {
        this.viewType = this.viewType == 2 ? (byte)0 : (byte)(this.viewType + 1);
        if (this.level.f_46443_) {
            this.dummyChannelContainer.onChangeViewType();
        }
    }

    private void saveBlock() {
        this.tesseractTile.setCraftingMode(this.craftingMode);
        this.tesseractTile.setFilter(this.filter);
        this.tesseractTile.setSortType(this.sortType);
        this.tesseractTile.setViewType(this.viewType);
    }

    @ParametersAreNonnullByDefault
    public void m_150399_(int pSlotId, int pButton, ClickType pClickType, Player pPlayer) {
        if (pSlotId >= 51) {
            String[] object = pSlotId - 51 < this.dummyChannelContainer.viewingObject.size() ? this.dummyChannelContainer.viewingObject.get(pSlotId - 51) : new String[]{"item", "minecraft:air"};
            block0 : switch (pButton) {
                case 0: {
                    switch (pClickType) {
                        case QUICK_MOVE: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChannelActionPack(this.f_38840_, 2, object));
                            this.onLeftShiftDummySlot(object[0], object[1]);
                            break block0;
                        }
                        case PICKUP: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChannelActionPack(this.f_38840_, 0, object));
                            this.onLeftClickDummySlot(object[0], object[1]);
                            break block0;
                        }
                        case THROW: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChannelActionPack(this.f_38840_, 4, object));
                            this.tryThrowOneFromDummySlot(object[0], object[1]);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (pClickType) {
                        case PICKUP: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChannelActionPack(this.f_38840_, 1, object));
                            this.onRightClickDummySlot(object[0], object[1]);
                            break block0;
                        }
                        case QUICK_MOVE: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChannelActionPack(this.f_38840_, 3, object));
                            this.onRightShiftDummySlot(object[0], object[1]);
                            break block0;
                        }
                        case QUICK_CRAFT: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChannelActionPack(this.f_38840_, 6, object));
                            this.onLeftDragDummySlot(object[0], object[1]);
                            break block0;
                        }
                        case THROW: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChannelActionPack(this.f_38840_, 5, object));
                            this.tryThrowStickFromDummySlot(object[0], object[1]);
                        }
                    }
                    break;
                }
                case 4: {
                    if (pClickType != ClickType.CLONE) break;
                    if (object[0].equals("item") && object[1].equals("minecraft:air")) {
                        return;
                    }
                    NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChannelActionPack(this.f_38840_, 8, object));
                    this.onCloneFormDummySlot(object[0], object[1]);
                    break;
                }
                case 5: {
                    if (pClickType != ClickType.QUICK_CRAFT) break;
                    NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChannelActionPack(this.f_38840_, 7, object));
                    this.onRightDragDummySlot(object[0], object[1]);
                    break;
                }
                case 9: {
                    if (pClickType != ClickType.QUICK_CRAFT) break;
                    NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChannelActionPack(this.f_38840_, 9, object));
                    this.onDragCloneDummySlot(object[0], object[1]);
                }
            }
        } else if (pSlotId >= 41 && pSlotId <= 49 && pClickType.equals((Object)ClickType.QUICK_MOVE)) {
            ItemStack itemStack = ((Slot)this.f_38839_.get(pSlotId)).m_7993_();
            if (pButton == 0) {
                this.m_38903_(itemStack, 9, 36, false);
                if (!itemStack.m_41619_()) {
                    this.m_38903_(itemStack, 0, 9, false);
                }
                this.m_6199_((Container)this.craftSlots);
            } else if (pButton == 1) {
                this.channel.addItem(itemStack);
                this.m_6199_((Container)this.craftSlots);
            } else {
                super.m_150399_(pSlotId, pButton, pClickType, pPlayer);
            }
        } else if (pSlotId != this.panelItemSlotIndex) {
            super.m_150399_(pSlotId, pButton, pClickType, pPlayer);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack m_7648_(Player player, int slotId) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotId);
        if (slot.m_6657_()) {
            ItemStack movingStack = slot.m_7993_();
            itemStack = movingStack.m_41777_();
            if (slotId >= 0 && slotId <= 35) {
                if (!this.craftingMode) {
                    this.channel.addItem(movingStack);
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(movingStack, 41, 50, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (slotId == 50) {
                movingStack.m_41720_().m_7836_(movingStack, this.level, player);
                if (!this.m_38903_(movingStack, 0, 36, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(movingStack, itemStack);
            } else if (slotId >= 41 && slotId <= 49) {
                if (!this.m_38903_(movingStack, 0, 36, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                Const.LOGGER.warn("Ohh! Who trigger the quickMoveStack() when slotId >= 51 in server side ?");
            }
            if (movingStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (movingStack.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, movingStack);
            if (slotId == 50) {
                player.m_36176_(movingStack, false);
            }
        }
        return itemStack;
    }

    @ParametersAreNonnullByDefault
    public boolean m_5882_(ItemStack itemStack, Slot slot) {
        return slot.f_40219_ <= 49;
    }

    @ParametersAreNonnullByDefault
    public boolean m_6875_(Player player) {
        if (this.channel.isRemoved()) {
            if (this.panelItemSlotIndex >= 0) {
                CompoundTag nbt = this.panelItem.m_41783_();
                nbt.m_128473_("channel");
                this.panelItem.m_41751_(nbt);
            } else {
                this.tesseractTile.setChannel(null, -1);
            }
            this.openChannelScreen();
        }
        if (this.panelItemSlotIndex >= 0) {
            return this.panelItem == player.m_150109_().m_8020_(this.panelItemSlotIndex);
        }
        return !this.tesseractTile.m_58901_() && player.m_20275_((double)this.blockPos.m_123341_() + 0.5, (double)this.blockPos.m_123342_() + 0.5, (double)this.blockPos.m_123343_() + 0.5) <= 32.0;
    }

    @ParametersAreNonnullByDefault
    public void m_6877_(Player player) {
        if (this.level.f_46443_) {
            return;
        }
        if (!this.channel.isRemoved()) {
            ((ServerChannel)this.channel).removeListener((ServerPlayer)player);
        }
        super.m_6877_(player);
        this.clearCraftSlots();
        if (this.panelItemSlotIndex >= 0) {
            CompoundTag nbt = this.panelItem.m_41783_();
            if (!nbt.m_128471_("locked")) {
                nbt.m_128379_("locked", this.locked);
                nbt.m_128379_("craftingMode", this.craftingMode);
                nbt.m_128359_("filter", this.filter);
                nbt.m_128344_("sortType", this.sortType);
                nbt.m_128344_("viewType", this.viewType);
                if (this.channel.isRemoved()) {
                    nbt.m_128473_("channel");
                }
                this.panelItem.m_41751_(nbt);
            }
        } else if (!this.tesseractTile.isLocked()) {
            this.saveBlock();
        }
    }

    private void openChannelScreen() {
        if (this.locked) {
            return;
        }
        if (this.panelItemSlotIndex >= 0) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)this.player), (MenuProvider)new ChannelSelectMenuProvider(new ItemChannelTerminal(this.player.m_150109_(), this.panelItem, this.panelItemSlotIndex)), buf -> {});
        } else {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)this.player), (MenuProvider)new ChannelSelectMenuProvider(this.tesseractTile), buf -> {});
        }
    }

    @ParametersAreNonnullByDefault
    public void m_6199_(Container container) {
        if (this.level.f_46443_) {
            return;
        }
        if (this.lastCraftingRecipe != null && this.lastCraftingRecipe.m_5818_((Container)this.craftSlots, this.level)) {
            this.resultSlots.m_40135_(this.level, (ServerPlayer)this.player, (Recipe)this.lastCraftingRecipe);
            this.resultSlots.m_6836_(0, this.lastCraftingRecipe.m_5874_((Container)this.craftSlots, this.level.m_9598_()));
            return;
        }
        Optional optional = this.level.m_7654_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)this.craftSlots, this.level);
        if (optional.isPresent()) {
            CraftingRecipe recipe = (CraftingRecipe)optional.get();
            if (this.resultSlots.m_40135_(this.level, (ServerPlayer)this.player, (Recipe)recipe)) {
                this.resultSlots.m_6836_(0, recipe.m_5874_((Container)this.craftSlots, this.level.m_9598_()));
            }
        } else {
            this.resultSlots.m_6836_(0, ItemStack.f_41583_);
        }
    }

    public void receivedRecipe(String recipeId, boolean maxTransfer) {
        Optional optional1;
        int i;
        if (this.level.m_7654_() == null) {
            return;
        }
        RecipeManager manager = this.level.m_7654_().m_129894_();
        Optional optional = manager.m_44043_(new ResourceLocation(recipeId));
        if (optional.isEmpty()) {
            return;
        }
        Inventory inventory = this.player.m_150109_();
        Object t = optional.get();
        if (!(t instanceof CraftingRecipe)) {
            return;
        }
        CraftingRecipe craftingRecipe = (CraftingRecipe)t;
        this.craftingMode = true;
        this.clearCraftSlots();
        this.m_6199_((Container)this.craftSlots);
        NonNullList ingredients = craftingRecipe.m_7527_();
        HashMap<Item, Long> itemAmount = new HashMap<Item, Long>();
        HashMap<Item, Integer> itemP = new HashMap<Item, Integer>();
        InvItemCounter invItemCounter = null;
        ArrayList<Object> itemChosen = new ArrayList<Object>();
        for (Ingredient ingredient : ingredients) {
            if (ingredient.m_43947_()) {
                itemChosen.add(null);
                continue;
            }
            ItemStack[] stacks = ingredient.m_43908_();
            long markCount = 0L;
            Item markItem = null;
            boolean hasNbtItem = false;
            for (ItemStack stack : stacks) {
                long count;
                if (stack.m_41782_()) {
                    hasNbtItem = true;
                    continue;
                }
                Item item = stack.m_41720_();
                if (itemAmount.containsKey(item)) {
                    count = (Long)itemAmount.get(item);
                } else {
                    count = this.channel.getRealItemAmount(StorageUtils.getItemId(item));
                    if (count < 576L) {
                        if (invItemCounter == null) {
                            invItemCounter = new InvItemCounter(inventory);
                        }
                        count += (long)invItemCounter.getCount(item);
                    }
                    itemAmount.put(item, count);
                }
                if (count > markCount) {
                    markCount = count;
                    markItem = item;
                }
                if (itemP.containsKey(item)) {
                    itemP.replace(item, (Integer)itemP.get(item) + 1);
                    continue;
                }
                itemP.put(item, 1);
            }
            if (markItem == null && hasNbtItem) {
                itemChosen.add(Items.f_41852_);
                continue;
            }
            itemChosen.add(markItem);
        }
        CraftingRecipeGridIndexGetter recipeSlotIndexGetter = new CraftingRecipeGridIndexGetter(craftingRecipe);
        block2: for (i = 0; i < itemChosen.size(); ++i) {
            int gridIndex = recipeSlotIndexGetter.get();
            Item item = (Item)itemChosen.get(i);
            if (item == null) continue;
            if (item.equals(Items.f_41852_)) {
                Ingredient ingredient = (Ingredient)ingredients.get(i);
                for (ItemStack itemStack : ingredient.m_43908_()) {
                    if (!itemStack.m_41782_()) continue;
                    if (invItemCounter == null) {
                        invItemCounter = new InvItemCounter(inventory);
                    }
                    Integer[] itemIndex = invItemCounter.getNbtItemIndex();
                    boolean flag = false;
                    for (Integer index : itemIndex) {
                        ItemStack stack2 = inventory.m_8020_(index.intValue());
                        if (stack2.m_41619_() || !ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)stack2)) continue;
                        if (stack2.m_41613_() == 1) {
                            this.craftSlots.m_6836_(gridIndex, stack2);
                            inventory.m_6836_(index.intValue(), ItemStack.f_41583_);
                        } else {
                            ItemStack newStack = stack2.m_41777_();
                            newStack.m_41764_(1);
                            this.craftSlots.m_6836_(gridIndex, newStack);
                            stack2.m_41769_(-1);
                        }
                        flag = true;
                        break;
                    }
                    if (flag) continue block2;
                }
                continue;
            }
            if (this.channel.getRealItemAmount(StorageUtils.getItemId(item)) > 0L) {
                this.craftSlots.m_6836_(gridIndex, new ItemStack((ItemLike)item));
                this.channel.removeItem(StorageUtils.getItemId(item), 1L);
                continue;
            }
            if (invItemCounter == null) {
                invItemCounter = new InvItemCounter(inventory);
            }
            Integer[] itemIndex = invItemCounter.getNoNbtItemIndex();
            for (ItemStack itemStack : itemIndex) {
                ItemStack stack = inventory.m_8020_(itemStack.intValue());
                if (stack.m_41619_() || !stack.m_41720_().equals(item)) continue;
                if (stack.m_41613_() == 1) {
                    this.craftSlots.m_6836_(gridIndex, stack);
                    inventory.m_6836_(itemStack.intValue(), ItemStack.f_41583_);
                    continue block2;
                }
                this.craftSlots.m_6836_(gridIndex, new ItemStack((ItemLike)item));
                stack.m_41769_(-1);
                continue block2;
            }
        }
        if (!craftingRecipe.m_5818_((Container)this.craftSlots, this.level)) {
            return;
        }
        if (maxTransfer) {
            block6: for (i = 0; i < 9; ++i) {
                ItemStack itemStack = this.craftSlots.m_8020_(i);
                if (itemStack.m_41619_() || itemStack.m_41782_() || itemStack.m_41741_() == 1) continue;
                Item item = itemStack.m_41720_();
                String itemId = StorageUtils.getItemId(item);
                long amount = itemAmount.getOrDefault(item, 0L);
                int p = itemP.getOrDefault(item, 0);
                int n = (int)Long.min(itemStack.m_41741_(), amount / (long)p);
                if (n < 2) continue;
                int channelHas = this.channel.getItemAmount(itemId);
                if (channelHas >= n) {
                    this.channel.removeItem(itemId, n - itemStack.m_41613_());
                    itemStack.m_41764_(n);
                    continue;
                }
                if (channelHas > 0) {
                    this.channel.removeItem(itemId, channelHas);
                    itemStack.m_41764_(itemStack.m_41613_() + channelHas);
                }
                if (invItemCounter == null) {
                    invItemCounter = new InvItemCounter(inventory);
                }
                Integer[] itemIndex = invItemCounter.getNoNbtItemIndex();
                for (Integer index : itemIndex) {
                    ItemStack invStack = inventory.m_8020_(index.intValue());
                    if (invStack.m_41619_() || invStack.m_41782_() || !item.equals(invStack.m_41720_())) continue;
                    int invCount = invStack.m_41613_();
                    if (itemStack.m_41613_() + invCount > n) {
                        int j = itemStack.m_41613_() + invCount - n;
                        invStack.m_41764_(j);
                        itemStack.m_41764_(n);
                        continue;
                    }
                    inventory.m_6836_(index.intValue(), ItemStack.f_41583_);
                    itemStack.m_41769_(invCount);
                    if (itemStack.m_41613_() >= n) continue block6;
                }
            }
        }
        if ((optional1 = manager.m_44015_(RecipeType.f_44107_, (Container)this.craftSlots, this.level)).isPresent()) {
            CraftingRecipe currentRecipe = (CraftingRecipe)optional1.get();
            if (currentRecipe != craftingRecipe && craftingRecipe.m_5818_((Container)this.craftSlots, this.level) && this.resultSlots.m_40135_(this.level, (ServerPlayer)this.player, (Recipe)craftingRecipe)) {
                this.lastCraftingRecipe = craftingRecipe;
                this.resultSlots.m_6836_(0, craftingRecipe.m_5874_((Container)this.craftSlots, this.level.m_9598_()));
            }
        } else {
            this.resultSlots.m_6836_(0, ItemStack.f_41583_);
        }
    }

    public void receivedRecipe(Map<String, Integer> itemNeed) {
        itemNeed.forEach((s, integer) -> {
            ItemStack itemStack = this.channel.takeItem((String)s, (int)integer);
            if (itemStack.m_41619_()) {
                return;
            }
            this.savePushToInventory(itemStack);
        });
    }

    private void craftToChannel(int max) {
        ItemStack resultItem = this.resultSlots.m_8020_(0).m_41777_();
        if (resultItem.m_41619_() || resultItem.m_41782_()) {
            return;
        }
        Recipe recipe = this.resultSlots.m_7928_();
        if (recipe instanceof CraftingRecipe) {
            int maxTry = max % resultItem.m_41613_() > 0 ? max / resultItem.m_41613_() + 1 : max / resultItem.m_41613_();
            int count = resultItem.m_41613_() * this.doCraft(resultItem, maxTry);
            long notInCount = (long)count - this.channel.addItem(StorageUtils.getItemId(resultItem.m_41720_()), count);
            if (notInCount > 0L) {
                resultItem.m_41764_((int)notInCount);
                this.pushToInventory(resultItem);
            }
        }
    }

    private void craftToInventory(int max) {
        ItemStack resultItem = this.resultSlots.m_8020_(0).m_41777_();
        if (resultItem.m_41619_()) {
            return;
        }
        Recipe recipe = this.resultSlots.m_7928_();
        if (recipe instanceof CraftingRecipe) {
            int maxTry1 = max % resultItem.m_41613_() > 0 ? max / resultItem.m_41613_() + 1 : max / resultItem.m_41613_();
            int maxSpace = 0;
            int maxStackSize = resultItem.m_41741_();
            for (int i = 0; i < 36; ++i) {
                ItemStack slotStack = this.player.m_150109_().m_8020_(i);
                if (slotStack.m_41619_()) {
                    maxSpace += maxStackSize;
                    continue;
                }
                if (maxStackSize <= 1 || !ItemStack.m_150942_((ItemStack)resultItem, (ItemStack)slotStack)) continue;
                maxSpace = maxSpace + maxStackSize - slotStack.m_41613_();
            }
            if (maxSpace <= 0) {
                return;
            }
            int maxTry2 = maxSpace / resultItem.m_41613_();
            int maxTry = Integer.min(maxTry1, maxTry2);
            int count = resultItem.m_41613_() * this.doCraft(resultItem, maxTry);
            resultItem.m_41764_(count);
            this.savePushToInventory(resultItem);
        }
    }

    private void craftAndDrop(int max) {
        ItemStack resultItem = this.resultSlots.m_8020_(0).m_41777_();
        if (resultItem.m_41619_()) {
            return;
        }
        Recipe recipe = this.resultSlots.m_7928_();
        if (recipe instanceof CraftingRecipe) {
            int maxTry = max % resultItem.m_41613_() > 0 ? max / resultItem.m_41613_() + 1 : max / resultItem.m_41613_();
            int count = resultItem.m_41613_() * this.doCraft(resultItem, maxTry);
            resultItem.m_41764_(count);
            this.player.m_36176_(resultItem, false);
        }
    }

    private int doCraft(ItemStack resultItem, int maxTry) {
        int remainingCraftTry = maxTry - this.tryFastCraft(maxTry);
        if (remainingCraftTry > 0) {
            ArrayList<ItemStack> beforeItems = new ArrayList<ItemStack>();
            for (int i = 0; i < 9; ++i) {
                beforeItems.add(i, this.craftSlots.m_8020_(i).m_41777_());
            }
            InvItemCounter invItemCounter = null;
            while (remainingCraftTry > 0) {
                if (remainingCraftTry > 1) {
                    for (int i = 0; i < 9; ++i) {
                        Integer[] noNbtItemIndex;
                        ItemStack craftingStack = this.craftSlots.m_8020_(i);
                        int maxStackSize = craftingStack.m_41741_();
                        if (craftingStack.m_41619_() || maxStackSize == 1 || craftingStack.m_41613_() >= 2 || craftingStack.m_41782_()) continue;
                        int channelAmount = this.channel.getItemAmount(StorageUtils.getItemId(craftingStack.m_41720_()));
                        if (channelAmount >= maxStackSize - 1) {
                            craftingStack.m_41764_(maxStackSize);
                            this.channel.removeItem(StorageUtils.getItemId(craftingStack.m_41720_()), maxStackSize - 1);
                            continue;
                        }
                        if (channelAmount > 0) {
                            this.channel.removeItem(StorageUtils.getItemId(craftingStack.m_41720_()), channelAmount);
                            craftingStack.m_41764_(channelAmount + 1);
                        }
                        if (invItemCounter == null) {
                            invItemCounter = new InvItemCounter(this.player.m_150109_());
                        }
                        if (invItemCounter.getCount(craftingStack.m_41720_()) <= 0) continue;
                        for (Integer integer : noNbtItemIndex = invItemCounter.getNoNbtItemIndex()) {
                            this.applyFromInvIndex(craftingStack, integer);
                        }
                    }
                }
                ((Slot)this.f_38839_.get(50)).m_142406_(this.player, resultItem);
                --remainingCraftTry;
                if (this.isSameResul(resultItem) || this.fixItems(resultItem, beforeItems)) continue;
                break;
            }
        }
        return maxTry - remainingCraftTry;
    }

    private int tryFastCraft(int maxTry) {
        HashMap<Item, Integer> itemMap = new HashMap<Item, Integer>();
        boolean canFastCraft = true;
        for (int i = 0; i < 9; ++i) {
            ItemStack slotStack = this.craftSlots.m_8020_(i);
            if (slotStack.m_41619_()) continue;
            if (slotStack.m_41782_() || slotStack.hasCraftingRemainingItem()) {
                canFastCraft = false;
                break;
            }
            if (itemMap.containsKey(slotStack.m_41720_())) {
                itemMap.replace(slotStack.m_41720_(), (Integer)itemMap.get(slotStack.m_41720_()) + 1);
                continue;
            }
            itemMap.put(slotStack.m_41720_(), 1);
        }
        if (canFastCraft) {
            Integer integer;
            Item item;
            int canTry = maxTry;
            for (Map.Entry entry : itemMap.entrySet()) {
                item = (Item)entry.getKey();
                integer = (Integer)entry.getValue();
                int needAmount = integer * canTry;
                int has = this.channel.getItemAmount(StorageUtils.getItemId(item));
                if (has >= needAmount || (canTry = has / integer) != 0) continue;
                break;
            }
            if (canTry > 0) {
                for (Map.Entry entry : itemMap.entrySet()) {
                    item = (Item)entry.getKey();
                    integer = (Integer)entry.getValue();
                    this.channel.removeItem(StorageUtils.getItemId(item), (long)integer.intValue() * (long)canTry);
                }
            }
            return canTry;
        }
        return 0;
    }

    private boolean fixItems(ItemStack resultItem, ArrayList<ItemStack> beforeItems) {
        for (int i = 0; i < 9; ++i) {
            ItemStack needStack;
            ItemStack craftingStack = this.craftSlots.m_8020_(i);
            if (ItemStack.m_150942_((ItemStack)craftingStack, (ItemStack)(needStack = beforeItems.get(i)))) continue;
            if (!craftingStack.m_41619_()) {
                this.channel.addItem(craftingStack);
                if (!craftingStack.m_41619_()) {
                    this.m_38903_(craftingStack, 9, 36, false);
                }
                if (!craftingStack.m_41619_()) {
                    this.m_38903_(craftingStack, 0, 9, false);
                }
                if (!craftingStack.m_41619_()) {
                    return false;
                }
            }
            if (!needStack.m_41619_()) {
                if (needStack.m_41782_()) {
                    this.moveSameItemToCraftingSlot(i, needStack);
                } else {
                    int channelHas = this.channel.getItemAmount(StorageUtils.getItemId(needStack.m_41720_()));
                    if (channelHas >= needStack.m_41741_()) {
                        this.craftSlots.m_6836_(i, this.channel.takeItem(StorageUtils.getItemId(needStack.m_41720_()), needStack.m_41741_()));
                    } else if (channelHas == 0) {
                        this.moveSameItemToCraftingSlot(i, needStack);
                    } else {
                        this.craftSlots.m_6836_(i, this.channel.takeItem(StorageUtils.getItemId(needStack.m_41720_()), channelHas));
                        this.fillStackFromInventory(this.craftSlots.m_8020_(i));
                    }
                }
            }
            if (!this.isSameResul(resultItem)) continue;
            return true;
        }
        if (!this.isSameResul(resultItem)) {
            int i;
            ArrayList itemMark = new ArrayList();
            ArrayList<ItemStack> itemAmount = new ArrayList<ItemStack>();
            beforeItems.forEach(beforeItem -> {
                if (beforeItem.m_41619_()) {
                    return;
                }
                if (itemMark.size() == 0) {
                    ItemStack inItem = beforeItem.m_41777_();
                    inItem.m_41764_(1);
                    itemMark.add(inItem);
                } else {
                    boolean flag = true;
                    for (ItemStack itemStack : itemMark) {
                        if (!ItemStack.m_150942_((ItemStack)beforeItem, (ItemStack)itemStack)) continue;
                        itemStack.m_41764_(itemStack.m_41613_() + 1);
                        flag = false;
                        break;
                    }
                    if (flag) {
                        ItemStack inItem = beforeItem.m_41777_();
                        inItem.m_41764_(1);
                        itemMark.add(inItem);
                    }
                }
            });
            for (i = 0; i < 9; ++i) {
                ItemStack slotItem = this.craftSlots.m_8020_(i);
                if (slotItem.m_41619_()) continue;
                if (itemAmount.size() == 0) {
                    ItemStack inItem = slotItem.m_41777_();
                    itemAmount.add(inItem);
                } else {
                    boolean flag = true;
                    for (ItemStack itemStack : itemAmount) {
                        if (!ItemStack.m_150942_((ItemStack)slotItem, (ItemStack)itemStack)) continue;
                        itemStack.m_41764_(itemStack.m_41613_() + slotItem.m_41613_());
                        flag = false;
                        break;
                    }
                    if (flag) {
                        ItemStack inItem = slotItem.m_41777_();
                        itemAmount.add(inItem);
                    }
                }
                this.craftSlots.m_6836_(i, ItemStack.f_41583_);
            }
            for (i = 0; i < 9; ++i) {
                ItemStack beforeStack = beforeItems.get(i);
                if (beforeStack.m_41619_()) continue;
                ItemStack p = ItemStack.f_41583_;
                ItemStack amount = ItemStack.f_41583_;
                for (ItemStack itemStack : itemMark) {
                    if (!ItemStack.m_150942_((ItemStack)beforeStack, (ItemStack)itemStack)) continue;
                    p = itemStack;
                    break;
                }
                for (ItemStack itemStack : itemAmount) {
                    if (!ItemStack.m_150942_((ItemStack)beforeStack, (ItemStack)itemStack)) continue;
                    amount = itemStack;
                    break;
                }
                if (p.m_41619_() || amount.m_41619_()) continue;
                ItemStack itemStack = beforeStack.m_41777_();
                int count = amount.m_41613_() / p.m_41613_();
                itemStack.m_41764_(count);
                this.craftSlots.m_6836_(i, itemStack);
                amount.m_41764_(amount.m_41613_() - count);
                p.m_41764_(p.m_41613_() - 1);
            }
        }
        return this.isSameResul(resultItem);
    }

    private void pushToInventory(ItemStack itemStack) {
        this.m_38903_(itemStack, 9, 36, false);
        if (!itemStack.m_41619_()) {
            this.m_38903_(itemStack, 0, 9, false);
        }
        if (!itemStack.m_41619_()) {
            this.player.m_36176_(itemStack, false);
        }
    }

    private void savePushToInventory(ItemStack itemStack) {
        int loops = itemStack.m_41613_() / itemStack.m_41741_();
        for (int i = 0; i < loops; ++i) {
            ItemStack newStack = itemStack.m_41777_();
            newStack.m_41764_(itemStack.m_41741_());
            itemStack.m_41764_(itemStack.m_41613_() - itemStack.m_41741_());
            this.pushToInventory(newStack);
        }
        if (itemStack.m_41613_() > 0) {
            this.pushToInventory(itemStack);
        }
    }

    private void fillStackFromInventory(ItemStack stack) {
        int i;
        int maxStackSize = stack.m_41741_();
        for (i = 9; i < 36; ++i) {
            this.applyNbtFromInvIndex(stack, i);
            if (stack.m_41613_() >= maxStackSize) break;
        }
        if (stack.m_41613_() < maxStackSize) {
            for (i = 0; i < 9; ++i) {
                this.applyNbtFromInvIndex(stack, i);
                if (stack.m_41613_() >= maxStackSize) break;
            }
        }
    }

    private void applyFromInvIndex(ItemStack itemStack, int slotId) {
        if (itemStack.m_41720_().equals(this.player.m_150109_().m_8020_(slotId).m_41720_())) {
            ItemStack otherStack = this.player.m_150109_().m_8020_(slotId);
            int needAmount = itemStack.m_41741_() - itemStack.m_41613_();
            if (otherStack.m_41613_() > needAmount) {
                itemStack.m_41764_(itemStack.m_41741_());
                otherStack.m_41764_(otherStack.m_41613_() - needAmount);
            } else {
                itemStack.m_41764_(itemStack.m_41613_() + otherStack.m_41613_());
                this.player.m_150109_().m_6836_(slotId, ItemStack.f_41583_);
            }
        }
    }

    private void applyNbtFromInvIndex(ItemStack itemStack, int slotId) {
        if (ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)this.player.m_150109_().m_8020_(slotId))) {
            ItemStack otherStack = this.player.m_150109_().m_8020_(slotId);
            int needAmount = itemStack.m_41741_() - itemStack.m_41613_();
            if (otherStack.m_41613_() > needAmount) {
                itemStack.m_41764_(itemStack.m_41741_());
                otherStack.m_41764_(otherStack.m_41613_() - needAmount);
            } else {
                itemStack.m_41764_(itemStack.m_41613_() + otherStack.m_41613_());
                this.player.m_150109_().m_6836_(slotId, ItemStack.f_41583_);
            }
        }
    }

    private void moveSameItemToCraftingSlot(int slotIndex, ItemStack stack) {
        ItemStack otherStack;
        int i;
        boolean flag = true;
        for (i = 9; i < 36; ++i) {
            otherStack = this.player.m_150109_().m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)otherStack)) continue;
            this.craftSlots.m_6836_(slotIndex, otherStack);
            this.player.m_150109_().m_6836_(i, ItemStack.f_41583_);
            flag = false;
            break;
        }
        if (flag) {
            for (i = 0; i < 9; ++i) {
                otherStack = this.player.m_150109_().m_8020_(i);
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)otherStack)) continue;
                this.craftSlots.m_6836_(slotIndex, otherStack);
                this.player.m_150109_().m_6836_(i, ItemStack.f_41583_);
                break;
            }
        }
    }

    private boolean isSameResul(ItemStack itemStack) {
        return ItemStack.m_150942_((ItemStack)this.resultSlots.m_8020_(0), (ItemStack)itemStack) && this.resultSlots.m_8020_(0).m_41613_() == itemStack.m_41613_();
    }
}

