/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.net;

import committee.nova.mods.avaritia.api.util.ItemUtils;
import committee.nova.mods.avaritia.common.tile.NeutronCompressorTile;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class C2SCompressorEjectPacket {
    private BlockPos pos;

    public C2SCompressorEjectPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
    }

    public C2SCompressorEjectPacket(BlockPos pos) {
        this.pos = pos;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
    }

    public void run(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Level level = player.m_9236_();
            BlockEntity tile = level.m_7702_(this.pos);
            if (tile instanceof NeutronCompressorTile) {
                NeutronCompressorTile compressor = (NeutronCompressorTile)tile;
                if (compressor.isRecipeLocked()) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[\u4e2d\u5b50\u538b\u7f29\u5668] \u00a7f\u8bf7\u5148\u89e3\u9501\u914d\u65b9"));
                    return;
                }
                if (compressor.getMaterialCount() > 0) {
                    ItemStack materialStack = compressor.getMaterialStack();
                    if (!materialStack.m_41619_()) {
                        ItemStack ejectStack = materialStack.m_41777_();
                        ejectStack.m_41764_(compressor.getMaterialCount());
                        Inventory playerInventory = player.m_150109_();
                        boolean addedToInventory = false;
                        for (int i = 0; i < playerInventory.m_6643_(); ++i) {
                            int canAdd;
                            ItemStack slotStack = playerInventory.m_8020_(i);
                            if (slotStack.m_41619_()) {
                                playerInventory.m_6836_(i, ejectStack);
                                addedToInventory = true;
                                break;
                            }
                            if (!ItemUtils.areStacksSameType(slotStack, ejectStack) || slotStack.m_41613_() >= slotStack.m_41741_() || (canAdd = Math.min(ejectStack.m_41613_(), slotStack.m_41741_() - slotStack.m_41613_())) <= 0) continue;
                            slotStack.m_41769_(canAdd);
                            ejectStack.m_41774_(canAdd);
                            if (!ejectStack.m_41619_()) continue;
                            addedToInventory = true;
                            break;
                        }
                        if (!addedToInventory) {
                            player.m_36176_(ejectStack, false);
                        }
                        compressor.clearMaterials();
                        player.m_213846_((Component)Component.m_237113_((String)("\u00a7a[\u4e2d\u5b50\u538b\u7f29\u5668] \u00a7f\u5df2\u5f39\u51fa\u6750\u6599: " + ejectStack.m_41613_() + "x " + ejectStack.m_41611_().getString())));
                    }
                } else {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[\u4e2d\u5b50\u538b\u7f29\u5668] \u00a7f\u6ca1\u6709\u53ef\u5f39\u51fa\u7684\u6750\u6599"));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

