/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.net;

import committee.nova.mods.avaritia.init.registry.ModItems;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class C2SElytraSpeedUpPacket {
    private final boolean customFlying;
    private final boolean boosting;

    public C2SElytraSpeedUpPacket(FriendlyByteBuf buf) {
        this.customFlying = buf.readBoolean();
        this.boosting = buf.readBoolean();
    }

    public C2SElytraSpeedUpPacket(boolean customFlying, boolean boosting) {
        this.customFlying = customFlying;
        this.boosting = boosting;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.customFlying);
        buf.writeBoolean(this.boosting);
    }

    public void run(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            if (player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ModItems.infinity_elytra.get()) && this.customFlying) {
                if (!player.m_21255_()) {
                    player.m_5997_(0.0, -0.5, 0.0);
                }
                if (this.boosting) {
                    this.applyBoost(player);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private void applyBoost(ServerPlayer player) {
        Vec3 lookVec = player.m_20154_();
        double boostStrength = 0.7;
        player.m_5997_(lookVec.f_82479_ * boostStrength, lookVec.f_82480_ * boostStrength * 0.8, lookVec.f_82481_ * boostStrength);
        for (int i = 0; i < 15; ++i) {
            player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, player.m_20185_() - lookVec.f_82479_ * 0.5, player.m_20186_() + (double)(player.m_20206_() / 2.0f) + (player.m_9236_().f_46441_.m_188500_() - 0.5) * 0.5, player.m_20189_() - lookVec.f_82481_ * 0.5, -lookVec.f_82479_ * 0.5 + (player.m_9236_().f_46441_.m_188500_() - 0.5) * 0.2, -0.3 + player.m_9236_().f_46441_.m_188500_() * 0.3, -lookVec.f_82481_ * 0.5 + (player.m_9236_().f_46441_.m_188500_() - 0.5) * 0.2);
        }
    }
}

