/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.net;

import committee.nova.mods.avaritia.api.iface.ITileIO;
import committee.nova.mods.avaritia.core.io.SideConfiguration;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class S2CSideConfigSyncPacket {
    private final BlockPos pos;
    private final SideConfiguration sideConfig;

    public S2CSideConfigSyncPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.sideConfig = SideConfiguration.fromNetwork(buf);
    }

    public S2CSideConfigSyncPacket(BlockPos pos, SideConfiguration sideConfig) {
        this.pos = pos;
        this.sideConfig = sideConfig;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        this.sideConfig.toNetwork(buf);
    }

    public void run(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            BlockEntity tile = level.m_7702_(this.pos);
            if (tile instanceof ITileIO) {
                ITileIO tileIO = (ITileIO)tile;
                tileIO.setSideConfiguration(this.sideConfig);
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

