/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.net.channel;

import committee.nova.mods.avaritia.common.net.channel.ChannelAction;
import committee.nova.mods.avaritia.core.channel.ClientChannelManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class S2CChannelActionPack {
    private final ChannelAction action;
    private final byte type;
    private final String name;
    private final int id;

    public S2CChannelActionPack(FriendlyByteBuf buf) {
        this.action = (ChannelAction)buf.m_130066_(ChannelAction.class);
        this.type = buf.readByte();
        this.name = buf.m_130277_();
        this.id = buf.readInt();
    }

    public S2CChannelActionPack(ChannelAction action, byte type, String name, int id) {
        this.action = action;
        this.type = type;
        this.name = name;
        this.id = id;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.action);
        buf.writeByte((int)this.type);
        buf.m_130070_(this.name);
        buf.writeInt(this.id);
    }

    public void run(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            switch (this.action) {
                case ADD: {
                    ClientChannelManager.getInstance().addChannel(this.type, this.id, this.name);
                    break;
                }
                case REMOVE: {
                    ClientChannelManager.getInstance().removeChannel(this.type, this.id, this.name);
                    break;
                }
                case SET: {
                    ClientChannelManager.getInstance().setSelectedChannel(this.type, this.id, this.name);
                }
            }
        }));
        context.get().setPacketHandled(true);
    }
}

