/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.tile;

import committee.nova.mods.avaritia.api.common.tile.BaseTileEntity;
import committee.nova.mods.avaritia.api.util.lang.Localizable;
import committee.nova.mods.avaritia.common.menu.InfinityChestMenu;
import committee.nova.mods.avaritia.core.chest.ServerChestHandler;
import committee.nova.mods.avaritia.core.chest.ServerChestManager;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityChestTile
extends BaseTileEntity
implements LidBlockEntity {
    private UUID owner;
    private boolean locked = false;
    private String filter = "";
    private byte sortType = (byte)4;
    private UUID channelID = UUID.randomUUID();
    private ServerChestHandler channel = new ServerChestHandler();
    private LazyOptional<?> capability = LazyOptional.of(() -> this.channel);
    private final ChestLidController chestLidController = new ChestLidController();

    public InfinityChestTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.infinity_chest_tile.get(), pos, state);
    }

    @NotNull
    public Component m_5446_() {
        return Localizable.of("block.avaritia.infinity_chest").build();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new InfinityChestMenu(containerId, player, this);
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        if (pTag.m_128441_("owner")) {
            this.owner = pTag.m_128342_("owner");
            this.locked = pTag.m_128471_("locked");
        }
        if (pTag.m_128441_("filter")) {
            this.filter = pTag.m_128461_("filter");
        }
        if (pTag.m_128441_("sortType")) {
            this.sortType = pTag.m_128445_("sortType");
        }
        if (pTag.m_128441_("channelID")) {
            this.channelID = pTag.m_128342_("channelID");
        }
        this.channel = ServerChestManager.getInstance().getChest(this.owner, this.channelID);
    }

    public void m_183515_(@NotNull CompoundTag pTag) {
        if (this.owner != null) {
            pTag.m_128362_("owner", this.owner);
            pTag.m_128379_("locked", this.locked);
        }
        pTag.m_128359_("filter", this.filter);
        pTag.m_128344_("sortType", this.sortType);
        pTag.m_128362_("channelID", this.channelID);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.channel.isRemoved()) {
            return LazyOptional.empty();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.m_6596_();
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.m_6596_();
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.m_6596_();
    }

    public void setSortType(byte sortType) {
        this.sortType = sortType;
        this.m_6596_();
    }

    public void setChannelId(UUID id) {
        this.channelID = id;
        this.m_6596_();
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState state, InfinityChestTile blockEntity) {
        blockEntity.chestLidController.m_155374_();
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.chestLidController.m_155377_(type > 0);
            return true;
        }
        return super.m_7531_(id, type);
    }

    public float m_6683_(float partialTicks) {
        return this.chestLidController.m_155375_(partialTicks);
    }

    public static void playSound(Level pLevel, BlockPos pPos, SoundEvent pSound) {
        double d0 = (double)pPos.m_123341_() + 0.5;
        double d1 = (double)pPos.m_123342_() + 0.5;
        double d2 = (double)pPos.m_123343_() + 0.5;
        pLevel.m_6263_(null, d0, d1, d2, pSound, SoundSource.BLOCKS, 0.5f, pLevel.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    @Generated
    public UUID getOwner() {
        return this.owner;
    }

    @Generated
    public boolean isLocked() {
        return this.locked;
    }

    @Generated
    public String getFilter() {
        return this.filter;
    }

    @Generated
    public byte getSortType() {
        return this.sortType;
    }

    @Generated
    public UUID getChannelID() {
        return this.channelID;
    }

    @Generated
    public ServerChestHandler getChannel() {
        return this.channel;
    }

    @Generated
    public LazyOptional<?> getCapability() {
        return this.capability;
    }
}

