/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.tile;

import committee.nova.mods.avaritia.api.common.tile.BaseInventoryTileEntity;
import committee.nova.mods.avaritia.api.common.wrapper.ItemStackWrapper;
import committee.nova.mods.avaritia.api.iface.ITileIO;
import committee.nova.mods.avaritia.api.util.ItemUtils;
import committee.nova.mods.avaritia.api.util.lang.Localizable;
import committee.nova.mods.avaritia.common.block.collector.NeutronCollectorBlock;
import committee.nova.mods.avaritia.common.menu.NeutronCollectorMenu;
import committee.nova.mods.avaritia.core.io.SideConfiguration;
import committee.nova.mods.avaritia.core.io.TileIOHandler;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import committee.nova.mods.avaritia.init.registry.enums.CollectorTier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeutronCollectorTile
extends BaseInventoryTileEntity
implements ITileIO {
    private SideConfiguration sideConfig = new SideConfiguration();
    private int activeOutputTick = 0;
    private static final int ACTIVE_OUTPUT_INTERVAL = 20;
    private final TileIOHandler ioHandler = new TileIOHandler(this, NeutronCollectorBlock.FACING);
    public final ItemStackWrapper inventory;
    public SimpleContainerData data = new SimpleContainerData(1);
    private int progress;
    private CollectorTier tier;

    public NeutronCollectorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.neutron_collector_tile.get(), pos, state);
        this.inventory = NeutronCollectorTile.createInventoryHandler();
        if (state.m_60713_((Block)ModBlocks.neutron_collector.get())) {
            this.tier = CollectorTier.DEFAULT;
        } else if (state.m_60713_((Block)ModBlocks.dense_neutron_collector.get())) {
            this.tier = CollectorTier.DENSE;
        } else if (state.m_60713_((Block)ModBlocks.denser_neutron_collector.get())) {
            this.tier = CollectorTier.DENSER;
        } else if (state.m_60713_((Block)ModBlocks.densest_neutron_collector.get())) {
            this.tier = CollectorTier.DENSEST;
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, NeutronCollectorTile tile) {
        if (!level.m_5776_()) {
            ++tile.activeOutputTick;
            if (tile.activeOutputTick >= 20) {
                tile.activeOutputTick = 0;
                tile.handleActiveOutput();
            }
        }
        if (tile.canWork()) {
            ItemStack result = tile.inventory.getStackInSlot(0);
            ItemStack stack = tile.tier.production.m_43908_()[0];
            ++tile.progress;
            tile.data.m_8050_(0, tile.progress);
            if (tile.progress >= tile.tier.production_ticks) {
                if (result.m_41619_()) {
                    tile.inventory.setStackInSlot(0, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                } else if (result.m_150930_(stack.m_41720_()) && result.m_41613_() < 64) {
                    tile.inventory.setStackInSlot(0, ItemUtils.grow(result, 1));
                }
                tile.progress = 0;
                tile.setChangedAndDispatch();
            }
        }
    }

    public static ItemStackWrapper createInventoryHandler() {
        ItemStackWrapper inventory = new ItemStackWrapper(1, Integer.MAX_VALUE);
        inventory.setOutputSlots(0);
        return inventory;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("progress");
        if (tag.m_128441_("SideConfig")) {
            this.sideConfig = SideConfiguration.fromNBT(tag.m_128469_("SideConfig"));
        }
    }

    @Override
    public void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("progress", this.progress);
        tag.m_128365_("SideConfig", (Tag)this.sideConfig.toNBT());
    }

    @Override
    @NotNull
    public ItemStackWrapper getInventory() {
        return this.inventory;
    }

    protected boolean canWork() {
        return this.inventory.getStackInSlot(0).m_41619_() || this.inventory.getStackInSlot(0).m_41613_() < 64;
    }

    @NotNull
    public Component m_5446_() {
        return Localizable.of("block.avaritia." + this.tier.name).build();
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory) {
        return new NeutronCollectorMenu(windowId, playerInventory, this.m_58899_(), (ContainerData)this.data);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (side != null && cap == ForgeCapabilities.ITEM_HANDLER && !this.ioHandler.shouldAllowPassiveIO(side)) {
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    public CollectorTier getTier() {
        return this.tier;
    }

    public void setTier(CollectorTier tier) {
        this.tier = tier;
    }

    public int getProductionTicks() {
        return this.tier.production_ticks;
    }

    public Item getProduction() {
        return this.tier.production.m_43908_()[0].m_41720_();
    }

    private void handleActiveOutput() {
        this.ioHandler.handleActiveIO();
    }

    @Override
    public SideConfiguration getSideConfiguration() {
        return this.sideConfig;
    }

    @Override
    public void setSideConfiguration(SideConfiguration config) {
        for (Direction direction : Direction.values()) {
            SideConfiguration.SideMode mode = config.getSideMode(direction);
            if (mode == SideConfiguration.SideMode.PASSIVE_OUTPUT || mode == SideConfiguration.SideMode.ACTIVE_OUTPUT) continue;
            config.setSideMode(direction, SideConfiguration.SideMode.OFF);
        }
        this.sideConfig = config;
        this.setChangedAndDispatch();
        if (!this.f_58857_.m_5776_()) {
            NetworkHandler.sendSideConfigSync(this.f_58857_, this.f_58858_, config);
        }
    }

    @Override
    public void setIOChange() {
        this.setChangedAndDispatch();
    }

    @Override
    public void cycleSideModeForNeutronCollector(Direction direction) {
        SideConfiguration.SideMode current = this.sideConfig.getSideMode(direction);
        SideConfiguration.SideMode nextMode = current == SideConfiguration.SideMode.OFF ? SideConfiguration.SideMode.PASSIVE_OUTPUT : (current == SideConfiguration.SideMode.PASSIVE_OUTPUT ? SideConfiguration.SideMode.ACTIVE_OUTPUT : SideConfiguration.SideMode.OFF);
        this.sideConfig.setSideMode(direction, nextMode);
        this.setChangedAndDispatch();
        if (!this.f_58857_.m_5776_()) {
            NetworkHandler.sendSideConfigSync(this.f_58857_, this.f_58858_, this.sideConfig);
        }
    }

    @Override
    public void extractFromHandler(IItemHandler externalHandler, Direction fromSide) {
    }

    @Override
    public void insertToHandler(IItemHandler externalHandler, Direction toSide) {
        ItemStack outputSlot = this.inventory.getStackInSlot(0);
        if (outputSlot.m_41619_()) {
            return;
        }
        ItemStack remaining = outputSlot.m_41777_();
        for (int i = 0; i < externalHandler.getSlots() && !remaining.m_41619_(); ++i) {
            ItemStack insertResult = externalHandler.insertItem(i, remaining, false);
            int transferred = remaining.m_41613_() - insertResult.m_41613_();
            if (transferred <= 0) continue;
            outputSlot.m_41774_(transferred);
            remaining = insertResult;
        }
        if (!remaining.equals(outputSlot)) {
            this.m_6596_();
        }
    }
}

