/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.tile;

import committee.nova.mods.avaritia.api.common.crafting.ICompressorRecipe;
import committee.nova.mods.avaritia.api.common.tile.BaseInventoryTileEntity;
import committee.nova.mods.avaritia.api.common.wrapper.ItemStackWrapper;
import committee.nova.mods.avaritia.api.iface.ITileIO;
import committee.nova.mods.avaritia.api.util.ItemUtils;
import committee.nova.mods.avaritia.api.util.lang.Localizable;
import committee.nova.mods.avaritia.common.block.compressor.NeutronCompressorBlock;
import committee.nova.mods.avaritia.common.menu.NeutronCompressorMenu;
import committee.nova.mods.avaritia.core.io.SideConfiguration;
import committee.nova.mods.avaritia.core.io.TileIOHandler;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import committee.nova.mods.avaritia.init.registry.enums.CompressorTier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeutronCompressorTile
extends BaseInventoryTileEntity
implements ITileIO {
    private SideConfiguration sideConfig = new SideConfiguration();
    private int activeIOtick = 0;
    private static final int ACTIVE_IO_INTERVAL = 20;
    private final TileIOHandler ioHandler = new TileIOHandler(this, NeutronCompressorBlock.FACING);
    private final ItemStackWrapper inventory;
    private final ItemStackWrapper recipeInventory;
    private final SimpleContainerData data = new SimpleContainerData(1);
    private ICompressorRecipe recipe;
    private ItemStack materialStack = ItemStack.f_41583_;
    private int materialCount;
    private int progress;
    private boolean recipeLocked = false;
    private ICompressorRecipe lockedRecipe = null;
    private CompressorTier tier;

    public NeutronCompressorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.neutron_compressor_tile.get(), pos, state);
        this.inventory = NeutronCompressorTile.createInventoryHandler();
        this.recipeInventory = new ItemStackWrapper(1);
        if (state.m_60713_((Block)ModBlocks.neutron_compressor.get())) {
            this.tier = CompressorTier.DEFAULT;
        } else if (state.m_60713_((Block)ModBlocks.dense_neutron_compressor.get())) {
            this.tier = CompressorTier.DENSE;
        } else if (state.m_60713_((Block)ModBlocks.denser_neutron_compressor.get())) {
            this.tier = CompressorTier.DENSER;
        } else if (state.m_60713_((Block)ModBlocks.densest_neutron_compressor.get())) {
            this.tier = CompressorTier.DENSEST;
        }
    }

    public static ItemStackWrapper createInventoryHandler() {
        ItemStackWrapper inventory = new ItemStackWrapper(2);
        inventory.setOutputSlots(0);
        return inventory;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, NeutronCompressorTile tile) {
        ItemStack output = tile.inventory.getStackInSlot(0);
        ItemStack input = tile.inventory.getStackInSlot(1);
        tile.recipeInventory.setStackInSlot(0, tile.materialStack);
        if (!level.m_5776_()) {
            ++tile.activeIOtick;
            if (tile.activeIOtick >= 20) {
                tile.activeIOtick = 0;
                tile.handleActiveIO();
            }
        }
        if (tile.recipeLocked && tile.lockedRecipe != null) {
            tile.recipe = tile.lockedRecipe.m_5818_(tile.recipeInventory.toIInventory(), level) ? tile.lockedRecipe : null;
        } else if (tile.recipe == null || !tile.recipe.m_5818_(tile.recipeInventory.toIInventory(), level)) {
            tile.recipe = level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.COMPRESSOR_RECIPE.get(), tile.recipeInventory.toIInventory(), level).orElse(null);
        }
        if (!level.m_5776_()) {
            if (!input.m_41619_()) {
                if (tile.materialStack.m_41619_() || tile.materialCount <= 0) {
                    tile.materialStack = input.m_41777_();
                    tile.setChangedFast();
                }
                if (tile.recipe != null && (float)tile.materialCount < (float)tile.recipe.getInputCount() * tile.tier.inputAmplifier && ItemUtils.areStacksSameType(input, tile.materialStack)) {
                    int consumeAmount = input.m_41613_();
                    consumeAmount = Math.min(consumeAmount, Mth.m_14167_((float)((float)tile.recipe.getInputCount() * tile.tier.inputAmplifier)) - tile.materialCount);
                    input.m_41774_(consumeAmount);
                    tile.materialCount += consumeAmount;
                    tile.setChangedFast();
                }
            }
            if (tile.recipe != null && (float)tile.materialCount >= (float)tile.recipe.getInputCount() * tile.tier.inputAmplifier) {
                ItemStack result;
                tile.setProgress(tile.progress + 1);
                if ((float)tile.progress >= (float)tile.recipe.getTimeCost() * tile.tier.timeAmplifier && ItemUtils.canCombineStacks(result = tile.recipe.m_5874_(tile.inventory.toIInventory(), level.m_9598_()), output)) {
                    tile.updateResult(result, tile.tier.outputAmplifier);
                    tile.setProgress(0);
                    tile.materialCount -= Mth.m_14167_((float)((float)tile.recipe.getInputCount() * tile.tier.inputAmplifier));
                    if (tile.materialCount <= 0) {
                        tile.materialStack = ItemStack.f_41583_;
                    }
                    tile.setChangedFast();
                }
            }
        }
        tile.dispatchIfChanged();
    }

    @Override
    @NotNull
    public ItemStackWrapper getInventory() {
        return this.inventory;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.materialCount = tag.m_128451_("MaterialCount");
        this.materialStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("MaterialStack"));
        this.setProgress(tag.m_128451_("Progress"));
        this.recipeLocked = tag.m_128471_("RecipeLocked");
        if (tag.m_128441_("SideConfig")) {
            this.sideConfig = SideConfiguration.fromNBT(tag.m_128469_("SideConfig"));
        }
        this.lockedRecipe = null;
    }

    @Override
    public void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("MaterialCount", this.materialCount);
        tag.m_128365_("MaterialStack", (Tag)this.materialStack.serializeNBT());
        tag.m_128405_("Progress", this.progress);
        tag.m_128379_("RecipeLocked", this.recipeLocked);
        tag.m_128365_("SideConfig", (Tag)this.sideConfig.toNBT());
    }

    @NotNull
    public Component m_5446_() {
        return Localizable.of("block.avaritia." + this.tier.name).build();
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory) {
        return new NeutronCompressorMenu(windowId, playerInventory, this.inventory, this.m_58899_(), (ContainerData)this.data);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (side != null && cap == ForgeCapabilities.ITEM_HANDLER && !this.ioHandler.shouldAllowPassiveIO(side)) {
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    public CompressorTier getTier() {
        return this.tier;
    }

    public void setTier(CompressorTier tier) {
        this.tier = tier;
    }

    public ItemStack getMaterialStack() {
        return this.materialStack;
    }

    public boolean hasMaterialStack() {
        return !this.materialStack.m_41619_();
    }

    public int getMaterialCount() {
        return this.materialCount;
    }

    public boolean hasRecipe() {
        return this.recipe != null;
    }

    public ICompressorRecipe getActiveRecipe() {
        return this.recipe;
    }

    public int getMaterialsRequired() {
        if (this.hasRecipe()) {
            return Mth.m_14167_((float)((float)this.recipe.getInputCount() * this.tier.inputAmplifier));
        }
        return 0;
    }

    public int getTimeRequired() {
        if (this.hasRecipe()) {
            return Mth.m_14167_((float)((float)this.recipe.getTimeCost() * this.tier.timeAmplifier));
        }
        return 0;
    }

    private void updateResult(ItemStack stack, int outputAmplifier) {
        ItemStack result = this.inventory.getStackInSlot(0);
        if (result.m_41619_()) {
            this.inventory.setStackInSlot(0, stack.m_255036_(outputAmplifier));
        } else {
            this.inventory.setStackInSlot(0, ItemUtils.grow(result, stack.m_41613_() * outputAmplifier));
        }
    }

    public boolean isRecipeLocked() {
        return this.recipeLocked;
    }

    public void setRecipeLock(boolean locked, ICompressorRecipe recipe) {
        this.recipeLocked = locked;
        this.lockedRecipe = locked && recipe != null ? recipe : null;
        this.setChangedAndDispatch();
    }

    public ICompressorRecipe getLockedRecipe() {
        return this.lockedRecipe;
    }

    public void clearMaterials() {
        this.materialStack = ItemStack.f_41583_;
        this.materialCount = 0;
        this.setProgress(0);
        this.setChangedAndDispatch();
    }

    public boolean canEjectMaterials() {
        return this.materialCount > 0 && (this.recipe == null || (float)this.materialCount < (float)this.recipe.getInputCount() * this.tier.inputAmplifier);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (slot == 1 && this.recipeLocked && this.lockedRecipe != null) {
            NonNullList ingredients = this.lockedRecipe.m_7527_();
            if (!ingredients.isEmpty()) {
                Ingredient ingredient = (Ingredient)ingredients.get(0);
                ItemStack[] items = ingredient.m_43908_();
                return items.length > 0 && stack.m_150930_(items[0].m_41720_());
            }
            return false;
        }
        return true;
    }

    private void handleActiveIO() {
        this.ioHandler.handleActiveIO();
    }

    @Override
    public SideConfiguration getSideConfiguration() {
        return this.sideConfig;
    }

    @Override
    public void setSideConfiguration(SideConfiguration config) {
        this.sideConfig = config;
        this.setChangedAndDispatch();
        if (!this.f_58857_.m_5776_()) {
            NetworkHandler.sendSideConfigSync(this.f_58857_, this.f_58858_, config);
        }
    }

    @Override
    public void cycleSideModeForNeutronCollector(Direction direction) {
        SideConfiguration.SideMode current = this.sideConfig.getSideMode(direction);
        SideConfiguration.SideMode nextMode = current == SideConfiguration.SideMode.OFF ? SideConfiguration.SideMode.PASSIVE_MIXIN : (current == SideConfiguration.SideMode.PASSIVE_MIXIN ? SideConfiguration.SideMode.ACTIVE_INPUT : (current == SideConfiguration.SideMode.ACTIVE_INPUT ? SideConfiguration.SideMode.ACTIVE_OUTPUT : (current == SideConfiguration.SideMode.ACTIVE_OUTPUT ? SideConfiguration.SideMode.ACTIVE_MIXIN : SideConfiguration.SideMode.OFF)));
        this.sideConfig.setSideMode(direction, nextMode);
        this.setChangedAndDispatch();
        if (!this.f_58857_.m_5776_()) {
            NetworkHandler.sendSideConfigSync(this.f_58857_, this.f_58858_, this.sideConfig);
        }
    }

    @Override
    public void setIOChange() {
        this.setChangedAndDispatch();
    }

    @Override
    public void extractFromHandler(IItemHandler externalHandler, Direction fromSide) {
        ItemStack inputSlot = this.inventory.getStackInSlot(1);
        if (!inputSlot.m_41619_() && !ItemUtils.areStacksSameType(inputSlot, this.materialStack)) {
            return;
        }
        for (int i = 0; i < externalHandler.getSlots(); ++i) {
            int inputCount;
            ItemStack stack = externalHandler.getStackInSlot(i);
            if (stack.m_41619_() || !this.materialStack.m_41619_() && !ItemUtils.areStacksSameType(stack, this.materialStack)) continue;
            int maxTransfer = Math.min(stack.m_41613_(), 64);
            int spaceInInput = this.materialStack.m_41619_() ? 64 : (int)((float)this.recipe.getInputCount() * this.tier.inputAmplifier - (float)this.materialCount);
            int n = inputCount = inputSlot.m_41619_() ? 64 : inputSlot.m_41741_() - inputSlot.m_41613_();
            if (spaceInInput + inputCount <= 0) break;
            int transferAmount = Math.min(maxTransfer, spaceInInput + inputCount);
            ItemStack extractedStack = externalHandler.extractItem(i, transferAmount, false);
            if (extractedStack.m_41619_()) continue;
            if (this.materialStack.m_41619_()) {
                this.materialStack = extractedStack.m_41777_();
            }
            if (inputSlot.m_41619_()) {
                this.inventory.setStackInSlot(1, extractedStack.m_41777_());
            } else {
                inputSlot.m_41769_(extractedStack.m_41613_());
            }
            this.m_6596_();
            break;
        }
    }

    @Override
    public void insertToHandler(IItemHandler externalHandler, Direction toSide) {
        ItemStack outputSlot = this.inventory.getStackInSlot(0);
        if (outputSlot.m_41619_()) {
            return;
        }
        ItemStack remaining = outputSlot.m_41777_();
        for (int i = 0; i < externalHandler.getSlots() && !remaining.m_41619_(); ++i) {
            ItemStack insertResult = externalHandler.insertItem(i, remaining, false);
            int transferred = remaining.m_41613_() - insertResult.m_41613_();
            if (transferred <= 0) continue;
            outputSlot.m_41774_(transferred);
            remaining = insertResult;
        }
        if (!remaining.equals(outputSlot)) {
            this.m_6596_();
        }
    }

    private void setProgress(int progress) {
        this.progress = progress;
        this.data.m_8050_(0, this.progress);
    }
}

