/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.chest;

import committee.nova.mods.avaritia.util.StorageUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class ChestHandler
implements IItemHandler {
    public final HashMap<String, Long> storageItems = new HashMap();
    protected final Map<String, Tag> nbtDataCache = new HashMap<String, Tag>();
    private ItemStack[] slotItemTemp = new ItemStack[]{ItemStack.f_41583_};
    private String[] itemKeys = new String[0];

    public abstract boolean isRemoved();

    public void onItemChanged(String itemId, boolean listChanged) {
        if (listChanged) {
            this.updateItemKeys();
        }
    }

    public void updateItemKeys() {
        this.itemKeys = this.storageItems.keySet().toArray(new String[0]);
        this.slotItemTemp = new ItemStack[this.itemKeys.length];
        for (int i = 0; i < this.itemKeys.length; ++i) {
            Tag nbtData;
            String key = this.itemKeys[i];
            ItemStack stack = new ItemStack((ItemLike)StorageUtils.getItem(key));
            if (key.contains("#") && (nbtData = this.nbtDataCache.get(key)) instanceof CompoundTag) {
                CompoundTag tag = (CompoundTag)nbtData;
                stack.m_41751_(tag);
            }
            this.slotItemTemp[i] = stack;
        }
    }

    public boolean hasItem(String item) {
        return this.storageItems.containsKey(item);
    }

    public int getItemAmount(String item) {
        return (int)Long.min(Integer.MAX_VALUE, this.storageItems.getOrDefault(item, 0L));
    }

    public long getRealItemAmount(String item) {
        return this.storageItems.getOrDefault(item, 0L);
    }

    public int getStorageAmount(Item item) {
        String itemId = StorageUtils.getItemId(item);
        long total = 0L;
        for (Map.Entry<String, Long> entry : this.storageItems.entrySet()) {
            String key = entry.getKey();
            if (!StorageUtils.getBaseItemId(key).equals(itemId)) continue;
            total += entry.getValue().longValue();
        }
        return (int)Long.min(Integer.MAX_VALUE, total);
    }

    public int canStorageAmount(ItemStack itemStack) {
        String itemId = StorageUtils.getNbtItemId(itemStack);
        long a = this.storageItems.getOrDefault(itemId, 0L);
        if (a == 0L) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.min(Integer.MAX_VALUE, Long.MAX_VALUE - a);
    }

    public boolean canStorageItem(String item) {
        if (this.storageItems.containsKey(item)) {
            return this.storageItems.get(item) < Long.MAX_VALUE;
        }
        return true;
    }

    public int canStorageItemAmount(String item) {
        long a = this.storageItems.getOrDefault(item, 0L);
        if (a == 0L) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.min(Integer.MAX_VALUE, Long.MAX_VALUE - a);
    }

    public int addItem(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return 0;
        }
        String itemId = StorageUtils.getNbtItemId(itemStack);
        int count = itemStack.m_41613_();
        if (itemStack.m_41782_() && !this.nbtDataCache.containsKey(itemId)) {
            this.nbtDataCache.put(itemId, (Tag)itemStack.m_41783_().m_6426_());
        }
        if (this.storageItems.containsKey(itemId)) {
            long storageCount = this.storageItems.get(itemId);
            long remainingSpaces = Long.MAX_VALUE - storageCount;
            if (remainingSpaces >= (long)itemStack.m_41613_()) {
                this.storageItems.replace(itemId, storageCount + (long)itemStack.m_41613_());
                itemStack.m_41764_(0);
                this.onItemChanged(itemId, false);
                return count;
            }
            this.storageItems.replace(itemId, Long.MAX_VALUE);
            itemStack.m_41764_(itemStack.m_41613_() - (int)remainingSpaces);
            this.onItemChanged(itemId, false);
            return (int)remainingSpaces;
        }
        this.storageItems.put(itemId, Long.valueOf(itemStack.m_41613_()));
        itemStack.m_41764_(0);
        this.onItemChanged(itemId, true);
        return count;
    }

    public long addItem(String itemId, long count) {
        if (itemId.equals("minecraft:air") || count == 0L) {
            return 0L;
        }
        if (this.storageItems.containsKey(itemId)) {
            long storageCount = this.storageItems.get(itemId);
            long remainingSpaces = Long.MAX_VALUE - storageCount;
            if (remainingSpaces >= count) {
                this.storageItems.replace(itemId, storageCount + count);
                this.onItemChanged(itemId, false);
                return count;
            }
            this.storageItems.replace(itemId, Long.MAX_VALUE);
            this.onItemChanged(itemId, false);
            return remainingSpaces;
        }
        this.storageItems.put(itemId, count);
        this.onItemChanged(itemId, true);
        return count;
    }

    public void fillItemStack(ItemStack itemStack, int count) {
        if (itemStack.m_41619_() || count == 0) {
            return;
        }
        String itemId = StorageUtils.getNbtItemId(itemStack);
        if (itemStack.m_41782_() && !this.nbtDataCache.containsKey(itemId) && count < 0) {
            this.nbtDataCache.put(itemId, (Tag)itemStack.m_41783_().m_6426_());
        }
        if (this.storageItems.containsKey(itemId)) {
            long storageCount = this.storageItems.get(itemId);
            long remainingSpaces = Long.MAX_VALUE - storageCount;
            if ((long)count >= storageCount) {
                this.storageItems.remove(itemId);
                if (this.nbtDataCache.containsKey(itemId)) {
                    this.nbtDataCache.remove(itemId);
                }
                itemStack.m_41764_(itemStack.m_41613_() + (int)storageCount);
                this.onItemChanged(itemId, true);
            } else if (remainingSpaces < (long)(-count)) {
                this.storageItems.replace(itemId, Long.MAX_VALUE);
                itemStack.m_41764_(itemStack.m_41613_() - (int)remainingSpaces);
                this.onItemChanged(itemId, false);
            } else {
                this.storageItems.replace(itemId, storageCount - (long)count);
                itemStack.m_41764_(itemStack.m_41613_() + count);
                this.onItemChanged(itemId, false);
            }
        } else if (count < 0) {
            this.storageItems.put(itemId, Long.valueOf(-count));
            itemStack.m_41764_(itemStack.m_41613_() + count);
            this.onItemChanged(itemId, true);
        }
    }

    public ItemStack takeItem(String itemId, int count) {
        if (!this.storageItems.containsKey(itemId) || itemId.equals("minecraft:air") || count == 0) {
            return ItemStack.f_41583_;
        }
        long storageCount = this.storageItems.get(itemId);
        if ((long)count < storageCount) {
            this.storageItems.replace(itemId, storageCount - (long)count);
            this.onItemChanged(itemId, false);
        } else {
            this.storageItems.remove(itemId);
            count = (int)storageCount;
            this.onItemChanged(itemId, true);
        }
        ItemStack result = new ItemStack((ItemLike)StorageUtils.getItem(itemId), count);
        if (this.nbtDataCache.containsKey(itemId)) {
            Tag nbtData = this.nbtDataCache.get(itemId);
            if (nbtData instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)nbtData;
                result.m_41751_(compoundTag);
            }
            this.nbtDataCache.remove(itemId);
        }
        return result;
    }

    public ItemStack saveTakeItem(String itemId, int count) {
        long storageCount;
        if (!this.storageItems.containsKey(itemId) || itemId.equals("minecraft:air") || count == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = new ItemStack((ItemLike)StorageUtils.getItem(itemId), 1);
        if ((long)(count = Integer.min(count, itemStack.m_41741_())) < (storageCount = this.storageItems.get(itemId).longValue())) {
            this.storageItems.replace(itemId, storageCount - (long)count);
            this.onItemChanged(itemId, false);
        } else {
            this.storageItems.remove(itemId);
            count = (int)storageCount;
            this.onItemChanged(itemId, true);
        }
        itemStack.m_41764_(count);
        if (this.nbtDataCache.containsKey(itemId)) {
            Tag nbtData = this.nbtDataCache.get(itemId);
            if (nbtData instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)nbtData;
                itemStack.m_41751_(compoundTag);
            }
            this.nbtDataCache.remove(itemId);
        }
        return itemStack;
    }

    public ItemStack saveTakeItem(String itemId, boolean half) {
        long storageCount;
        if (!this.storageItems.containsKey(itemId)) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = new ItemStack((ItemLike)StorageUtils.getItem(itemId), 1);
        int count = half ? (itemStack.m_41741_() + 1) / 2 : itemStack.m_41741_();
        if ((long)count < (storageCount = this.storageItems.get(itemId).longValue())) {
            this.storageItems.replace(itemId, storageCount - (long)count);
            this.onItemChanged(itemId, false);
        } else {
            this.storageItems.remove(itemId);
            count = (int)storageCount;
            this.onItemChanged(itemId, true);
        }
        itemStack.m_41764_(count);
        if (this.nbtDataCache.containsKey(itemId)) {
            Tag nbtData = this.nbtDataCache.get(itemId);
            if (nbtData instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)nbtData;
                itemStack.m_41751_(compoundTag);
            }
            this.nbtDataCache.remove(itemId);
        }
        return itemStack;
    }

    public void removeItem(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return;
        }
        String itemId = StorageUtils.getNbtItemId(itemStack);
        if (!this.storageItems.containsKey(itemId)) {
            return;
        }
        long storageCount = this.storageItems.get(itemId);
        if ((long)itemStack.m_41613_() < storageCount) {
            this.storageItems.replace(itemId, storageCount - (long)itemStack.m_41613_());
            this.onItemChanged(itemId, false);
        } else {
            this.storageItems.remove(itemId);
            if (this.nbtDataCache.containsKey(itemId)) {
                this.nbtDataCache.remove(itemId);
            }
            this.onItemChanged(itemId, true);
        }
    }

    public void removeItem(String itemId, long count) {
        if (!this.storageItems.containsKey(itemId)) {
            return;
        }
        long storageCount = this.storageItems.get(itemId);
        if (count < storageCount) {
            this.storageItems.replace(itemId, storageCount - count);
            this.onItemChanged(itemId, false);
        } else {
            this.storageItems.remove(itemId);
            if (this.nbtDataCache.containsKey(itemId)) {
                this.nbtDataCache.remove(itemId);
            }
            this.onItemChanged(itemId, true);
        }
    }

    public boolean isEmpty() {
        return this.storageItems.isEmpty();
    }

    public int getSlots() {
        return this.storageItems.size() + 54;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        Tag nbtData;
        if (slot >= this.itemKeys.length + 27 || slot < 27) {
            return ItemStack.f_41583_;
        }
        String itemKey = this.itemKeys[slot - 27];
        ItemStack itemStack = this.slotItemTemp[slot - 27].m_41777_();
        itemStack.m_41764_((int)Math.min(Integer.MAX_VALUE, this.storageItems.get(itemKey)));
        if (itemKey.contains("#") && this.nbtDataCache.containsKey(itemKey) && (nbtData = this.nbtDataCache.get(itemKey)) instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)nbtData;
            itemStack.m_41751_(compoundTag);
        }
        return itemStack;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return stack;
        }
        String itemId = StorageUtils.getNbtItemId(stack);
        ItemStack remainingStack = ItemStack.f_41583_;
        if (stack.m_41782_() && !this.nbtDataCache.containsKey(itemId)) {
            this.nbtDataCache.put(itemId, (Tag)stack.m_41783_().m_6426_());
        }
        if (this.storageItems.containsKey(itemId)) {
            long storageCount = this.storageItems.get(itemId);
            long remainingSpaces = Long.MAX_VALUE - storageCount;
            if (remainingSpaces >= (long)stack.m_41613_()) {
                if (!simulate) {
                    this.storageItems.replace(itemId, storageCount + (long)stack.m_41613_());
                }
            } else {
                if (!simulate) {
                    this.storageItems.replace(itemId, Long.MAX_VALUE);
                }
                remainingStack = stack.m_41777_();
                remainingStack.m_41764_(stack.m_41613_() - (int)remainingSpaces);
            }
            if (!simulate) {
                this.onItemChanged(itemId, false);
            }
        } else if (!simulate) {
            this.storageItems.put(itemId, Long.valueOf(stack.m_41613_()));
            this.onItemChanged(itemId, true);
        }
        return remainingStack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        Tag nbtData;
        long storageCount;
        if (slot >= this.itemKeys.length + 27 || slot < 27) {
            return ItemStack.f_41583_;
        }
        String itemId = this.itemKeys[slot - 27];
        if (!this.storageItems.containsKey(itemId)) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = new ItemStack((ItemLike)StorageUtils.getItem(itemId), 1);
        int count = Math.min(itemStack.m_41741_(), amount);
        if ((long)count < (storageCount = this.storageItems.get(itemId).longValue())) {
            if (!simulate) {
                this.storageItems.replace(itemId, storageCount - (long)count);
                this.onItemChanged(itemId, false);
            }
        } else {
            if (!simulate) {
                this.storageItems.remove(itemId);
                if (this.nbtDataCache.containsKey(itemId)) {
                    this.nbtDataCache.remove(itemId);
                }
                this.onItemChanged(itemId, true);
            }
            count = (int)storageCount;
        }
        itemStack.m_41764_(count);
        if (this.nbtDataCache.containsKey(itemId) && (nbtData = this.nbtDataCache.get(itemId)) instanceof CompoundTag) {
            itemStack.m_41751_((CompoundTag)nbtData);
        }
        return itemStack;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return !stack.m_41619_();
    }
}

