/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.chest;

import committee.nova.mods.avaritia.core.chest.ChestHandler;
import committee.nova.mods.avaritia.core.chest.InfinityChestContainer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class ClientChestHandler
extends ChestHandler {
    @Nullable
    public InfinityChestContainer container;

    public void addListener(InfinityChestContainer container) {
        this.container = container;
    }

    public void removeListener() {
        this.container = null;
        this.storageItems.clear();
        this.nbtDataCache.clear();
    }

    @Override
    public void onItemChanged(String itemId, boolean listChanged) {
        super.onItemChanged(itemId, listChanged);
        if (this.container != null) {
            this.container.refreshContainer(listChanged);
        }
    }

    public void update(CompoundTag tag) {
        if (this.container == null) {
            return;
        }
        CompoundTag items = tag.m_128469_("items");
        CompoundTag nbtData = tag.m_128441_("nbtData") ? tag.m_128469_("nbtData") : null;
        AtomicBoolean fullUpdate = new AtomicBoolean(false);
        AtomicBoolean needRefreshContainer = new AtomicBoolean(false);
        items.m_128431_().forEach(itemId -> {
            long count = items.m_128454_(itemId);
            if (count <= 0L) {
                if (this.storageItems.containsKey(itemId)) {
                    this.storageItems.remove(itemId);
                    this.nbtDataCache.remove(itemId);
                    fullUpdate.set(true);
                    needRefreshContainer.set(true);
                }
            } else if (this.storageItems.containsKey(itemId)) {
                if ((Long)this.storageItems.get(itemId) != count) {
                    this.storageItems.replace(itemId, count);
                    needRefreshContainer.set(true);
                }
            } else {
                this.storageItems.put(itemId, count);
                fullUpdate.set(true);
                needRefreshContainer.set(true);
            }
        });
        if (nbtData != null) {
            nbtData.m_128431_().forEach(itemId -> {
                Tag nbtTag = nbtData.m_128423_(itemId);
                if (nbtTag instanceof CompoundTag) {
                    this.nbtDataCache.put(itemId, nbtTag);
                }
            });
        }
        if (needRefreshContainer.get()) {
            this.container.refreshContainer(fullUpdate.get());
        }
        if (fullUpdate.get()) {
            this.updateItemKeys();
        }
    }

    public void fullUpdate(CompoundTag tag) {
        CompoundTag items = tag.m_128469_("items");
        CompoundTag nbtData = tag.m_128441_("nbtData") ? tag.m_128469_("nbtData") : null;
        this.storageItems.clear();
        this.nbtDataCache.clear();
        items.m_128431_().forEach(itemId -> this.storageItems.put(itemId, items.m_128454_(itemId)));
        if (nbtData != null) {
            nbtData.m_128431_().forEach(itemId -> {
                Tag nbtTag = nbtData.m_128423_(itemId);
                if (nbtTag instanceof CompoundTag) {
                    this.nbtDataCache.put(itemId, nbtTag);
                }
            });
        }
        this.updateItemKeys();
        if (this.container != null) {
            this.container.refreshContainer(true);
        }
    }

    @Override
    public boolean isRemoved() {
        return false;
    }
}

