/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.chest;

import committee.nova.mods.avaritia.common.menu.InfinityChestMenu;
import committee.nova.mods.avaritia.util.SortUtils;
import committee.nova.mods.avaritia.util.StorageUtils;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class InfinityChestContainer
extends SimpleContainer {
    public static final int SIZE = 135;
    public static final int WIDTH = 15;
    public static final int HEIGHT = 9;
    public final ArrayList<String> sortedObject = new ArrayList();
    public final ArrayList<String> viewingObject = new ArrayList();
    public final ArrayList<String> formatCount = new ArrayList();
    private final InfinityChestMenu menu;
    public ArrayList<String> sortedItems = new ArrayList();
    private double scrollTo = 0.0;

    public InfinityChestContainer(InfinityChestMenu menu) {
        super(135);
        this.menu = menu;
    }

    public void onChangeItems() {
        this.sortedObject.clear();
        this.sortedObject.addAll(this.sortedItems);
        this.scrollOffset(0);
    }

    public void onScrollTo(double scrollTo) {
        this.scrollTo = scrollTo;
        this.scrollOffset(0);
    }

    public double getScrollOn() {
        return this.scrollTo;
    }

    public void scrollOffset(int offset) {
        if (this.sortedObject.size() <= 135) {
            this.viewingObject.clear();
            this.viewingObject.addAll(this.sortedObject);
        } else {
            int i = (int)Math.ceil(this.sortedObject.size() / 15);
            int j = Math.round((float)(i -= 9) * (float)this.scrollTo);
            if (offset != 0) {
                j += offset;
                j = Math.max(0, Math.min(i, j));
                this.scrollTo = (double)j / (double)i;
            }
            this.viewingObject.clear();
            this.viewingObject.addAll(this.sortedObject.subList(j * 15, Math.min(this.sortedObject.size(), j * 15 + 135)));
        }
        this.updateDummySlots(true);
    }

    public double onMouseScrolled(boolean isUp) {
        if (isUp) {
            this.scrollOffset(-1);
        } else {
            this.scrollOffset(1);
        }
        return this.scrollTo;
    }

    public void refreshContainer(boolean fullUpdate) {
        if (!this.menu.level.f_46443_) {
            return;
        }
        if ((fullUpdate || this.menu.sortType >= 6) && !this.menu.LShifting) {
            this.sortedItems = new ArrayList<String>(this.menu.chest.storageItems.keySet());
            if (!this.menu.filter.isEmpty()) {
                ArrayList<String> temp = new ArrayList<String>();
                char head = this.menu.filter.charAt(0);
                if (head == '*') {
                    String s = this.menu.filter.substring(1);
                    for (String itemName : this.sortedItems) {
                        if (!itemName.contains(s)) continue;
                        temp.add(itemName);
                    }
                } else if (head == '$') {
                    String s = this.menu.filter.substring(1);
                    block11: for (String itemName : this.sortedItems) {
                        ItemStack itemStack = new ItemStack((ItemLike)StorageUtils.getItem(itemName));
                        ArrayList tags = new ArrayList();
                        itemStack.m_204131_().forEach(itemTagKey -> tags.add(itemTagKey.f_203868_().m_135815_()));
                        for (String tag : tags) {
                            if (!tag.contains(s)) continue;
                            temp.add(itemName);
                            continue block11;
                        }
                    }
                } else {
                    for (String itemName : this.sortedItems) {
                        if (itemName.contains(this.menu.filter)) {
                            temp.add(itemName);
                            continue;
                        }
                        ItemStack itemStack = new ItemStack((ItemLike)StorageUtils.getItem(itemName));
                        if (!itemStack.m_41611_().getString().toLowerCase().contains(this.menu.filter)) continue;
                        temp.add(itemName);
                    }
                }
                this.sortedItems = temp;
            }
            switch (this.menu.sortType) {
                case 0: {
                    this.sortedItems.sort(SortUtils::sortFromRightID);
                    break;
                }
                case 1: {
                    this.sortedItems.sort(Collections.reverseOrder(SortUtils::sortFromRightID));
                    break;
                }
                case 2: {
                    this.sortedItems.sort(String::compareTo);
                    break;
                }
                case 3: {
                    this.sortedItems.sort(Collections.reverseOrder(String::compareTo));
                    break;
                }
                case 4: {
                    this.sortedItems.sort(SortUtils::sortFromMirrorID);
                    break;
                }
                case 5: {
                    this.sortedItems.sort(Collections.reverseOrder(SortUtils::sortFromMirrorID));
                    break;
                }
                case 6: {
                    this.sortedItems.sort((s1, s2) -> SortUtils.sortFromCount(s1, s2, this.menu.chest.storageItems, false));
                    break;
                }
                case 7: {
                    this.sortedItems.sort((s1, s2) -> SortUtils.sortFromCount(s1, s2, this.menu.chest.storageItems, true));
                }
            }
            this.onChangeItems();
            return;
        }
        this.updateDummySlots(fullUpdate);
    }

    public void updateDummySlots(boolean fullUpdate) {
        this.formatCount.clear();
        for (int j = 0; j < 135; ++j) {
            if (j < this.viewingObject.size() && this.viewingObject.get(j) != null) {
                String id = this.viewingObject.get(j);
                if (fullUpdate) {
                    if (j < this.menu.chest.getSlots()) {
                        ItemStack stack = this.menu.chest.getStackInSlot(j + 27);
                        this.m_6836_(j, stack);
                    } else {
                        ItemStack stack = new ItemStack((ItemLike)StorageUtils.getItem(id));
                        this.m_6836_(j, stack);
                    }
                }
                if (!this.menu.chest.storageItems.containsKey(id)) {
                    this.formatCount.add(j, "\u00a7c0");
                    continue;
                }
                long count = this.menu.chest.storageItems.get(id);
                if (count < 1000L) {
                    this.formatCount.add(j, String.valueOf(count));
                    continue;
                }
                if (count < Long.MAX_VALUE) {
                    Object stringCount = StorageUtils.DECIMAL_FORMAT.format(count);
                    if (((String)(stringCount = ((String)stringCount).substring(0, 4))).endsWith(",")) {
                        stringCount = ((String)stringCount).substring(0, 3);
                    }
                    stringCount = ((String)stringCount).replace(",", ".");
                    stringCount = count < 1000000L ? (String)stringCount + "K" : (count < 1000000000L ? (String)stringCount + "M" : (count < 1000000000000L ? (String)stringCount + "G" : (count < 1000000000000000L ? (String)stringCount + "T" : (count < 1000000000000000000L ? (String)stringCount + "P" : (String)stringCount + "E"))));
                    this.formatCount.add(j, (String)stringCount);
                    continue;
                }
                this.formatCount.add(j, "MAX");
                continue;
            }
            this.m_6836_(j, ItemStack.f_41583_);
        }
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        if (index < 0 || index >= this.viewingObject.size()) {
            return ItemStack.f_41583_;
        }
        String itemId = this.viewingObject.get(index);
        if (itemId == null || itemId.isEmpty()) {
            return ItemStack.f_41583_;
        }
        long count = this.menu.chest.storageItems.getOrDefault(itemId, 0L);
        Tag tag = this.menu.chest.nbtDataCache.get(itemId);
        ItemStack itemStack = new ItemStack((ItemLike)StorageUtils.getItem(itemId), (int)Math.min(Integer.MAX_VALUE, count));
        if (tag instanceof CompoundTag) {
            CompoundTag cTag = (CompoundTag)tag;
            itemStack.m_41751_(cTag);
        }
        return itemStack;
    }

    public void m_6596_() {
    }

    public int m_6893_() {
        return Integer.MAX_VALUE;
    }
}

