/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.singularity;

import committee.nova.mods.avaritia.core.singularity.Singularity;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.loading.FMLLoader;

public class SingularityBuilder {
    private final String modId;
    private final String name;
    private int[] colors = new int[]{0xFFFFFF, 0xCCCCCC};
    private Ingredient ingredient = Ingredient.f_43901_;
    private String tag = null;
    private int ingredientCount = -1;
    private int timeRequired = FMLLoader.isProduction() ? 240 : 10;
    private boolean enabled = true;
    private boolean recipeDisabled = false;

    public SingularityBuilder(String modId, String name) {
        this.modId = Objects.requireNonNull(modId, "\u6a21\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a\u55b5\uff5e");
        this.name = Objects.requireNonNull(name, "\u5947\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u55b5\uff5e");
    }

    public SingularityBuilder colors(int primaryColor, int secondaryColor) {
        this.colors = new int[]{primaryColor, secondaryColor};
        return this;
    }

    public SingularityBuilder color(int color) {
        this.colors = new int[]{color, color};
        return this;
    }

    public SingularityBuilder ingredient(Ingredient ingredient) {
        this.ingredient = Objects.requireNonNull(ingredient, "\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a\u55b5\uff5e");
        this.tag = null;
        return this;
    }

    public SingularityBuilder ingredient(Item item) {
        return this.ingredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Objects.requireNonNull(item, "\u7269\u54c1\u4e0d\u80fd\u4e3a\u7a7a\u55b5\uff5e")}));
    }

    public SingularityBuilder tag(String tag) {
        this.tag = Objects.requireNonNull(tag, "\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a\u55b5\uff5e");
        this.ingredient = Ingredient.f_43901_;
        return this;
    }

    public SingularityBuilder ingredientCount(int count) {
        this.ingredientCount = count;
        return this;
    }

    public SingularityBuilder timeRequired(int time) {
        this.timeRequired = Math.max(0, time);
        return this;
    }

    public SingularityBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public SingularityBuilder recipeDisabled(boolean recipeDisabled) {
        this.recipeDisabled = recipeDisabled;
        return this;
    }

    public Singularity build() {
        ResourceLocation id = new ResourceLocation(this.modId, this.name);
        String translationKey = String.format("singularity.%s.%s", this.modId, this.name);
        Singularity singularity = this.tag != null ? new Singularity(id, translationKey, this.colors, this.tag, this.ingredientCount, this.timeRequired) : new Singularity(id, translationKey, this.colors, this.ingredient, this.ingredientCount, this.timeRequired);
        singularity.setEnabled(this.enabled);
        singularity.setRecipeDisabled(this.recipeDisabled);
        return singularity;
    }
}

