/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ModConfig {
    public static final ForgeConfigSpec COMMON;
    public static final ForgeConfigSpec.DoubleValue foodTime;
    public static final ForgeConfigSpec.BooleanValue isKeepStone;
    public static final ForgeConfigSpec.BooleanValue isMergeMatterCluster;
    public static final ForgeConfigSpec.IntValue swordRangeDamage;
    public static final ForgeConfigSpec.IntValue swordAttackRange;
    public static final ForgeConfigSpec.BooleanValue isSwordAttackItemEntity;
    public static final ForgeConfigSpec.BooleanValue isSwordAttackLightning;
    public static final ForgeConfigSpec.BooleanValue isSwordAttackEndless;
    public static final ForgeConfigSpec.IntValue subArrowDamage;
    public static final ForgeConfigSpec.IntValue axeChainCount;
    public static final ForgeConfigSpec.IntValue pickAxeBreakRange;
    public static final ForgeConfigSpec.IntValue shovelBreakRange;
    public static final ForgeConfigSpec.IntValue neutronCollectorProductTick;
    public static final ForgeConfigSpec.IntValue singularityTimeRequired;
    public static final ForgeConfigSpec.DoubleValue growthSoulFarmland;
    public static final ForgeConfigSpec.IntValue bladeSlashDamage;
    public static final ForgeConfigSpec.IntValue bladeSlashRadius;
    public static final ForgeConfigSpec.BooleanValue internalInfinityCatalystCraft;
    public static final ForgeConfigSpec.DoubleValue immortalItemEntitySpeed;
    public static final ForgeConfigSpec.DoubleValue immortalItemEntityRange;
    public static final ForgeConfigSpec.DoubleValue infinityElytraFlyingSpeed;
    public static final ForgeConfigSpec.DoubleValue bootSpeedBase;
    public static final ForgeConfigSpec.DoubleValue bootSpeedFlyingMultiplier;
    public static final ForgeConfigSpec.DoubleValue bootSpeedSwimmingMultiplier;
    public static final ForgeConfigSpec.DoubleValue bootSpeedSneakingMultiplier;
    public static final ForgeConfigSpec.DoubleValue bootSpeedBackwardMultiplier;
    public static final ForgeConfigSpec.DoubleValue bootSpeedStrafingMultiplier;
    public static final ForgeConfigSpec.DoubleValue bootSpeedSprintingMultiplier;
    public static final ForgeConfigSpec.IntValue neutronPileEmc;
    public static final ForgeConfigSpec.IntValue vanillaTotemEmc;
    public static final ForgeConfigSpec.IntValue chestMaxItemSize;
    public static final ForgeConfigSpec.BooleanValue useSinglePageMode;
    public static final ForgeConfigSpec.LongValue slotStackLimit;
    public static final ForgeConfigSpec.IntValue maxPageLimit;
    public static final ForgeConfigSpec.IntValue resetMaxPage;
    public static final ForgeConfigSpec.IntValue inventoryRows;
    public static ForgeConfigSpec.IntValue MAX_SIZE_PRE_CHANNEL;
    public static ForgeConfigSpec.IntValue MAX_CHANNELS_PRE_PLAYER;
    public static ForgeConfigSpec.IntValue MAX_PUBLIC_CHANNELS;
    public static ForgeConfigSpec.IntValue CHANNEL_FAST_UPDATE_RATE;
    public static ForgeConfigSpec.IntValue CHANNEL_FULL_UPDATE_RATE;
    public static final ForgeConfigSpec.BooleanValue useAdvanceTooltips;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON);
    }

    private static ForgeConfigSpec.BooleanValue buildBoolean(ForgeConfigSpec.Builder builder, String name, boolean defaultValue, String comment) {
        return builder.comment(comment).translation(name).define(name, defaultValue);
    }

    private static ForgeConfigSpec.IntValue buildInt(ForgeConfigSpec.Builder builder, String name, int defaultValue, int min, int max, String comment) {
        return builder.comment(comment).translation(name).defineInRange(name, defaultValue, min, max);
    }

    private static ForgeConfigSpec.DoubleValue buildDouble(ForgeConfigSpec.Builder builder, String name, double defaultValue, double min, double max, String comment) {
        return builder.comment(comment).translation(name).defineInRange(name, defaultValue, min, max);
    }

    private static ForgeConfigSpec.LongValue buildLong(ForgeConfigSpec.Builder builder, String name, long defaultValue, long min, long max, String comment) {
        return builder.comment(comment).translation(name).defineInRange(name, defaultValue, min, max);
    }

    static {
        ForgeConfigSpec.Builder common = new ForgeConfigSpec.Builder();
        common.comment("Avaritia Common Config");
        common.push("tools");
        isKeepStone = ModConfig.buildBoolean(common, "config.avaritia.is_keep_stone", false, "config.avaritia.is_keep_stone.tooltip");
        isMergeMatterCluster = ModConfig.buildBoolean(common, "config.avaritia.is_merge_matter_cluster", true, "config.avaritia.is_merge_matter_cluster.tooltip");
        swordRangeDamage = ModConfig.buildInt(common, "config.avaritia.sword_range_damage", 10000, 100, 100000, "config.avaritia.sword_range_damage.tooltip");
        swordAttackRange = ModConfig.buildInt(common, "config.avaritia.sword_attack_range", 32, 8, 64, "config.avaritia.sword_attack_range.tooltip");
        isSwordAttackItemEntity = ModConfig.buildBoolean(common, "config.avaritia.is_sword_attack_item_entity", false, "config.avaritia.is_sword_attack_item_entity.tooltip");
        isSwordAttackLightning = ModConfig.buildBoolean(common, "config.avaritia.is_sword_attack_lightning", false, "config.avaritia.is_sword_attack_lightning.tooltip");
        isSwordAttackEndless = ModConfig.buildBoolean(common, "config.avaritia.is_sword_attack_endless", true, "config.avaritia.is_sword_attack_endless.tooltip");
        subArrowDamage = ModConfig.buildInt(common, "config.avaritia.sub_arrow_damage", 10000, 100, 100000, "config.avaritia.sub_arrow_damage.tooltip");
        axeChainCount = ModConfig.buildInt(common, "config.avaritia.axe_chain_count", 64, 16, 128, "config.avaritia.axe_chain_count.tooltip");
        foodTime = ModConfig.buildDouble(common, "config.avaritia.food_time", 1.0, 0.1, 5.0, "config.avaritia.food_time.tooltip");
        pickAxeBreakRange = ModConfig.buildInt(common, "config.avaritia.pickaxe_break_range", 8, 2, 32, "config.avaritia.pickaxe_break_range.tooltip");
        shovelBreakRange = ModConfig.buildInt(common, "config.avaritia.shovel_break_range", 8, 2, 32, "config.avaritia.shovel_break_range.tooltip");
        neutronCollectorProductTick = ModConfig.buildInt(common, "config.avaritia.neutron_collector_product_tick", 3600, 1200, Integer.MAX_VALUE, "config.avaritia.neutron_collector_product_tick.tooltip");
        singularityTimeRequired = ModConfig.buildInt(common, "config.avaritia.singularity_time_required", 240, 0, Integer.MAX_VALUE, "config.avaritia.singularity_time_required.tooltip");
        growthSoulFarmland = ModConfig.buildDouble(common, "config.avaritia.growth_soul_farmland", 0.8, 0.0, 1.0, "config.avaritia.growth_soul_farmland.tooltip");
        bladeSlashDamage = ModConfig.buildInt(common, "config.avaritia.blade_slash_damage", 200, 0, Integer.MAX_VALUE, "config.avaritia.blade_slash_damage.tooltip");
        bladeSlashRadius = ModConfig.buildInt(common, "config.avaritia.blade_slash_radius", 10, 5, 100, "config.avaritia.blade_slash_radius.tooltip");
        internalInfinityCatalystCraft = ModConfig.buildBoolean(common, "config.avaritia.internal_infinity_catalyst_craft", true, "config.avaritia.internal_infinity_catalyst_craft.tooltip");
        common.pop();
        common.push("emc");
        neutronPileEmc = ModConfig.buildInt(common, "config.avaritia.neutron_pile_emc", 100, 0, Integer.MAX_VALUE, "config.avaritia.neutron_pile_emc.tooltip");
        vanillaTotemEmc = ModConfig.buildInt(common, "config.avaritia.vanilla_totem_emc", 1000, 0, Integer.MAX_VALUE, "config.avaritia.vanilla_totem_emc.tooltip");
        common.pop();
        common.push("storage");
        chestMaxItemSize = ModConfig.buildInt(common, "config.avaritia.chest_max_item_size", 32768, 2048, Integer.MAX_VALUE, "config.avaritia.chest_max_item_size.tooltip");
        useSinglePageMode = ModConfig.buildBoolean(common, "config.avaritia.use_single_page_mode", false, "config.avaritia.use_single_page_mode.tooltip");
        slotStackLimit = ModConfig.buildLong(common, "config.avaritia.slot_stack_limit", 0xFFFFFFFFL, 64L, 0xFFFFFFFFL, "config.avaritia.slot_stack_limit.tooltip");
        maxPageLimit = ModConfig.buildInt(common, "config.avaritia.max_page_limit", 79536431, 2, 79536431, "config.avaritia.max_page_limit.tooltip");
        resetMaxPage = ModConfig.buildInt(common, "config.avaritia.reset_max_page", 1, 1, 79536431, "config.avaritia.reset_max_page.tooltip");
        inventoryRows = ModConfig.buildInt(common, "config.avaritia.inventory_rows", 6, 1, 6, "config.avaritia.inventory_rows.tooltip");
        common.pop();
        common.push("channel");
        MAX_SIZE_PRE_CHANNEL = ModConfig.buildInt(common, "config.avaritia.max_size_pre_channel", 32768, 2048, Integer.MAX_VALUE, "config.avaritia.max_size_pre_channel.tooltip");
        MAX_CHANNELS_PRE_PLAYER = ModConfig.buildInt(common, "config.avaritia.max_channels_pre_player", 16, 4, 64, "config.avaritia.max_channels_pre_player.tooltip");
        MAX_PUBLIC_CHANNELS = ModConfig.buildInt(common, "config.avaritia.max_public_channels", 128, 32, 1024, "config.avaritia.max_public_channels.tooltip");
        CHANNEL_FAST_UPDATE_RATE = ModConfig.buildInt(common, "config.avaritia.channel_fast_update_rate", 1, 1, 40, "config.avaritia.channel_fast_update_rate.tooltip");
        CHANNEL_FULL_UPDATE_RATE = ModConfig.buildInt(common, "config.avaritia.channel_full_update_rate", 40, 20, 1200, "config.avaritia.channel_full_update_rate.tooltip");
        common.pop();
        common.push("misc");
        common.push("immortal item entity");
        immortalItemEntitySpeed = ModConfig.buildDouble(common, "config.avaritia.endless_item_entity_speed", 3.0, 1.0, 50.0, "config.avaritia.endless_item_entity_speed.tooltip");
        immortalItemEntityRange = ModConfig.buildDouble(common, "config.avaritia.endless_item_entity_range", 1000.0, 1.0, 10000.0, "config.avaritia.endless_item_entity_range.tooltip");
        common.pop();
        useAdvanceTooltips = ModConfig.buildBoolean(common, "config.avaritia.use_advance_tooltips", false, "config.avaritia.use_advance_tooltips.tooltip");
        infinityElytraFlyingSpeed = ModConfig.buildDouble(common, "config.avaritia.infinity_elytra_flying_speed", 1.5, 1.0, 10.0, "config.avaritia.infinity_elytra_flying_speed.tooltip");
        bootSpeedBase = ModConfig.buildDouble(common, "config.avaritia.boot_speed_base", 0.1, 0.01, 1.0, "config.avaritia.boot_speed_base.tooltip");
        bootSpeedFlyingMultiplier = ModConfig.buildDouble(common, "config.avaritia.boot_speed_flying_multiplier", 1.1, 0.1, 5.0, "config.avaritia.boot_speed_flying_multiplier.tooltip");
        bootSpeedSwimmingMultiplier = ModConfig.buildDouble(common, "config.avaritia.boot_speed_swimming_multiplier", 1.2, 0.1, 5.0, "config.avaritia.boot_speed_swimming_multiplier.tooltip");
        bootSpeedSneakingMultiplier = ModConfig.buildDouble(common, "config.avaritia.boot_speed_sneaking_multiplier", 0.1, 0.01, 1.0, "config.avaritia.boot_speed_sneaking_multiplier");
        bootSpeedBackwardMultiplier = ModConfig.buildDouble(common, "config.avaritia.boot_speed_backward_multiplier", 0.25, 0.01, 1.0, "config.avaritia.boot_speed_backward_multiplier.tooltip");
        bootSpeedStrafingMultiplier = ModConfig.buildDouble(common, "config.avaritia.boot_speed_strafing_multiplier", 0.45, 0.01, 1.0, "config.avaritia.boot_speed_strafing_multiplier");
        bootSpeedSprintingMultiplier = ModConfig.buildDouble(common, "config.avaritia.boot_speed_sprinting_multiplier", 0.2, 0.01, 1.0, "config.avaritia.boot_speed_sprinting_multiplier");
        common.pop();
        COMMON = common.build();
    }
}

