/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.data.provider.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ModMatterClusterRecipeBuilder
extends CraftingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;

    public ModMatterClusterRecipeBuilder(RecipeCategory category, ItemLike result, int count) {
        this.category = category;
        this.result = result.m_5456_();
        this.count = count;
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static ModMatterClusterRecipeBuilder shapeless(RecipeCategory category, ItemLike result, int count) {
        return new ModMatterClusterRecipeBuilder(category, result, count);
    }

    public ModMatterClusterRecipeBuilder requires(TagKey<Item> tag) {
        return this.requires(Ingredient.m_204132_(tag));
    }

    public ModMatterClusterRecipeBuilder requires(ItemLike item) {
        return this.requires(item, 1);
    }

    public ModMatterClusterRecipeBuilder requires(ItemLike item, int count) {
        for (int i = 0; i < count; ++i) {
            this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        }
        return this;
    }

    public ModMatterClusterRecipeBuilder requires(Ingredient ingredient) {
        this.ingredients.add(ingredient);
        return this;
    }

    @NotNull
    public ModMatterClusterRecipeBuilder unlockedBy(@NotNull String criterionName, @NotNull CriterionTriggerInstance criterion) {
        this.advancement.m_138386_(criterionName, criterion);
        return this;
    }

    @NotNull
    public ModMatterClusterRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    @NotNull
    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(@NotNull Consumer<FinishedRecipe> consumer, @NotNull ResourceLocation id) {
        this.ensureValid(id);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept((FinishedRecipe)new Result(id, this.group == null ? "" : this.group, ModMatterClusterRecipeBuilder.m_245179_((RecipeCategory)this.category), this.ingredients, this.result, this.count, this.advancement, id.m_246208_("recipes/" + this.category.m_247710_() + "/")));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
        }
    }

    public static class Result
    extends CraftingRecipeBuilder.CraftingResult {
        private final ResourceLocation id;
        private final String group;
        private final List<Ingredient> ingredients;
        private final Item result;
        private final int count;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, String group, CraftingBookCategory bookCategory, List<Ingredient> ingredients, Item result, int count, Advancement.Builder advancement, ResourceLocation advancementId) {
            super(bookCategory);
            this.id = id;
            this.group = group;
            this.ingredients = ingredients;
            this.result = result;
            this.count = count;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(@NotNull JsonObject json) {
            super.m_7917_(json);
            json.addProperty("type", "avaritia:full_matter_cluster");
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray ingredients = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                ingredients.add(ingredient.m_43942_());
            }
            json.add("ingredients", (JsonElement)ingredients);
            json.addProperty("count", (Number)this.count);
            JsonObject resultObj = new JsonObject();
            resultObj.addProperty("item", new ResourceLocation("avaritia", "full_matter_cluster").toString());
            json.add("result", (JsonElement)resultObj);
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipeSerializers.FULL_MATTER_CLUSTER_SERIALIZER.get();
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

