/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.data.provider.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class NoConsumeCatalystShapedRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final ItemStack result;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, Ingredient> key = new HashMap<Character, Ingredient>();
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;
    private int tier = 4;

    public NoConsumeCatalystShapedRecipeBuilder(RecipeCategory category, ItemLike result, int count) {
        this.category = category;
        this.result = new ItemStack(result, count);
    }

    public static NoConsumeCatalystShapedRecipeBuilder shaped(RecipeCategory category, ItemLike result) {
        return new NoConsumeCatalystShapedRecipeBuilder(category, result, 1);
    }

    public static NoConsumeCatalystShapedRecipeBuilder shaped(RecipeCategory category, ItemLike result, int count) {
        return new NoConsumeCatalystShapedRecipeBuilder(category, result, count);
    }

    public NoConsumeCatalystShapedRecipeBuilder pattern(String row) {
        if (!this.pattern.isEmpty() && row.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("\u914d\u65b9\u6bcf\u884c\u957f\u5ea6\u5fc5\u987b\u76f8\u540c\uff01");
        }
        this.pattern.add(row);
        return this;
    }

    public NoConsumeCatalystShapedRecipeBuilder define(Character symbol, Ingredient ingredient) {
        if (this.key.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("\u4e0d\u80fd\u4f7f\u7528\u7a7a\u683c\u4f5c\u4e3a\u7b26\u53f7");
        }
        this.key.put(symbol, ingredient);
        return this;
    }

    public NoConsumeCatalystShapedRecipeBuilder define(Character symbol, ItemLike item) {
        return this.define(symbol, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public NoConsumeCatalystShapedRecipeBuilder tier(int tier) {
        this.tier = tier;
        return this;
    }

    @NotNull
    public NoConsumeCatalystShapedRecipeBuilder unlockedBy(@NotNull String name, @NotNull CriterionTriggerInstance trigger) {
        this.advancement.m_138386_(name, trigger);
        return this;
    }

    @NotNull
    public NoConsumeCatalystShapedRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    @NotNull
    public Item m_142372_() {
        return this.result.m_41720_();
    }

    public void m_126140_(@NotNull Consumer<FinishedRecipe> consumer, @NotNull ResourceLocation id) {
        this.ensureValid(id);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        CraftingBookCategory bookCategory = NoConsumeCatalystShapedRecipeBuilder.getCraftingBookCategory(this.category);
        consumer.accept(new Result(id, this.group, bookCategory, this.pattern.toArray(new String[0]), this.key, this.result, this.tier, this.advancement, id.m_246208_("recipes/" + this.category.m_247710_() + "/")));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("\u914d\u65b9 " + String.valueOf(id) + " \u672a\u8bbe\u7f6e\u5f62\u72b6\uff01");
        }
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No unlock criteria for recipe " + String.valueOf(id));
        }
        for (String row : this.pattern) {
            for (char c : row.toCharArray()) {
                if (c == ' ' || this.key.containsKey(Character.valueOf(c))) continue;
                throw new IllegalStateException("\u914d\u65b9 " + String.valueOf(id) + " \u5305\u542b\u672a\u5b9a\u4e49\u7684\u7b26\u53f7: " + c);
            }
        }
    }

    private static CraftingBookCategory getCraftingBookCategory(RecipeCategory category) {
        return switch (category) {
            case RecipeCategory.BUILDING_BLOCKS -> CraftingBookCategory.BUILDING;
            case RecipeCategory.TOOLS, RecipeCategory.COMBAT, RecipeCategory.BREWING -> CraftingBookCategory.EQUIPMENT;
            case RecipeCategory.REDSTONE -> CraftingBookCategory.REDSTONE;
            default -> CraftingBookCategory.MISC;
        };
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        @Nullable
        private final String group;
        private final CraftingBookCategory bookCategory;
        private final String[] pattern;
        private final Map<Character, Ingredient> key;
        private final ItemStack result;
        private final int tier;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, @Nullable String group, CraftingBookCategory bookCategory, String[] pattern, Map<Character, Ingredient> key, ItemStack result, int tier, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.group = group;
            this.bookCategory = bookCategory;
            this.pattern = pattern;
            this.key = key;
            this.result = result;
            this.tier = tier;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(@NotNull JsonObject json) {
            json.addProperty("category", this.bookCategory.m_7912_());
            if (this.group != null && !this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.addProperty("tier", (Number)this.tier);
            JsonArray patternArray = new JsonArray();
            for (String row : this.pattern) {
                patternArray.add(row);
            }
            json.add("pattern", (JsonElement)patternArray);
            JsonObject keyObject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                keyObject.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            json.add("key", (JsonElement)keyObject);
            JsonObject resultObject = new JsonObject();
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_());
            resultObject.addProperty("item", Objects.requireNonNull(itemId).toString());
            if (this.result.m_41613_() > 1) {
                resultObject.addProperty("count", (Number)this.result.m_41613_());
            }
            if (this.result.m_41782_()) {
                resultObject.addProperty("nbt", this.result.m_41783_().toString());
            }
            json.add("result", (JsonElement)resultObject);
            json.addProperty("type", "avaritia:no_consume_catalyst_shaped");
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipeSerializers.NO_CONSUME_CATALYST_SHAPED_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

