/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.handler;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.ModApi;
import committee.nova.mods.avaritia.api.util.recipe.RecipeUtils;
import committee.nova.mods.avaritia.common.crafting.recipe.CompressorRecipe;
import committee.nova.mods.avaritia.core.singularity.Singularity;
import committee.nova.mods.avaritia.core.singularity.SingularityReloadEvent;
import committee.nova.mods.avaritia.core.singularity.SingularityRuntimeEvent;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SingularityHandler {
    @SubscribeEvent
    public static void onAddSingularity(SingularityRuntimeEvent.Add event) {
        if (event.getSingularity().isRecipeDisabled()) {
            return;
        }
        try {
            CompressorRecipe compressorRecipe = ModApi.addSingularityRecipe(event.getSingularity());
            if (compressorRecipe != null) {
                RecipeUtils.addRecipe(compressorRecipe);
                Const.LOGGER.info("Singularity: Added compressor recipe for runtime singularity: {}", (Object)event.getSingularity().getId());
            }
        }
        catch (Exception e) {
            Const.LOGGER.error("Singularity: Failed to add compressor recipe for runtime singularity: {}", (Object)event.getSingularity().getId(), (Object)e);
        }
    }

    @SubscribeEvent
    public static void onRemoveSingularity(SingularityRuntimeEvent.Remove event) {
        try {
            ResourceLocation recipeId = new ResourceLocation(event.getSingularityId().m_135827_(), event.getSingularityId().m_135815_() + "_singularity");
            RecipeUtils.removeRecipe((RecipeType)ModRecipeTypes.COMPRESSOR_RECIPE.get(), recipeId);
            Const.LOGGER.info("Singularity: Removed compressor recipe {} for singularity: {}", (Object)recipeId, (Object)event.getSingularityId());
        }
        catch (Exception e) {
            Const.LOGGER.warn("Singularity: Failed to remove compressor recipe for singularity: {}", (Object)event.getSingularityId(), (Object)e);
        }
    }

    @SubscribeEvent
    public static void onReloadSingularity(SingularityReloadEvent event) {
        try {
            RecipeUtils.byType((RecipeType)ModRecipeTypes.COMPRESSOR_RECIPE.get()).forEach((id, recipe) -> {
                if (id.m_135815_().endsWith("_singularity")) {
                    RecipeUtils.removeRecipe((RecipeType)ModRecipeTypes.COMPRESSOR_RECIPE.get(), id);
                }
            });
            int generatedCount = 0;
            for (Singularity singularity : event.getSingularities().values()) {
                CompressorRecipe compressorRecipe;
                if (singularity.isRecipeDisabled() || (compressorRecipe = ModApi.addSingularityRecipe(singularity)) == null) continue;
                RecipeUtils.addRecipe(compressorRecipe);
                ++generatedCount;
            }
            Const.LOGGER.info("Singularity: Regenerated {} recipes", (Object)generatedCount);
        }
        catch (Exception e) {
            Const.LOGGER.error("Singularity: Failed to regenerate recipes", (Throwable)e);
        }
    }
}

