/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra;

import cofh.core.client.event.CoreClientEvents;
import cofh.core.common.config.ConfigManager;
import cofh.core.common.config.IBaseConfig;
import java.util.concurrent.CompletableFuture;
import mrthomas20121.thermal_extra.client.screens.AdvancedItemFilterScreen;
import mrthomas20121.thermal_extra.client.screens.DynamoFrostScreen;
import mrthomas20121.thermal_extra.client.screens.device.DeviceHarvesterScreen;
import mrthomas20121.thermal_extra.client.screens.device.DeviceLavaGenScreen;
import mrthomas20121.thermal_extra.client.screens.machine.MachineAdvancedRefineryScreen;
import mrthomas20121.thermal_extra.client.screens.machine.MachineComponentAssemblyScreen;
import mrthomas20121.thermal_extra.client.screens.machine.MachineEndothermicDehydratorScreen;
import mrthomas20121.thermal_extra.client.screens.machine.MachineFluidMixerScreen;
import mrthomas20121.thermal_extra.client.screens.machine.MachineNitraticIgniterScreen;
import mrthomas20121.thermal_extra.data.ExtraBlockstateGen;
import mrthomas20121.thermal_extra.data.ExtraLangGen;
import mrthomas20121.thermal_extra.data.ExtraLootTableProvider;
import mrthomas20121.thermal_extra.data.ExtraModelGen;
import mrthomas20121.thermal_extra.data.ExtraRecipeGen;
import mrthomas20121.thermal_extra.data.ExtraTagGen;
import mrthomas20121.thermal_extra.filter.AdvancedFilter;
import mrthomas20121.thermal_extra.init.ThermalExtraBlockEntities;
import mrthomas20121.thermal_extra.init.ThermalExtraBlocks;
import mrthomas20121.thermal_extra.init.ThermalExtraContainers;
import mrthomas20121.thermal_extra.init.ThermalExtraCreativeTabs;
import mrthomas20121.thermal_extra.init.ThermalExtraFluids;
import mrthomas20121.thermal_extra.init.ThermalExtraItems;
import mrthomas20121.thermal_extra.init.ThermalExtraRecipeManagers;
import mrthomas20121.thermal_extra.init.ThermalExtraRecipeSerializers;
import mrthomas20121.thermal_extra.init.ThermalExtraRecipeTypes;
import mrthomas20121.thermal_extra.util.ThermalExtraConfig;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.NewRegistryEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="thermal_extra")
public class ThermalExtra {
    public static final String MOD_ID = "thermal_extra";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final ConfigManager CONFIG_MANAGER = new ConfigManager();

    public ThermalExtra() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ThermalExtraItems.ITEMS.register(bus);
        ThermalExtraBlocks.BLOCKS.register(bus);
        ThermalExtraFluids.FLUIDS.register(bus);
        ThermalExtraFluids.FLUID_TYPES.register(bus);
        ThermalExtraBlockEntities.BLOCK_ENTITIES.register(bus);
        ThermalExtraContainers.CONTAINERS.register(bus);
        ThermalExtraRecipeTypes.RECIPE_TYPES.register(bus);
        ThermalExtraRecipeSerializers.RECIPE_SERIALIZERS.register(bus);
        ThermalExtraCreativeTabs.CREATIVE_TABS.register(bus);
        AdvancedFilter.init();
        ThermalExtraRecipeManagers.register();
        CONFIG_MANAGER.register(bus).addServerConfig((IBaseConfig)new ThermalExtraConfig());
        bus.addListener(this::gatherData);
        bus.addListener(this::clientSetup);
        bus.addListener(this::registrySetup);
    }

    public void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            CoreClientEvents.addNamespace((String)MOD_ID);
            MenuScreens.m_96206_((MenuType)((MenuType)ThermalExtraContainers.ADVANCED_REFINERY_CONTAINER.get()), MachineAdvancedRefineryScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ThermalExtraContainers.NITRATIC_IGNITER_CONTAINER.get()), MachineNitraticIgniterScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ThermalExtraContainers.FLUID_MIXER_CONTAINER.get()), MachineFluidMixerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ThermalExtraContainers.DYNAMO_FROST_CONTAINER.get()), DynamoFrostScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ThermalExtraContainers.ADVANCED_ITEM_FILTER_CONTAINER.get()), AdvancedItemFilterScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ThermalExtraContainers.HARVESTER_CONTAINER.get()), DeviceHarvesterScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ThermalExtraContainers.LAVA_GEN_CONTAINER.get()), DeviceLavaGenScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ThermalExtraContainers.COMPONENT_ASSEMBLY_CONTAINER.get()), MachineComponentAssemblyScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ThermalExtraContainers.ENDOTHERMIC_DEHYDRATOR_CONTAINER.get()), MachineEndothermicDehydratorScreen::new);
        });
    }

    private void registrySetup(NewRegistryEvent event) {
        CONFIG_MANAGER.setupServer();
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        PackOutput packOutput = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeServer(), (DataProvider)new ExtraRecipeGen(packOutput));
        ExtraTagGen.BlockTags blockTags = new ExtraTagGen.BlockTags(packOutput, lookupProvider, fileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)blockTags);
        gen.addProvider(event.includeServer(), (DataProvider)new ExtraTagGen.ItemTags(packOutput, lookupProvider, blockTags.m_274426_(), fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ExtraTagGen.FluidTags(packOutput, lookupProvider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ExtraTagGen.EntityTags(packOutput, lookupProvider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ExtraLootTableProvider(packOutput));
        gen.addProvider(event.includeClient(), (DataProvider)new ExtraModelGen(packOutput, fileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new ExtraLangGen(packOutput));
        gen.addProvider(event.includeClient(), (DataProvider)new ExtraBlockstateGen(packOutput, fileHelper));
    }
}

