/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.block.entity;

import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.block.IHarvestable;
import cofh.lib.api.block.entity.IAreaEffectTile;
import cofh.lib.api.block.entity.ITickableTile;
import cofh.lib.common.energy.EnergyStorageCoFH;
import cofh.lib.common.inventory.ItemStorageCoFH;
import cofh.thermal.core.common.config.ThermalCoreConfig;
import cofh.thermal.lib.common.block.entity.AugmentableBlockEntity;
import cofh.thermal.lib.util.ThermalAugmentRules;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mrthomas20121.thermal_extra.init.ThermalExtraBlockEntities;
import mrthomas20121.thermal_extra.inventory.device.DeviceHarvesterMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class DeviceHarvesterBlockEntity
extends AugmentableBlockEntity
implements ITickableTile.IServerTickable,
IAreaEffectTile {
    public static boolean shouldReplant = true;
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator((String[])new String[]{"RF", "Area", "Upgrade"});
    protected static final int BASE_PROCESS_MAX = 4000;
    protected ItemStorageCoFH chargeSlot = new ItemStorageCoFH(1, ThermalEnergyHelper::hasEnergyHandlerCap);
    public static boolean canHarvestNetherWart = true;
    protected static final int RADIUS = 2;
    protected int radius = 2;
    protected AABB area;
    protected int process;
    protected int processMax = 4000 * this.radius * this.radius;
    protected int processTick = this.getBaseProcessTick() / 4 * this.radius;

    public DeviceHarvesterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ThermalExtraBlockEntities.HARVESTER.get(), pos, state);
        this.energyStorage = new EnergyStorageCoFH(50000, 1000);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.addAugmentSlots(ThermalCoreConfig.deviceAugments);
        this.initHandlers();
    }

    public void tickServer() {
        boolean curActive = this.isActive;
        if (this.isActive) {
            if (this.energyStorage.getEnergyStored() >= this.processTick) {
                this.process += this.processTick;
                this.energyStorage.modify(-this.processTick);
                if (this.process >= this.processMax) {
                    this.process -= this.processMax;
                    BlockPos.m_121990_((BlockPos)this.f_58858_.m_7918_(-this.radius, -2, -this.radius), (BlockPos)this.f_58858_.m_7918_(this.radius, 2, this.radius)).forEach(this::dropBlock);
                }
            } else {
                this.isActive = false;
            }
        } else if (this.redstoneControl.getState() && this.energyStorage.getEnergyStored() >= this.processTick) {
            this.isActive = true;
        }
        this.updateActiveState(curActive);
        this.chargeEnergy();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new DeviceHarvesterMenu(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    public int getCurSpeed() {
        return this.isActive ? this.processTick : 0;
    }

    public int getScaledProgress(int scale) {
        if (!this.isActive || this.processMax <= 0 || this.process <= 0) {
            return 0;
        }
        return scale * Math.min(this.process, this.processMax) / this.processMax;
    }

    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.process);
        buffer.writeInt(this.processMax);
        buffer.writeInt(this.processTick);
        return buffer;
    }

    public void handleGuiPacket(FriendlyByteBuf buffer) {
        super.handleGuiPacket(buffer);
        this.process = buffer.readInt();
        this.processMax = buffer.readInt();
        this.processTick = buffer.readInt();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.process = nbt.m_128451_("Proc");
        this.processMax = nbt.m_128451_("ProcMax");
        this.processTick = nbt.m_128451_("ProcTick");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("Proc", this.process);
        nbt.m_128405_("ProcMax", this.processMax);
        nbt.m_128405_("ProcTick", this.processTick);
    }

    public int getRadius() {
        return this.radius;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void dropBlock(BlockPos pos) {
        IHarvestable harvestable;
        BlockState state = this.f_58857_.m_8055_(pos);
        Block block = state.m_60734_();
        FakePlayer player = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.f_58857_));
        if (block instanceof IHarvestable && (harvestable = (IHarvestable)block).canHarvest(state)) {
            harvestable.harvest(this.f_58857_, pos, state, (Player)player, shouldReplant);
            return;
        }
        boolean seedDrop = false;
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            BlockPos below = pos.m_7495_();
            BlockState belowState = this.f_58857_.m_8055_(below);
            shouldReplant &= belowState.m_60734_().canSustainPlant(belowState, (BlockGetter)this.f_58857_, below, Direction.UP, (IPlantable)crop);
            if (!crop.m_52307_(state)) return;
            if (this.f_58857_.f_46443_) return;
            List drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            Item seedItem = crop.m_7397_((BlockGetter)this.f_58857_, pos, state).m_41720_();
            Iterator iterator = drops.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.f_58857_.m_46953_(pos, false, (Entity)player);
                    if (!seedDrop) return;
                    this.f_58857_.m_7731_(pos, crop.m_52289_(0), 3);
                    return;
                }
                ItemStack drop = (ItemStack)iterator.next();
                if (shouldReplant && !seedDrop && drop.m_41720_() == seedItem) {
                    drop.m_41774_(1);
                    seedDrop = true;
                }
                if (drop.m_41619_()) continue;
                Containers.m_18992_((Level)this.f_58857_, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (ItemStack)drop);
            }
        }
        if (block instanceof NetherWartBlock) {
            NetherWartBlock crop = (NetherWartBlock)block;
            if (canHarvestNetherWart) {
                BlockPos below = pos.m_7495_();
                BlockState belowState = this.f_58857_.m_8055_(below);
                shouldReplant &= belowState.m_60734_().canSustainPlant(belowState, (BlockGetter)this.f_58857_, below, Direction.UP, (IPlantable)crop);
                if ((Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) < 3) return;
                if (this.f_58857_.f_46443_) return;
                List drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
                Item seedItem = crop.m_7397_((BlockGetter)this.f_58857_, pos, state).m_41720_();
                Iterator iterator = drops.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this.f_58857_.m_46953_(pos, false, (Entity)player);
                        if (!seedDrop) return;
                        this.f_58857_.m_7731_(pos, crop.m_49966_(), 3);
                        return;
                    }
                    ItemStack drop = (ItemStack)iterator.next();
                    if (shouldReplant && !seedDrop && drop.m_41720_() == seedItem) {
                        drop.m_41774_(1);
                        seedDrop = true;
                    }
                    if (drop.m_41619_()) continue;
                    Containers.m_18992_((Level)this.f_58857_, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (ItemStack)drop);
                }
            }
        }
        if (!(block instanceof CocoaBlock)) return;
        CocoaBlock crop = (CocoaBlock)block;
        shouldReplant &= crop.m_7898_(state, (LevelReader)this.f_58857_, pos);
        if ((Integer)state.m_61143_((Property)CocoaBlock.f_51736_) < 2) return;
        if (this.f_58857_.f_46443_) return;
        Direction facing = (Direction)state.m_61143_((Property)CocoaBlock.f_54117_);
        List drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
        Item seedItem = new ItemStack((ItemLike)crop).m_41720_();
        Iterator iterator = drops.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.f_58857_.m_46953_(pos, false, (Entity)player);
                if (!seedDrop) return;
                this.f_58857_.m_7731_(pos, (BlockState)crop.m_49966_().m_61124_((Property)CocoaBlock.f_54117_, (Comparable)facing), 3);
                return;
            }
            ItemStack drop = (ItemStack)iterator.next();
            if (shouldReplant && !seedDrop && drop.m_41720_() == seedItem) {
                drop.m_41774_(1);
                seedDrop = true;
            }
            if (drop.m_41619_()) continue;
            Containers.m_18992_((Level)this.f_58857_, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (ItemStack)drop);
        }
    }

    protected void chargeEnergy() {
        if (!this.chargeSlot.isEmpty()) {
            this.chargeSlot.getItemStack().getCapability(ThermalEnergyHelper.getBaseEnergySystem(), null).ifPresent(c -> this.energyStorage.receiveEnergy(c.extractEnergy(Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getSpace()), false), false));
        }
    }

    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }

    protected void resetAttributes() {
        super.resetAttributes();
        this.radius = 2;
    }

    protected void setAttributesFromAugment(CompoundTag augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.radius += (int)AugmentableHelper.getAttributeMod((CompoundTag)augmentData, (String)"Radius");
    }

    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        super.finalizeAttributes(enchantmentMap);
        float baseMod = AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"BaseMod", (float)1.0f);
        this.processMax = 4000 * (1 + this.radius);
        this.processTick = Math.round((float)this.getBaseProcessTick() * baseMod);
        this.area = null;
    }

    public boolean hasFilterSlot() {
        return false;
    }

    public AABB getArea() {
        if (this.area == null) {
            this.area = new AABB(this.f_58858_.m_7918_(-this.radius, -1, -this.radius), this.f_58858_.m_7918_(1 + this.radius, 1, 1 + this.radius));
        }
        return this.area;
    }

    public int getColor() {
        return this.isActive ? 7923823 : 0x555555;
    }
}

