/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.block.entity;

import cofh.lib.api.StorageGroup;
import cofh.lib.common.inventory.ItemStorageCoFH;
import cofh.thermal.core.common.config.ThermalCoreConfig;
import cofh.thermal.lib.common.block.entity.DynamoBlockEntity;
import javax.annotation.Nullable;
import mrthomas20121.thermal_extra.init.ThermalExtraBlockEntities;
import mrthomas20121.thermal_extra.inventory.DynamoFrostMenu;
import mrthomas20121.thermal_extra.recipe.ColdFuelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DynamoColdBlockEntity
extends DynamoBlockEntity {
    protected ItemStorageCoFH fuelSlot = new ItemStorageCoFH(item -> this.filter.valid(item) && ColdFuelManager.instance().validFuel((ItemStack)item));

    public DynamoColdBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ThermalExtraBlockEntities.DYNAMO_COLD.get(), pos, state);
        this.inventory.addSlot(this.fuelSlot, StorageGroup.INPUT);
        this.addAugmentSlots(ThermalCoreConfig.dynamoAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return ColdFuelManager.instance().getBasePower();
    }

    protected boolean canProcessStart() {
        return ColdFuelManager.instance().getEnergy(this.fuelSlot.getItemStack()) > 0;
    }

    protected void processStart() {
        int fuelVal = Math.round((float)ColdFuelManager.instance().getEnergy(this.fuelSlot.getItemStack()) * this.energyMod);
        this.processTick = Math.min(this.baseProcessTick, fuelVal);
        this.fuelMax = fuelVal;
        this.fuel += this.fuelMax;
        this.fuelSlot.consume(1);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new DynamoFrostMenu(i, this.f_58857_, this.f_58858_, inventory, player);
    }
}

