/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.compat.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mrthomas20121.thermal_extra.client.screens.DynamoFrostScreen;
import mrthomas20121.thermal_extra.client.screens.machine.MachineAdvancedRefineryScreen;
import mrthomas20121.thermal_extra.client.screens.machine.MachineComponentAssemblyScreen;
import mrthomas20121.thermal_extra.client.screens.machine.MachineEndothermicDehydratorScreen;
import mrthomas20121.thermal_extra.client.screens.machine.MachineFluidMixerScreen;
import mrthomas20121.thermal_extra.client.screens.machine.MachineNitraticIgniterScreen;
import mrthomas20121.thermal_extra.compat.jei.category.AdvancedRefineryRecipeCategory;
import mrthomas20121.thermal_extra.compat.jei.category.ColdFuelCategory;
import mrthomas20121.thermal_extra.compat.jei.category.ComponentAssemblyRecipeCategory;
import mrthomas20121.thermal_extra.compat.jei.category.EndothermicDehydratorRecipeCategory;
import mrthomas20121.thermal_extra.compat.jei.category.FluidMixerRecipeCategory;
import mrthomas20121.thermal_extra.compat.jei.category.NitraticIgniterCatalystCategory;
import mrthomas20121.thermal_extra.compat.jei.category.NitraticIgniterRecipeCategory;
import mrthomas20121.thermal_extra.init.ThermalExtraBlocks;
import mrthomas20121.thermal_extra.init.ThermalExtraRecipeTypes;
import mrthomas20121.thermal_extra.recipe.AdvancedRefineryRecipe;
import mrthomas20121.thermal_extra.recipe.ColdFuel;
import mrthomas20121.thermal_extra.recipe.ComponentAssemblyRecipe;
import mrthomas20121.thermal_extra.recipe.EndothermicDehydratorRecipe;
import mrthomas20121.thermal_extra.recipe.FluidMixerRecipe;
import mrthomas20121.thermal_extra.recipe.NitraticIgniterCatalyst;
import mrthomas20121.thermal_extra.recipe.NitraticIgniterRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class ThermalExtraPlugin
implements IModPlugin {
    public static final RecipeType<ColdFuel> COLD_FUEL_TYPE = new RecipeType(ThermalExtraRecipeTypes.COLD_FUEL.getId(), ColdFuel.class);
    public static final RecipeType<FluidMixerRecipe> FLUID_MIXER_TYPE = new RecipeType(ThermalExtraRecipeTypes.FLUID_MIXER.getId(), FluidMixerRecipe.class);
    public static final RecipeType<AdvancedRefineryRecipe> ADVANCED_REFINERY_TYPE = new RecipeType(ThermalExtraRecipeTypes.ADVANCED_REFINERY.getId(), AdvancedRefineryRecipe.class);
    public static final RecipeType<NitraticIgniterRecipe> NITRATIC_IGNITER_TYPE = new RecipeType(ThermalExtraRecipeTypes.NITRATIC_IGNITER.getId(), NitraticIgniterRecipe.class);
    public static final RecipeType<NitraticIgniterCatalyst> NITRATIC_IGNITER_CATALYST_TYPE = new RecipeType(ThermalExtraRecipeTypes.NITRATIC_IGNITER_CATALYST.getId(), NitraticIgniterCatalyst.class);
    public static final RecipeType<ComponentAssemblyRecipe> COMPONENT_ASSEMBLY_TYPE = new RecipeType(ThermalExtraRecipeTypes.COMPONENT_ASSEMBLY.getId(), ComponentAssemblyRecipe.class);
    public static final RecipeType<EndothermicDehydratorRecipe> ENDOTHERMIC_DEHYDRATOR_TYPE = new RecipeType(ThermalExtraRecipeTypes.ENDOTHERMIC_DEHYDRATOR.getId(), EndothermicDehydratorRecipe.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("thermal_extra", "extra");
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        RecipeManager recipeManager = this.getRecipeManager();
        if (recipeManager == null) {
            return;
        }
        registration.addRecipes(COLD_FUEL_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ThermalExtraRecipeTypes.COLD_FUEL.get()));
        registration.addRecipes(ADVANCED_REFINERY_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ThermalExtraRecipeTypes.ADVANCED_REFINERY.get()));
        registration.addRecipes(NITRATIC_IGNITER_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ThermalExtraRecipeTypes.NITRATIC_IGNITER.get()));
        registration.addRecipes(NITRATIC_IGNITER_CATALYST_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ThermalExtraRecipeTypes.NITRATIC_IGNITER_CATALYST.get()));
        registration.addRecipes(FLUID_MIXER_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ThermalExtraRecipeTypes.FLUID_MIXER.get()));
        registration.addRecipes(COMPONENT_ASSEMBLY_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ThermalExtraRecipeTypes.COMPONENT_ASSEMBLY.get()));
        registration.addRecipes(ENDOTHERMIC_DEHYDRATOR_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ThermalExtraRecipeTypes.ENDOTHERMIC_DEHYDRATOR.get()));
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new ColdFuelCategory(registration.getJeiHelpers().getGuiHelper(), new ItemStack((ItemLike)ThermalExtraBlocks.DYNAMO_COLD.get()), COLD_FUEL_TYPE)});
        registration.addRecipeCategories(new IRecipeCategory[]{new AdvancedRefineryRecipeCategory(registration.getJeiHelpers().getGuiHelper(), new ItemStack((ItemLike)ThermalExtraBlocks.ADVANCED_REFINERY.get()), ADVANCED_REFINERY_TYPE)});
        registration.addRecipeCategories(new IRecipeCategory[]{new NitraticIgniterRecipeCategory(registration.getJeiHelpers().getGuiHelper(), new ItemStack((ItemLike)ThermalExtraBlocks.NITRATIC_IGNITER.get()), NITRATIC_IGNITER_TYPE)});
        registration.addRecipeCategories(new IRecipeCategory[]{new NitraticIgniterCatalystCategory(registration.getJeiHelpers().getGuiHelper(), new ItemStack((ItemLike)ThermalExtraBlocks.NITRATIC_IGNITER.get()), NITRATIC_IGNITER_CATALYST_TYPE)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidMixerRecipeCategory(registration.getJeiHelpers().getGuiHelper(), new ItemStack((ItemLike)ThermalExtraBlocks.FLUID_MIXER.get()), FLUID_MIXER_TYPE)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ComponentAssemblyRecipeCategory(registration.getJeiHelpers().getGuiHelper(), new ItemStack((ItemLike)ThermalExtraBlocks.COMPONENT_ASSEMBLY.get()), COMPONENT_ASSEMBLY_TYPE)});
        registration.addRecipeCategories(new IRecipeCategory[]{new EndothermicDehydratorRecipeCategory(registration.getJeiHelpers().getGuiHelper(), new ItemStack((ItemLike)ThermalExtraBlocks.ENDOTHERMIC_DEHYDRATOR.get()), ENDOTHERMIC_DEHYDRATOR_TYPE)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        int progressY = 35;
        int progressW = 24;
        int progressH = 16;
        registration.addRecipeClickArea(DynamoFrostScreen.class, 80, progressY, progressH, progressH, new RecipeType[]{COLD_FUEL_TYPE});
        registration.addRecipeClickArea(MachineAdvancedRefineryScreen.class, 65, progressY, progressW, progressH, new RecipeType[]{ADVANCED_REFINERY_TYPE});
        registration.addRecipeClickArea(MachineNitraticIgniterScreen.class, 94, progressY, progressW, progressH, new RecipeType[]{NITRATIC_IGNITER_TYPE});
        registration.addRecipeClickArea(MachineFluidMixerScreen.class, 80, progressY, progressW, progressH, new RecipeType[]{FLUID_MIXER_TYPE});
        registration.addRecipeClickArea(MachineComponentAssemblyScreen.class, 92, progressY, progressW, progressH, new RecipeType[]{COMPONENT_ASSEMBLY_TYPE});
        registration.addRecipeClickArea(MachineEndothermicDehydratorScreen.class, 88, progressY, progressW, progressH, new RecipeType[]{ENDOTHERMIC_DEHYDRATOR_TYPE});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ThermalExtraBlocks.DYNAMO_COLD.get()), new RecipeType[]{COLD_FUEL_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ThermalExtraBlocks.ADVANCED_REFINERY.get()), new RecipeType[]{ADVANCED_REFINERY_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ThermalExtraBlocks.NITRATIC_IGNITER.get()), new RecipeType[]{NITRATIC_IGNITER_TYPE, NITRATIC_IGNITER_CATALYST_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ThermalExtraBlocks.FLUID_MIXER.get()), new RecipeType[]{FLUID_MIXER_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ThermalExtraBlocks.COMPONENT_ASSEMBLY.get()), new RecipeType[]{COMPONENT_ASSEMBLY_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ThermalExtraBlocks.ENDOTHERMIC_DEHYDRATOR.get()), new RecipeType[]{ENDOTHERMIC_DEHYDRATOR_TYPE});
    }

    private RecipeManager getRecipeManager() {
        RecipeManager recipeManager = null;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            recipeManager = level.m_7465_();
        }
        return recipeManager;
    }
}

