/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.item.augment;

import cofh.lib.util.DeferredRegisterCoFH;
import cofh.thermal.lib.common.item.AugmentItem;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import mrthomas20121.thermal_extra.item.augment.ExtraAugment;
import mrthomas20121.thermal_extra.item.augment.ExtraAugmentType;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;

public enum EnumAugment {
    RF_COIL_AUGMENT("RF", "Expanded RF Coil", (valueMap, map) -> {
        valueMap.put("RFMax", Float.valueOf(4.0f));
        map.put("RFMax", Float.valueOf(4.0f));
        valueMap.put("RFXfer", Float.valueOf(4.0f));
        map.put("RFXfer", Float.valueOf(4.0f));
    }),
    RF_COIL_STORAGE_AUGMENT("RF", "Stabilized RF Coil", (valueMap, map) -> {
        valueMap.put("RFMax", Float.valueOf(6.0f));
        map.put("RFMax", Float.valueOf(4.0f));
        valueMap.put("RFXfer", Float.valueOf(2.0f));
        map.put("RFXfer", Float.valueOf(2.0f));
    }),
    RF_COIL_XFER_AUGMENT("RF", "High-Flux RF Coil", (valueMap, map) -> {
        valueMap.put("RFMax", Float.valueOf(2.0f));
        map.put("RFMax", Float.valueOf(2.0f));
        valueMap.put("RFXfer", Float.valueOf(6.0f));
        map.put("RFXfer", Float.valueOf(4.0f));
    }),
    FLUID_TANK_AUGMENT("Fluid", "Expanded Tank Construction", (valueMap, map) -> {
        valueMap.put("FluidMax", Float.valueOf(4.0f));
        map.put("FluidMax", Float.valueOf(4.0f));
    }),
    MACHINE_SPEED_AUGMENT("Machine", "Flux Linkage Amplifier", (valueMap, map) -> {
        valueMap.put("MachinePower", Float.valueOf(1.1f));
        map.put("MachinePower", Float.valueOf(0.0f));
        valueMap.put("MachineEnergy", Float.valueOf(1.1f));
        map.put("MachineEnergy", Float.valueOf(-0.1f));
    }),
    MACHINE_EFFICIENCY_AUGMENT("Machine", "Flux Efficiency", (valueMap, map) -> {
        valueMap.put("MachineSpeed", Float.valueOf(-0.12f));
        map.put("MachineSpeed", Float.valueOf(0.0f));
        valueMap.put("MachineEnergy", Float.valueOf(0.9f));
        map.put("MachineEnergy", Float.valueOf(-0.05f));
    }),
    MACHINE_OUTPUT_AUGMENT("Machine", "Auxiliary Process Sieve", (valueMap, map) -> {
        valueMap.put("MachineSec", Float.valueOf(0.15f));
        map.put("MachineSec", Float.valueOf(0.05f));
        valueMap.put("MachineEnergy", Float.valueOf(1.3f));
        map.put("MachineEnergy", Float.valueOf(0.0f));
    }),
    MACHINE_CATALYST_AUGMENT("Machine", "Catalytic Reclamation Chamber", (valueMap, map) -> {
        valueMap.put("MachineCat", Float.valueOf(0.8f));
        map.put("MachineCat", Float.valueOf(-0.02f));
        valueMap.put("MachineEnergy", Float.valueOf(1.25f));
        map.put("MachineEnergy", Float.valueOf(0.0f));
    }),
    DYNAMO_OUTPUT_AUGMENT("Dynamo", "Auxiliary Reaction Chamber", (valueMap, map) -> {
        valueMap.put("DynamoEnergy", Float.valueOf(0.9f));
        map.put("DynamoEnergy", Float.valueOf(0.0f));
        valueMap.put("DynamoPower", Float.valueOf(1.0f));
        map.put("DynamoPower", Float.valueOf(0.05f));
    }),
    DYNAMO_FUEL_AUGMENT("Dynamo", "Multi Cycle Injectors", (valueMap, map) -> {
        valueMap.put("DynamoEnergy", Float.valueOf(1.1f));
        map.put("DynamoEnergy", Float.valueOf(0.02f));
    }),
    AREA_RADIUS_AUGMENT("Area", "Radial Enhancement", (valueMap, map) -> {
        valueMap.put("Radius", Float.valueOf(1.0f));
        map.put("Radius", Float.valueOf(1.0f));
    });

    private final Map<String, Float> defaultValueMap = new HashMap<String, Float>();
    private final Map<String, Float> mapIncrement = new HashMap<String, Float>();
    private final String type;
    private final String name;

    private EnumAugment(String type, String name, BiConsumer<Map<String, Float>, Map<String, Float>> consumer) {
        this.type = type;
        this.name = name;
        consumer.accept(this.defaultValueMap, this.mapIncrement);
    }

    public RegistryObject<AugmentItem> build(ExtraAugmentType augmentType, DeferredRegisterCoFH<Item> registry) {
        ExtraAugment builder = ExtraAugment.builder(registry).type(this.type).rarity(augmentType.getRarity());
        for (Map.Entry<String, Float> entry : this.defaultValueMap.entrySet()) {
            float value = entry.getValue().floatValue();
            float increment = this.mapIncrement.get(entry.getKey()).floatValue();
            float finalValue = value + increment * (float)augmentType.getTier();
            builder.mod(entry.getKey(), finalValue);
        }
        return builder.build(augmentType.name().toLowerCase(Locale.ROOT) + "_" + this.name().toLowerCase(Locale.ROOT));
    }

    public String getName() {
        return this.name;
    }
}

