/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.recipe;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.util.crafting.ComparableItemStack;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapWrapper {
    Set<Integer> hashes;
    int hashCode;

    RecipeMapWrapper(List<ComparableItemStack> itemStacks) {
        this.hashes = new ObjectOpenHashSet(itemStacks.size());
        for (ComparableItemStack itemStack : itemStacks) {
            if (itemStack.hashCode() == 0) continue;
            this.hashes.add(itemStack.hashCode());
            this.hashCode += itemStack.hashCode();
        }
    }

    RecipeMapWrapper(List<ComparableItemStack> itemStacks, FluidStack fluidStack) {
        this.hashes = new ObjectOpenHashSet(itemStacks.size());
        for (ComparableItemStack itemStack : itemStacks) {
            if (itemStack.hashCode() == 0) continue;
            this.hashes.add(itemStack.hashCode());
            this.hashCode += itemStack.hashCode();
        }
        if (!fluidStack.isEmpty()) {
            int fluidHash = FluidHelper.fluidHashcode((FluidStack)fluidStack);
            this.hashes.add(fluidHash);
            this.hashCode += fluidHash;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecipeMapWrapper that = (RecipeMapWrapper)o;
        return this.hashes.size() == that.hashes.size() && this.hashes.containsAll(that.hashes);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

