/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.data.thermal_recipe;

import cofh.lib.common.fluid.FluidIngredient;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FinishedThermalRecipe<T extends ThermalRecipe>(RecipeSerializer<T> recipeSerializer, ResourceLocation id, int energy, float xp, List<Ingredient> inputItems, List<FluidIngredient> inputFluids, List<ItemStack> outputItems, List<Float> outputItemChances, List<FluidStack> outputFluids, List<Boolean> locked, boolean chance) implements FinishedRecipe
{
    public void m_7917_(@NotNull JsonObject jsonObject) {
        JsonObject object = new JsonObject();
        JsonArray output = new JsonArray();
        JsonArray ingredients = new JsonArray();
        this.inputItems.forEach(ingredient -> {
            JsonElement e = ingredient.m_43942_();
            int count = ingredient.m_43908_()[0].m_41613_();
            if (count > 1) {
                e.getAsJsonObject().addProperty("count", (Number)count);
            }
            ingredients.add(e);
        });
        this.inputFluids.stream().map(FluidIngredient::toJson).forEach(arg_0 -> ((JsonArray)ingredients).add(arg_0));
        object.add("ingredients", (JsonElement)ingredients);
        int size = this.outputItems.size();
        for (int i = 0; i < size; ++i) {
            float chance = this.outputItemChances.get(i).floatValue();
            ItemStack itemStack = this.outputItems.get(i);
            boolean locked = this.locked.get(i);
            JsonObject stack = new JsonObject();
            stack.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString());
            if (itemStack.m_41613_() > 1) {
                stack.addProperty("count", (Number)itemStack.m_41613_());
            }
            if (chance > 0.0f) {
                stack.addProperty("chance", (Number)Float.valueOf(chance));
            } else if (this.chance) {
                stack.addProperty("chance", (Number)Float.valueOf(1.0f));
            }
            if (locked) {
                stack.addProperty("locked", Boolean.valueOf(true));
            }
            output.add((JsonElement)stack);
        }
        this.outputFluids.forEach(fluidStack -> {
            Fluid fluid = fluidStack.getFluid();
            int amount = fluidStack.getAmount();
            JsonObject obj = new JsonObject();
            obj.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((Object)fluid).toString());
            obj.addProperty("amount", (Number)amount);
            output.add((JsonElement)obj);
        });
        jsonObject.add("ingredients", (JsonElement)ingredients);
        if (!output.isEmpty()) {
            jsonObject.add("result", (JsonElement)output);
        }
        jsonObject.addProperty("energy", (Number)this.energy);
        if (this.xp > 0.0f) {
            jsonObject.addProperty("experience", (Number)Float.valueOf(this.xp));
        }
    }

    @NotNull
    public ResourceLocation m_6445_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<T> m_6637_() {
        return this.recipeSerializer;
    }

    @Nullable
    public JsonObject m_5860_() {
        return null;
    }

    @Nullable
    public ResourceLocation m_6448_() {
        return null;
    }
}

