/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.fluid;

import java.util.function.Supplier;
import mrthomas20121.thermal_extra.init.ThermalExtraBlocks;
import mrthomas20121.thermal_extra.init.ThermalExtraFluids;
import mrthomas20121.thermal_extra.init.ThermalExtraItems;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegistryObject;

public class FluidHolder {
    protected ResourceLocation name;
    protected RegistryObject<ForgeFlowingFluid> stillFluid;
    protected RegistryObject<ForgeFlowingFluid> flowingFluid;
    protected RegistryObject<LiquidBlock> block;
    protected RegistryObject<Item> bucket;
    private final RegistryObject<FluidType> type;
    private boolean isMetal = false;
    private final TagKey<Fluid> tag;

    private static TagKey<Fluid> forgeTag(String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)new ResourceLocation("forge", name));
    }

    public FluidHolder(ResourceLocation name, Supplier<FluidType> fluidTypeSupplier, BlockBehaviour.Properties properties) {
        this.name = name;
        this.stillFluid = ThermalExtraFluids.FLUIDS.register(name.m_135815_(), () -> new ForgeFlowingFluid.Source(this.fluidProperties()));
        this.flowingFluid = ThermalExtraFluids.FLUIDS.register(this.flowing(name.m_135815_()), () -> new ForgeFlowingFluid.Flowing(this.fluidProperties()));
        this.type = ThermalExtraFluids.FLUID_TYPES.register(name.m_135815_(), fluidTypeSupplier);
        this.bucket = ThermalExtraItems.ITEMS.register(this.bucket(name.m_135815_()), () -> new BucketItem(this.stillFluid, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1)));
        this.block = ThermalExtraBlocks.BLOCKS.register(name.m_135815_(), () -> new LiquidBlock(this.flowingFluid, properties));
        this.tag = FluidHolder.forgeTag(this.isMetal ? this.molten(this.name.m_135815_()) : this.name.m_135815_());
    }

    public FluidHolder metal() {
        this.isMetal = true;
        return this;
    }

    public RegistryObject<Item> getBucket() {
        return this.bucket;
    }

    public RegistryObject<ForgeFlowingFluid> getFlowingFluid() {
        return this.flowingFluid;
    }

    public RegistryObject<ForgeFlowingFluid> getStillFluid() {
        return this.stillFluid;
    }

    public RegistryObject<ForgeFlowingFluid> still() {
        return this.getStillFluid();
    }

    public RegistryObject<ForgeFlowingFluid> flowing() {
        return this.getFlowingFluid();
    }

    public boolean isMetal() {
        return this.isMetal;
    }

    public RegistryObject<LiquidBlock> getBlock() {
        return this.block;
    }

    public RegistryObject<FluidType> getType() {
        return this.type;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public TagKey<Fluid> tag() {
        return this.tag;
    }

    protected ForgeFlowingFluid.Properties fluidProperties() {
        return new ForgeFlowingFluid.Properties(this.type, this.stillFluid, this.flowingFluid).block(this.block).bucket(this.bucket);
    }

    public String fluid(String fluid) {
        return fluid + "_fluid";
    }

    public String flowing(String fluid) {
        return fluid + "_flowing";
    }

    public String bucket(String fluid) {
        return fluid + "_bucket";
    }

    public String molten(String fluid) {
        return "molten_" + fluid;
    }
}

