/*
 * Decompiled with CFR 0.152.
 */
package de.devknochen.serverlens;

import de.devknochen.serverlens.ServerDataUpdater;
import de.devknochen.serverlens.logic.DirectConnectLogic;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_420;
import net.minecraft.class_437;

public class Main
implements ClientModInitializer {
    private boolean hasListener = false;
    private static String lastAddress = "";
    private static long lastPingTime = 0L;
    private static final long PING_DEBOUNCE_MS = 500L;
    public static boolean debugingMode = false;

    public void onInitializeClient() {
        System.out.println("ServerLens initialized!");
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (this.hasListener && !(client.field_1755 instanceof class_420)) {
                this.hasListener = false;
            }
        });
    }

    public static void onAddressBarUpdate(String address) {
        if (address == null || address.isBlank()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (address.equals(lastAddress) && now - lastPingTime < 500L) {
            return;
        }
        lastAddress = address;
        lastPingTime = now;
        new Thread(() -> DirectConnectLogic.pingServer(address, serverInfo -> {
            if (serverInfo != null) {
                if (debugingMode) {
                    System.out.println("=== Server Ping Result ===");
                    System.out.println("MOTD: " + (serverInfo.field_3757 != null ? serverInfo.field_3757.getString() : "N/A"));
                    System.out.println("Players: " + (serverInfo.field_3753 != null ? serverInfo.field_3753.getString() : "0/0"));
                    System.out.println("Ping: " + serverInfo.field_3758);
                    System.out.println("Version: " + (serverInfo.field_3760 != null ? serverInfo.field_3760.getString() : "Unknown"));
                }
                class_310 client = class_310.method_1551();
                client.execute(() -> {
                    class_437 screen = client.field_1755;
                    if (screen instanceof ServerDataUpdater) {
                        String[] stringArray;
                        ServerDataUpdater updater = (ServerDataUpdater)screen;
                        if (serverInfo.field_3757 != null) {
                            updater.setMotdText(serverInfo.field_3757);
                        } else {
                            updater.setMotdText((class_2561)class_2561.method_43473());
                        }
                        if (serverInfo.field_3757 != null) {
                            stringArray = serverInfo.field_3757.getString().split("\n");
                        } else {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = "";
                        }
                        String[] motdLines = stringArray;
                        updater.updateServerData(serverInfo.field_3752 != null ? serverInfo.field_3752 : "", motdLines, serverInfo.field_3753 != null ? serverInfo.field_3753.getString() : "0/0", serverInfo.field_3758);
                        updater.updateFavicon(serverInfo.method_49306());
                    }
                });
            } else if (debugingMode) {
                System.out.println("=== Server Ping Failed ===");
            }
        })).start();
    }
}

