/*
 * Decompiled with CFR 0.152.
 */
package de.devknochen.serverlens.mixin;

import de.devknochen.serverlens.Main;
import de.devknochen.serverlens.ServerDataUpdater;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_420;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_642;
import net.minecraft.class_8573;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_420.class})
public abstract class DirectConnectScreenMixin
extends class_437
implements ServerDataUpdater {
    private static final class_2960 PING_1 = class_2960.method_60655((String)"serverlens", (String)"gui/serverlist/ping_1.png");
    private static final class_2960 PING_2 = class_2960.method_60655((String)"serverlens", (String)"gui/serverlist/ping_2.png");
    private static final class_2960 PING_3 = class_2960.method_60655((String)"serverlens", (String)"gui/serverlist/ping_3.png");
    private static final class_2960 PING_4 = class_2960.method_60655((String)"serverlens", (String)"gui/serverlist/ping_4.png");
    private static final class_2960 PING_5 = class_2960.method_60655((String)"serverlens", (String)"gui/serverlist/ping_5.png");
    private static final class_2960 PINGING_1 = class_2960.method_60655((String)"serverlens", (String)"gui/serverlist/pinging_1.png");
    private static final class_2960 PINGING_2 = class_2960.method_60655((String)"serverlens", (String)"gui/serverlist/pinging_2.png");
    private static final class_2960 PINGING_3 = class_2960.method_60655((String)"serverlens", (String)"gui/serverlist/pinging_3.png");
    private static final class_2960 PINGING_4 = class_2960.method_60655((String)"serverlens", (String)"gui/serverlist/pinging_4.png");
    private static final class_2960 PINGING_5 = class_2960.method_60655((String)"serverlens", (String)"gui/serverlist/pinging_5.png");
    private static final class_2960 UNREACHABLE = class_2960.method_60655((String)"serverlens", (String)"gui/serverlist/unreachable.png");
    private static final class_2960 INCOMPATIBLE = class_2960.method_60655((String)"serverlens", (String)"gui/serverlist/incompatible.png");
    @Shadow
    private class_342 field_2463;
    private String lastAddress = "";
    private String serverName = "";
    private class_2561 motdText = class_2561.method_43473();
    private String playerCount = "0/0";
    private long pingValue = -1L;
    private class_8573 serverIcon = null;
    private byte[] lastFavicon = null;

    protected DirectConnectScreenMixin(class_2561 title) {
        super(title);
    }

    @Override
    public void updateServerData(String name, String[] motd, String players, long ping) {
        this.serverName = name != null ? name : "";
        this.playerCount = players != null ? players : "0/0";
        this.pingValue = ping;
    }

    @Override
    public void setMotdText(class_2561 motd) {
        this.motdText = motd != null ? motd : class_2561.method_43473();
    }

    @Override
    public void updateFavicon(byte[] faviconBytes) {
        class_310 client = class_310.method_1551();
        if (!client.method_18854()) {
            client.execute(() -> this.updateFavicon(faviconBytes));
            return;
        }
        if (faviconBytes == null) {
            if (this.serverIcon != null) {
                this.serverIcon.close();
                this.serverIcon = null;
            }
            this.lastFavicon = null;
            return;
        }
        if (this.lastFavicon != null && Arrays.equals(faviconBytes, this.lastFavicon)) {
            return;
        }
        this.lastFavicon = faviconBytes;
        byte[] valid = class_642.method_53885((byte[])faviconBytes);
        if (valid == null) {
            System.out.println("Invalid favicon received.");
            return;
        }
        try {
            if (this.serverIcon != null) {
                this.serverIcon.close();
                this.serverIcon = null;
            }
            String idSource = this.lastAddress != null && !this.lastAddress.isBlank() ? this.lastAddress : "directconnectmotd";
            this.serverIcon = class_8573.method_52202((class_1060)client.method_1531(), (String)idSource);
            class_1011 img = class_1011.method_49277((byte[])valid);
            this.serverIcon.method_52199(img);
            if (Main.debugingMode) {
                System.out.println("Favicon successfully loaded!");
            }
        }
        catch (Exception e) {
            if (this.serverIcon != null) {
                this.serverIcon.close();
                this.serverIcon = null;
            }
            if (Main.debugingMode) {
                System.out.println("Failed to load favicon: " + e.getMessage());
            }
            e.printStackTrace();
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void renderExtras(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        class_2960 pingTexture;
        String address;
        if (this.field_2463 != null && (address = this.field_2463.method_1882()) != null && !address.isBlank() && !address.equals(this.lastAddress)) {
            this.lastAddress = address;
            Main.onAddressBarUpdate(address);
        }
        int maxRowWidth = 305;
        int minRowWidth = 200;
        int sidePadding = 20;
        int rowWidth = Math.min(maxRowWidth, Math.max(minRowWidth, this.field_22789 - sidePadding * 2));
        int baseX = (this.field_22789 - rowWidth) / 2;
        int baseY = this.field_2463 != null ? this.field_2463.method_46427() + this.field_2463.method_25364() + 8 : this.field_22790 / 2 + 30;
        int iconSize = 32;
        if (this.serverIcon != null) {
            context.method_25290(class_10799.field_56883, this.serverIcon.method_52201(), baseX, baseY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        } else {
            class_2960 fallbackIcon = class_2960.method_60655((String)"serverlens", (String)"gui/serverlist/default_icon.png");
            context.method_25290(class_10799.field_56883, fallbackIcon, baseX, baseY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        }
        int textX = baseX + iconSize + 3;
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)this.serverName), textX, baseY, -1);
        if (this.motdText != null && !this.motdText.getString().isEmpty()) {
            int motdY = baseY + 12;
            Objects.requireNonNull(this.field_22793);
            int lineHeight = 9;
            int availableWidth = rowWidth - iconSize - 10;
            List lines = this.field_22793.method_1728((class_5348)this.motdText, availableWidth);
            for (class_5481 line : lines) {
                context.method_35720(this.field_22793, line, textX, motdY, -1);
                motdY += lineHeight;
            }
        }
        if (this.pingValue < 0L) {
            long tick = System.currentTimeMillis() / 100L;
            int frame = (int)(tick % 8L);
            if (frame > 4) {
                frame = 8 - frame;
            }
            switch (frame) {
                case 1: {
                    pingTexture = PINGING_2;
                    break;
                }
                case 2: {
                    pingTexture = PINGING_3;
                    break;
                }
                case 3: {
                    pingTexture = PINGING_4;
                    break;
                }
                case 4: {
                    pingTexture = PINGING_5;
                    break;
                }
                default: {
                    pingTexture = PINGING_1;
                    break;
                }
            }
        } else {
            pingTexture = this.pingValue < 150L ? PING_5 : (this.pingValue < 300L ? PING_4 : (this.pingValue < 600L ? PING_3 : (this.pingValue < 1000L ? PING_2 : PING_1)));
        }
        int pingX = baseX + rowWidth - 10 - 5;
        int pingWidth = 10;
        int pingHeight = 8;
        context.method_25290(class_10799.field_56883, pingTexture, pingX, baseY, 0.0f, 0.0f, pingWidth, pingHeight, pingWidth, pingHeight);
        if (this.pingValue >= 0L) {
            String players = this.playerCount.contains("/") ? this.playerCount.split("/")[0] : this.playerCount;
            String maxPlayers = this.playerCount.contains("/") ? this.playerCount.split("/")[1] : "0";
            String slash = "/";
            int playersWidth = this.field_22793.method_1727(players);
            int slashWidth = this.field_22793.method_1727(slash);
            int maxPlayersWidth = this.field_22793.method_1727(maxPlayers);
            int playerTextX = pingX - (playersWidth + slashWidth + maxPlayersWidth) - 5;
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)players), playerTextX, baseY, -5592406);
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)slash), playerTextX + playersWidth, baseY, -11184811);
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)maxPlayers), playerTextX + playersWidth + slashWidth, baseY, -5592406);
        }
    }
}

