/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.endernexus;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.borisshoes.endernexus.Destination;
import net.borisshoes.endernexus.cca.IDestinationComponent;
import net.borisshoes.endernexus.cca.PlayerComponentInitializer;
import net.borisshoes.endernexus.cca.WorldDataComponentInitializer;
import net.borisshoes.endernexus.utils.ConfigUtils;
import net.borisshoes.endernexus.utils.GenericTimer;
import net.borisshoes.endernexus.utils.TeleportTimer;
import net.borisshoes.endernexus.utils.TeleportUtils;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3004;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5454;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class EnderNexus
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"Ender Nexus");
    private static final String CONFIG_NAME = "EnderNexus.properties";
    public static final HashMap<UUID, GenericTimer> SERVER_TIMER_CALLBACKS = new HashMap();
    public static final HashMap<UUID, GenericTimer> SERVER_TIMER_CALLBACKS_QUEUE = new HashMap();
    public static boolean hasCarpet;
    public static ConfigUtils config;
    private static final HashMap<UUID, TPARequest> activeTpas;
    private static final ArrayList<Teleport> recentTeleports;

    public void onInitialize() {
        LOGGER.info("Ender Nexus is Warping In!");
        ServerTickEvents.END_SERVER_TICK.register(EnderNexus::onTick);
        hasCarpet = FabricLoader.getInstance().isModLoaded("carpet");
        config = new ConfigUtils(FabricLoader.getInstance().getConfigDir().resolve(CONFIG_NAME).toFile(), LOGGER, Arrays.asList(new ConfigUtils.BooleanConfigValue("homes", true, new ConfigUtils.Command("Homes allowed: %s", "Homes now allowed: %s")), new ConfigUtils.BooleanConfigValue("spawn", true, new ConfigUtils.Command("Spawn allowed: %s", "Spawn now allowed: %s")), new ConfigUtils.BooleanConfigValue("tpas", true, new ConfigUtils.Command("TPAs allowed: %s", "TPAs now allowed: %s")), new ConfigUtils.BooleanConfigValue("tpaheres", true, new ConfigUtils.Command("TPA Here allowed: %s", "TPA Here now allowed: %s")), new ConfigUtils.BooleanConfigValue("warps", true, new ConfigUtils.Command("Warps allowed: %s", "Warps now allowed: %s")), new ConfigUtils.BooleanConfigValue("randomtps", true, new ConfigUtils.Command("Random TPs allowed: %s", "Random TPs now allowed: %s")), new ConfigUtils.BooleanConfigValue("bossbar", true, new ConfigUtils.Command("Show Bossbar: %s", "Show Bossbar is now: %s")), new ConfigUtils.BooleanConfigValue("particles", true, new ConfigUtils.Command("Show Particles: %s", "Show Particles is now: %s")), new ConfigUtils.BooleanConfigValue("sound", true, new ConfigUtils.Command("Play Sound: %s", "Play Sound is now: %s")), new ConfigUtils.IntegerConfigValue("homes-warmup", 160, new ConfigUtils.IntegerConfigValue.IntLimits(1, 1000000), new ConfigUtils.Command("Home Warmup time: %s ticks", "Home Warmup time set to: %s ticks")), new ConfigUtils.IntegerConfigValue("homes-cooldown", 1800, new ConfigUtils.IntegerConfigValue.IntLimits(1, 1000000), new ConfigUtils.Command("Home Cooldown time: %s ticks", "Home Cooldown time set to: %s ticks")), new ConfigUtils.IntegerConfigValue("max-homes", 2, new ConfigUtils.IntegerConfigValue.IntLimits(1, 100), new ConfigUtils.Command("Max Homes: %s", "Max Homes set to: %s")), new ConfigUtils.IntegerConfigValue("tpa-warmup", 200, new ConfigUtils.IntegerConfigValue.IntLimits(1, 1000000), new ConfigUtils.Command("TPA Warmup time: %s ticks", "TPA Warmup time set to: %s ticks")), new ConfigUtils.IntegerConfigValue("tpa-cooldown", 2400, new ConfigUtils.IntegerConfigValue.IntLimits(1, 1000000), new ConfigUtils.Command("TPA Cooldown time: %s ticks", "TPA Cooldown time set to: %s ticks")), new ConfigUtils.IntegerConfigValue("tpa-timeout", 1200, new ConfigUtils.IntegerConfigValue.IntLimits(1, 1000000), new ConfigUtils.Command("TPA Request Timeout: %s ticks", "TPA Request Timeout set to: %s ticks")), new ConfigUtils.IntegerConfigValue("spawn-warmup", 120, new ConfigUtils.IntegerConfigValue.IntLimits(1, 1000000), new ConfigUtils.Command("Spawn Warmup time: %s ticks", "Spawn Warmup time set to: %s ticks")), new ConfigUtils.IntegerConfigValue("spawn-cooldown", 1200, new ConfigUtils.IntegerConfigValue.IntLimits(1, 1000000), new ConfigUtils.Command("Spawn Cooldown time: %s ticks", "Spawn Cooldown time set to: %s ticks")), new ConfigUtils.IntegerConfigValue("warps-warmup", 120, new ConfigUtils.IntegerConfigValue.IntLimits(1, 1000000), new ConfigUtils.Command("Warps Warmup time: %s ticks", "Warps Warmup time set to: %s ticks")), new ConfigUtils.IntegerConfigValue("warps-cooldown", 1200, new ConfigUtils.IntegerConfigValue.IntLimits(1, 1000000), new ConfigUtils.Command("Warps Cooldown time: %s ticks", "Warps Cooldown time set to: %s ticks")), new ConfigUtils.IntegerConfigValue("rtp-warmup", 200, new ConfigUtils.IntegerConfigValue.IntLimits(1, 1000000), new ConfigUtils.Command("Random TP Warmup time: %s ticks", "Random TP Warmup time set to: %s ticks")), new ConfigUtils.IntegerConfigValue("rtp-cooldown", 12000, new ConfigUtils.IntegerConfigValue.IntLimits(1, 1000000), new ConfigUtils.Command("Random TP Cooldown time: %s ticks", "Random TP Cooldown time set to: %s ticks")), new ConfigUtils.IntegerConfigValue("rtp-range", 1000, new ConfigUtils.IntegerConfigValue.IntLimits(1, 1000000), new ConfigUtils.Command("Random TP Range: %s blocks", "Random TP Range set to: %s blocks"))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, registrationEnvironment) -> {
            dispatcher.register(config.generateCommand("endernexus"));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"spawntp").executes(this::spawnTp));
            if (!hasCarpet) {
                dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"spawn").executes(this::spawnTp));
            }
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"tpinterrupt").executes(this::interruptTp));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"rtp").executes(this::randomTp));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"randomtp").executes(this::randomTp));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sethome").executes(ctx -> this.setHome((CommandContext<class_2168>)ctx, null))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.setHome((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delhome").executes(ctx -> this.delHome((CommandContext<class_2168>)ctx, null))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(this::getHomeSuggestions).executes(ctx -> this.delHome((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"home").executes(ctx -> this.homeTp((CommandContext<class_2168>)ctx, null))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(this::getHomeSuggestions).executes(ctx -> this.homeTp((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setwarp").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.setWarp((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delwarp").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(this::getWarpSuggestions).executes(ctx -> this.delWarp((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"warp").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(this::getWarpSuggestions).executes(ctx -> this.warpTp((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"tpa").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).suggests(this::getTpaInitSuggestions).executes(ctx -> this.tpaInit((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"target"), false))));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"tpahere").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).suggests(this::getTpaInitSuggestions).executes(ctx -> this.tpaInit((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"target"), true))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpaaccept").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).suggests(this::getTpaTargetSuggestions).executes(ctx -> this.tpaAccept((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"target"))))).executes(ctx -> this.tpaAccept((CommandContext<class_2168>)ctx, null)));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpadeny").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).suggests(this::getTpaTargetSuggestions).executes(ctx -> this.tpaDeny((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"target"))))).executes(ctx -> this.tpaDeny((CommandContext<class_2168>)ctx, null)));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpacancel").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).suggests(this::getTpaSenderSuggestions).executes(ctx -> this.tpaCancel((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"target"))))).executes(ctx -> this.tpaCancel((CommandContext<class_2168>)ctx, null)));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"endernexus").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"cleanse").requires(source -> source.method_9259(2))).executes(this::cleanse)));
        });
    }

    private int cleanse(CommandContext<class_2168> ctx) {
        SERVER_TIMER_CALLBACKS.clear();
        SERVER_TIMER_CALLBACKS_QUEUE.clear();
        activeTpas.clear();
        recentTeleports.clear();
        class_3004 bbm = ((class_2168)ctx.getSource()).method_9211().method_3837();
        bbm.method_12969().stream().filter(b -> b.method_12959().toString().contains("standstill-")).toList().forEach(b -> {
            b.method_14094();
            bbm.method_12973(b);
        });
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Cleansed Ender Nexus Teleports"), true);
        return 1;
    }

    @Nullable
    private static CompletableFuture<Suggestions> filterSuggestionsByInput(SuggestionsBuilder builder, List<String> values) {
        String start = builder.getRemaining().toLowerCase(Locale.ROOT);
        values.stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> getHomeSuggestions(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        if (((class_2168)ctx.getSource()).method_43737()) {
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            List<String> homeOptions = ((IDestinationComponent)PlayerComponentInitializer.HOMES.get((Object)player)).getDestinations().stream().map(Destination::getName).toList();
            return EnderNexus.filterSuggestionsByInput(builder, homeOptions);
        }
        return EnderNexus.filterSuggestionsByInput(builder, new ArrayList<String>());
    }

    private CompletableFuture<Suggestions> getWarpSuggestions(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        List<String> warpOptions = ((IDestinationComponent)WorldDataComponentInitializer.WARPS.get((Object)((class_2168)ctx.getSource()).method_9211().method_3847(class_3218.field_25179))).getDestinations().stream().map(Destination::getName).toList();
        return EnderNexus.filterSuggestionsByInput(builder, warpOptions);
    }

    private CompletableFuture<Suggestions> getTpaInitSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        class_2168 scs = (class_2168)context.getSource();
        List<String> activeTargets = Stream.concat(activeTpas.values().stream().map(TPARequest2 -> TPARequest2.tTo.method_5477().getString()), activeTpas.values().stream().map(TPARequest2 -> TPARequest2.tFrom.method_5477().getString())).toList();
        List<String> others = Arrays.stream(scs.method_9211().method_3858()).filter(s -> !s.equals(scs.method_9214()) && !activeTargets.contains(s)).collect(Collectors.toList());
        return EnderNexus.filterSuggestionsByInput(builder, others);
    }

    private CompletableFuture<Suggestions> getTpaTargetSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        List<String> activeTargets = activeTpas.values().stream().map(tpaRequest -> tpaRequest.tFrom.method_5477().getString()).collect(Collectors.toList());
        return EnderNexus.filterSuggestionsByInput(builder, activeTargets);
    }

    private CompletableFuture<Suggestions> getTpaSenderSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        List<String> activeTargets = activeTpas.values().stream().map(TPARequest2 -> TPARequest2.tTo.method_5477().getString()).collect(Collectors.toList());
        return EnderNexus.filterSuggestionsByInput(builder, activeTargets);
    }

    private int interruptTp(CommandContext<class_2168> ctx) {
        if (!((class_2168)ctx.getSource()).method_43737()) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Teleports must be done by a player!").method_27692(class_124.field_1061));
            return -1;
        }
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        boolean active = SERVER_TIMER_CALLBACKS.entrySet().stream().anyMatch(t -> {
            Object patt0$temp = t.getValue();
            if (!(patt0$temp instanceof TeleportTimer)) return false;
            TeleportTimer tp = (TeleportTimer)patt0$temp;
            if (!tp.player.method_5667().equals(player.method_5667())) return false;
            return true;
        });
        if (!active) {
            player.method_7353((class_2561)class_2561.method_43470((String)"You are not channeling a teleport").method_27692(class_124.field_1061), false);
            return 0;
        }
        Optional<Map.Entry> activeTP = SERVER_TIMER_CALLBACKS.entrySet().stream().filter(t -> {
            Object patt0$temp = t.getValue();
            if (!(patt0$temp instanceof TeleportTimer)) return false;
            TeleportTimer tp = (TeleportTimer)patt0$temp;
            if (!tp.player.method_5667().equals(player.method_5667())) return false;
            return true;
        }).findFirst();
        activeTP.ifPresent(uuidGenericTimerEntry -> SERVER_TIMER_CALLBACKS.remove(uuidGenericTimerEntry.getKey()));
        class_3004 bbm = ((class_2168)ctx.getSource()).method_9211().method_3837();
        bbm.method_12969().stream().filter(b -> b.method_12959().toString().contains("standstill-") && b.method_12959().toString().contains(player.method_5845())).toList().forEach(b -> {
            b.method_14094();
            bbm.method_12973(b);
        });
        return 1;
    }

    public int tpaInit(CommandContext<class_2168> ctx, class_3222 tTo, boolean tpahere) {
        if (!((class_2168)ctx.getSource()).method_43737()) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Teleports must be done by a player!").method_27692(class_124.field_1061));
            return -1;
        }
        class_3222 tFrom = ((class_2168)ctx.getSource()).method_44023();
        if (tpahere && !((Boolean)config.getValue("tpaheres")).booleanValue()) {
            tFrom.method_7353((class_2561)class_2561.method_43470((String)"TPA Heres are disabled!").method_27692(class_124.field_1061), false);
            return -1;
        }
        if (!tpahere && !((Boolean)config.getValue("tpas")).booleanValue()) {
            tFrom.method_7353((class_2561)class_2561.method_43470((String)"TPAs are disabled!").method_27692(class_124.field_1061), false);
            return -1;
        }
        if (tFrom.equals((Object)tTo)) {
            tFrom.method_7353((class_2561)class_2561.method_43470((String)"You cannot request to TPA to yourself!").method_27692(class_124.field_1061), false);
            return -1;
        }
        if (this.checkCooldown(TPType.TPA, tFrom)) {
            return -1;
        }
        if (this.activeChannels(tFrom)) {
            return -1;
        }
        TPARequest tpa = new TPARequest(tFrom, tTo, tpahere);
        if (activeTpas.values().stream().anyMatch(TPARequest2 -> TPARequest2.equals(tpa))) {
            tFrom.method_7353((class_2561)class_2561.method_43470((String)"There is already an ongoing request like this!").method_27692(class_124.field_1061), false);
            return 1;
        }
        tpa.setTimeoutCallback();
        activeTpas.put(tFrom.method_5667(), tpa);
        class_5250 senderText = tpahere ? class_2561.method_43470((String)"You have requested that ").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)tTo.method_5477().getString()).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" TPA to you ").method_27692(class_124.field_1076)) : class_2561.method_43470((String)"You have requested to TPA to ").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)tTo.method_5477().getString()).method_27692(class_124.field_1075));
        tFrom.method_7353((class_2561)senderText.method_10852((class_2561)class_2561.method_43470((String)"\nTo cancel type ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"/tpacancel [<player>]").method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/tpacancel " + tTo.method_5477().getString())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("/tpacancel " + tTo.method_5477().getString())))).method_10977(class_124.field_1060))).method_10852((class_2561)class_2561.method_43470((String)("\nThis request will timeout in " + (Integer)config.getValue("tpa-timeout") / 20 + " seconds.")).method_27692(class_124.field_1076)), false);
        tTo.method_7353((class_2561)class_2561.method_43470((String)tFrom.method_5477().getString()).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)(tpahere ? " has requested that you TPA to them!" : " has requested to TPA to you!")).method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"\nTo accept type ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"/tpaaccept [<player>]").method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/tpaaccept " + tFrom.method_5477().getString())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("/tpaaccept " + tFrom.method_5477().getString())))).method_10977(class_124.field_1060))).method_10852((class_2561)class_2561.method_43470((String)"\nTo deny type ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"/tpadeny [<player>]").method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/tpadeny " + tFrom.method_5477().getString())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("/tpadeny " + tFrom.method_5477().getString())))).method_10977(class_124.field_1060))).method_10852((class_2561)class_2561.method_43470((String)("\nThis request will timeout in " + (Integer)config.getValue("tpa-timeout") / 20 + " seconds.")).method_27692(class_124.field_1076)), false);
        return 1;
    }

    public int tpaAccept(CommandContext<class_2168> ctx, class_3222 tFrom) {
        TPARequest tr;
        if (!((class_2168)ctx.getSource()).method_43737()) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Teleports must be done by a player!").method_27692(class_124.field_1061));
            return -1;
        }
        class_3222 tTo = ((class_2168)ctx.getSource()).method_44023();
        if (tFrom == null) {
            TPARequest[] candidates = (TPARequest[])activeTpas.values().stream().filter(TPARequest2 -> TPARequest2.tTo.equals((Object)tTo)).toArray(TPARequest[]::new);
            if (candidates.length > 1) {
                class_5250 text = class_2561.method_43470((String)"You currently have multiple active TPA requests! Please specify whose request to accept.\n").method_27692(class_124.field_1076);
                Arrays.stream(candidates).map(TPARequest2 -> TPARequest2.tFrom.method_5477().getString()).forEach(name -> text.method_10852((class_2561)class_2561.method_43470((String)name).method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/tpaaccept " + name)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("/tpaaccept " + name)))).method_10977(class_124.field_1060)).method_27693(" ")));
                tTo.method_7353((class_2561)text, false);
                return 1;
            }
            if (candidates.length < 1) {
                tTo.method_7353((class_2561)class_2561.method_43470((String)"You currently don't have any TPA requests!").method_27692(class_124.field_1061), false);
                return 1;
            }
            tFrom = candidates[0].tFrom;
        }
        if ((tr = this.getTPARequest(tFrom, tTo, TPAAction.ACCEPT)) == null) {
            return 1;
        }
        if (!tr.isTPAhere() && !((Boolean)config.getValue("tpas")).booleanValue()) {
            tTo.method_7353((class_2561)class_2561.method_43470((String)"TPAs are disabled!").method_27692(class_124.field_1061), false);
            return -1;
        }
        if (tr.isTPAhere() && !((Boolean)config.getValue("tpaheres")).booleanValue()) {
            tTo.method_7353((class_2561)class_2561.method_43470((String)"TPA Heres are disabled!").method_27692(class_124.field_1061), false);
            return -1;
        }
        class_3222 finalTFrom = tFrom;
        if (tr.isTPAhere()) {
            TeleportUtils.genericTeleport((Boolean)config.getValue("bossbar"), (Boolean)config.getValue("particles"), (Boolean)config.getValue("sound"), (Integer)config.getValue("spawn-warmup"), tTo, () -> {
                tTo.method_61275(new class_5454(finalTFrom.method_51469(), finalTFrom.method_73189(), class_243.field_1353, tTo.method_36454(), tTo.method_36455(), class_5454.field_52245));
                recentTeleports.add(new Teleport(finalTFrom, TPType.TPA, System.currentTimeMillis()));
            });
        } else {
            TeleportUtils.genericTeleport((Boolean)config.getValue("bossbar"), (Boolean)config.getValue("particles"), (Boolean)config.getValue("sound"), (Integer)config.getValue("spawn-warmup"), tFrom, () -> {
                finalTFrom.method_61275(new class_5454(tTo.method_51469(), tTo.method_73189(), class_243.field_1353, finalTFrom.method_36454(), finalTFrom.method_36455(), class_5454.field_52245));
                recentTeleports.add(new Teleport(finalTFrom, TPType.TPA, System.currentTimeMillis()));
            });
        }
        tr.cancelTimeout();
        activeTpas.remove(tFrom.method_5667());
        tr.tTo.method_7353((class_2561)class_2561.method_43470((String)"You have accepted the TPA request!").method_27692(class_124.field_1060), false);
        tr.tFrom.method_7353((class_2561)class_2561.method_43470((String)tr.tTo.method_5477().getString()).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)" has accepted the TPA request!").method_27692(class_124.field_1060)), false);
        return 1;
    }

    public int tpaDeny(CommandContext<class_2168> ctx, class_3222 tFrom) {
        TPARequest tr;
        if (!((class_2168)ctx.getSource()).method_43737()) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Teleports must be done by a player!").method_27692(class_124.field_1061));
            return -1;
        }
        class_3222 tTo = ((class_2168)ctx.getSource()).method_44023();
        if (tFrom == null) {
            TPARequest[] candidates = (TPARequest[])activeTpas.values().stream().filter(TPARequest2 -> TPARequest2.tTo.equals((Object)tTo)).toArray(TPARequest[]::new);
            if (candidates.length > 1) {
                class_5250 text = class_2561.method_43470((String)"You currently have multiple active TPA requests! Please specify whose request to deny.\n").method_27692(class_124.field_1060);
                Arrays.stream(candidates).map(TPARequest2 -> TPARequest2.tFrom.method_5477().getString()).forEach(name -> text.method_10852((class_2561)class_2561.method_43470((String)name).method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/tpadeny " + name)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("/tpadeny " + name)))).method_10977(class_124.field_1060))).method_27693(" "));
                tTo.method_7353((class_2561)text, false);
                return 1;
            }
            if (candidates.length < 1) {
                tTo.method_7353((class_2561)class_2561.method_43470((String)"You currently don't have any TPA requests!").method_27692(class_124.field_1061), false);
                return 1;
            }
            tFrom = candidates[0].tFrom;
        }
        if ((tr = this.getTPARequest(tFrom, tTo, TPAAction.DENY)) == null) {
            return 1;
        }
        if (!tr.isTPAhere() && !((Boolean)config.getValue("tpas")).booleanValue()) {
            tTo.method_7353((class_2561)class_2561.method_43470((String)"TPAs are disabled!").method_27692(class_124.field_1061), false);
            return -1;
        }
        if (tr.isTPAhere() && !((Boolean)config.getValue("tpaheres")).booleanValue()) {
            tTo.method_7353((class_2561)class_2561.method_43470((String)"TPA Heres are disabled!").method_27692(class_124.field_1061), false);
            return -1;
        }
        tr.cancelTimeout();
        activeTpas.remove(tFrom.method_5667());
        tr.tTo.method_7353((class_2561)class_2561.method_43470((String)"You have cancelled the TPA request!").method_27692(class_124.field_1061), false);
        tr.tFrom.method_7353((class_2561)class_2561.method_43470((String)tr.tTo.method_5477().getString()).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)" has cancelled the TPA request!").method_27692(class_124.field_1061)), false);
        return 1;
    }

    public int tpaCancel(CommandContext<class_2168> ctx, class_3222 tTo) throws CommandSyntaxException {
        TPARequest tr;
        if (!((class_2168)ctx.getSource()).method_43737()) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Teleports must be done by a player!").method_27692(class_124.field_1061));
            return -1;
        }
        class_3222 tFrom = ((class_2168)ctx.getSource()).method_44023();
        if (tTo == null) {
            TPARequest[] candidates = (TPARequest[])activeTpas.values().stream().filter(TPARequest2 -> TPARequest2.tFrom.equals((Object)tFrom)).toArray(TPARequest[]::new);
            if (candidates.length > 1) {
                class_5250 text = class_2561.method_43470((String)"You currently have multiple active TPA requests! Please specify which request to cancel.\n").method_27692(class_124.field_1060);
                Arrays.stream(candidates).map(TPARequest2 -> TPARequest2.tTo.method_5477().getString()).forEach(name -> text.method_10852((class_2561)class_2561.method_43470((String)name).method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/tpacancel " + name)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("/tpacancel " + name)))).method_10977(class_124.field_1060))).method_27693(" "));
                tFrom.method_7353((class_2561)text, false);
                return 1;
            }
            if (candidates.length < 1) {
                tFrom.method_7353((class_2561)class_2561.method_43470((String)"You currently don't have any TPA requests!").method_27692(class_124.field_1061), false);
                return 1;
            }
            tTo = candidates[0].tTo;
        }
        if ((tr = this.getTPARequest(tFrom, tTo, TPAAction.CANCEL)) == null) {
            return 1;
        }
        if (!tr.isTPAhere() && !((Boolean)config.getValue("tpas")).booleanValue()) {
            tTo.method_7353((class_2561)class_2561.method_43470((String)"TPAs are disabled!").method_27692(class_124.field_1061), false);
            return -1;
        }
        if (tr.isTPAhere() && !((Boolean)config.getValue("tpaheres")).booleanValue()) {
            tTo.method_7353((class_2561)class_2561.method_43470((String)"TPA Heres are disabled!").method_27692(class_124.field_1061), false);
            return -1;
        }
        tr.cancelTimeout();
        activeTpas.remove(tFrom.method_5667());
        tr.tFrom.method_7353((class_2561)class_2561.method_43470((String)"You have cancelled the TPA request!").method_27692(class_124.field_1061), false);
        tr.tTo.method_7353((class_2561)class_2561.method_43470((String)tr.tFrom.method_5477().getString()).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)" has cancelled the TPA request!").method_27692(class_124.field_1061)), false);
        return 1;
    }

    private int spawnTp(CommandContext<class_2168> ctx) {
        try {
            if (!((class_2168)ctx.getSource()).method_43737()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Teleports must be done by a player!").method_27692(class_124.field_1061));
                return -1;
            }
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            if (!((Boolean)config.getValue("spawn")).booleanValue()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"/spawn is disabled!").method_27692(class_124.field_1061), false);
                return -1;
            }
            if (this.checkCooldown(TPType.SPAWN, player)) {
                return -1;
            }
            if (this.activeChannels(player)) {
                return -1;
            }
            class_3218 world = player.method_51469().method_8503().method_74944();
            TeleportUtils.genericTeleport((Boolean)config.getValue("bossbar"), (Boolean)config.getValue("particles"), (Boolean)config.getValue("sound"), (Integer)config.getValue("spawn-warmup"), player, () -> {
                player.method_61275(new class_5454(world, world.method_74854().method_74897().method_61082(), class_243.field_1353, world.method_74854().comp_4916(), world.method_74854().comp_4917(), class_5454.field_52245));
                recentTeleports.add(new Teleport(player, TPType.SPAWN, System.currentTimeMillis()));
            });
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private int randomTp(CommandContext<class_2168> ctx) {
        try {
            if (!((class_2168)ctx.getSource()).method_43737()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Teleports must be done by a player!").method_27692(class_124.field_1061));
                return -1;
            }
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            if (!((Boolean)config.getValue("randomtps")).booleanValue()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"/randomtp is disabled!").method_27692(class_124.field_1061), false);
                return -1;
            }
            if (this.checkCooldown(TPType.RTP, player)) {
                return -1;
            }
            if (this.activeChannels(player)) {
                return -1;
            }
            class_3218 world = player.method_51469();
            int range = (Integer)config.getValue("rtp-range");
            for (int tries = 0; tries < 100; ++tries) {
                ArrayList<class_2338> locations;
                double angle = Math.PI * 2 * Math.random();
                double r = (double)range * Math.sqrt(Math.random());
                int x = (int)(r * Math.cos(angle)) + world.method_74854().method_74897().method_10263();
                int z = (int)(r * Math.sin(angle)) + world.method_74854().method_74897().method_10260();
                int placeTries = 0;
                int spread = 4;
                do {
                    locations = TeleportUtils.makeSpawnLocations(1, spread, world.method_32819() - 10, world, new class_2338(x, world.method_32819(), z));
                    ++spread;
                } while (locations.isEmpty() && ++placeTries < 5);
                if (locations.isEmpty()) {
                    continue;
                }
                class_243 pos = locations.get(0).method_46558();
                TeleportUtils.genericTeleport((Boolean)config.getValue("bossbar"), (Boolean)config.getValue("particles"), (Boolean)config.getValue("sound"), (Integer)config.getValue("rtp-warmup"), player, () -> {
                    player.method_61275(new class_5454(world, pos, class_243.field_1353, player.method_36454(), player.method_36455(), class_5454.field_52245));
                    recentTeleports.add(new Teleport(player, TPType.RTP, System.currentTimeMillis()));
                });
                return 1;
            }
            player.method_7353((class_2561)class_2561.method_43470((String)"Could not find a valid RTP spot!").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), false);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private int setHome(CommandContext<class_2168> ctx, String name) {
        try {
            if (!((class_2168)ctx.getSource()).method_43737()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Homes must be set by a player!").method_27692(class_124.field_1061));
                return -1;
            }
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            if (!((Boolean)config.getValue("homes")).booleanValue()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Homes are disabled!").method_27692(class_124.field_1061), false);
                return -1;
            }
            List<Destination> homes = ((IDestinationComponent)PlayerComponentInitializer.HOMES.get((Object)player)).getDestinations();
            if (homes.size() >= (Integer)config.getValue("max-homes")) {
                player.method_7353((class_2561)class_2561.method_43470((String)"You already have the max amount of homes").method_27692(class_124.field_1061), false);
                return -1;
            }
            if (homes.size() > 0 && name == null) {
                player.method_7353((class_2561)class_2561.method_43470((String)"You must specify a name for your new home").method_27692(class_124.field_1061), false);
                return -1;
            }
            if (name == null) {
                name = "main";
            }
            String finalName = name;
            if (homes.stream().anyMatch(h -> h.getName().equals(finalName))) {
                player.method_7353((class_2561)class_2561.method_43470((String)("You already have a home named '" + name + "'")).method_27692(class_124.field_1061), false);
                return -1;
            }
            homes.add(new Destination(name, player.method_73189(), player.method_5802(), player.method_51469().method_27983().method_29177().toString()));
            player.method_7353((class_2561)class_2561.method_43470((String)("Home '" + name + "' added successfully!")).method_27692(class_124.field_1060), false);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private int delHome(CommandContext<class_2168> ctx, String name) {
        try {
            if (!((class_2168)ctx.getSource()).method_43737()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Homes must be deleted by a player!").method_27692(class_124.field_1061));
                return -1;
            }
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            if (!((Boolean)config.getValue("homes")).booleanValue()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Homes are disabled!").method_27692(class_124.field_1061), false);
                return -1;
            }
            List<Destination> homes = ((IDestinationComponent)PlayerComponentInitializer.HOMES.get((Object)player)).getDestinations();
            if (homes.size() > 1 && name == null) {
                player.method_7353((class_2561)class_2561.method_43470((String)"You must specify which home to delete").method_27692(class_124.field_1061), false);
                return -1;
            }
            if (homes.size() == 1 && name == null) {
                name = homes.get(0).getName();
            }
            String finalName = name;
            Optional<Destination> foundHome = homes.stream().filter(h -> h.getName().equals(finalName)).findFirst();
            if (foundHome.isEmpty()) {
                player.method_7353((class_2561)class_2561.method_43470((String)("You have no home named '" + name + "'")).method_27692(class_124.field_1061), false);
                return -1;
            }
            homes.remove(foundHome.get());
            player.method_7353((class_2561)class_2561.method_43470((String)("Home '" + name + "' removed successfully!")).method_27692(class_124.field_1060), false);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private int homeTp(CommandContext<class_2168> ctx, String name) {
        try {
            if (!((class_2168)ctx.getSource()).method_43737()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Teleports must be done by a player!").method_27692(class_124.field_1061));
                return -1;
            }
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            if (!((Boolean)config.getValue("homes")).booleanValue()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Homes are disabled!").method_27692(class_124.field_1061), false);
                return -1;
            }
            List<Destination> homes = ((IDestinationComponent)PlayerComponentInitializer.HOMES.get((Object)player)).getDestinations();
            if (homes.size() == 1 && name == null) {
                name = homes.get(0).getName();
            }
            String finalName = name;
            Optional<Destination> foundHome = homes.stream().filter(h -> h.getName().equals(finalName)).findFirst();
            if (foundHome.isEmpty()) {
                player.method_7353((class_2561)class_2561.method_43470((String)("You have no home named '" + name + "'")).method_27692(class_124.field_1061), false);
                return -1;
            }
            if (this.checkCooldown(TPType.HOME, player)) {
                return -1;
            }
            if (this.activeChannels(player)) {
                return -1;
            }
            Destination home = foundHome.get();
            class_3218 world = home.getWorld(((class_2168)ctx.getSource()).method_9211());
            TeleportUtils.genericTeleport((Boolean)config.getValue("bossbar"), (Boolean)config.getValue("particles"), (Boolean)config.getValue("sound"), (Integer)config.getValue("homes-warmup"), player, () -> {
                player.method_61275(new class_5454(world, home.getPos(), class_243.field_1353, home.getRotation().field_1342, home.getRotation().field_1343, class_5454.field_52245));
                recentTeleports.add(new Teleport(player, TPType.HOME, System.currentTimeMillis()));
            });
            player.method_7353((class_2561)class_2561.method_43470((String)("Now teleporting to home '" + name + "'")).method_27692(class_124.field_1076), false);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private int setWarp(CommandContext<class_2168> ctx, String name) {
        try {
            if (!((class_2168)ctx.getSource()).method_43737()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Warps must be set by a player!").method_27692(class_124.field_1061));
                return -1;
            }
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            if (!((Boolean)config.getValue("warps")).booleanValue()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Warps are disabled!").method_27692(class_124.field_1061), false);
                return -1;
            }
            List<Destination> warps = ((IDestinationComponent)WorldDataComponentInitializer.WARPS.get((Object)((class_2168)ctx.getSource()).method_9211().method_3847(class_3218.field_25179))).getDestinations();
            if (warps.stream().anyMatch(h -> h.getName().equals(name))) {
                player.method_7353((class_2561)class_2561.method_43470((String)("There already is a warp named '" + name + "'")).method_27692(class_124.field_1061), false);
                return -1;
            }
            warps.add(new Destination(name, player.method_73189(), player.method_5802(), player.method_51469().method_27983().method_29177().toString()));
            player.method_7353((class_2561)class_2561.method_43470((String)("Warp '" + name + "' added successfully!")).method_27692(class_124.field_1060), false);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private int delWarp(CommandContext<class_2168> ctx, String name) {
        try {
            if (!((class_2168)ctx.getSource()).method_43737()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Warps must be deleted by a player!").method_27692(class_124.field_1061));
                return -1;
            }
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            if (!((Boolean)config.getValue("warps")).booleanValue()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Warps are disabled!").method_27692(class_124.field_1061), false);
                return -1;
            }
            List<Destination> warps = ((IDestinationComponent)WorldDataComponentInitializer.WARPS.get((Object)((class_2168)ctx.getSource()).method_9211().method_3847(class_3218.field_25179))).getDestinations();
            Optional<Destination> foundWarp = warps.stream().filter(h -> h.getName().equals(name)).findFirst();
            if (foundWarp.isEmpty()) {
                player.method_7353((class_2561)class_2561.method_43470((String)("There is no warp named '" + name + "'")).method_27692(class_124.field_1061), false);
                return -1;
            }
            warps.remove(foundWarp.get());
            player.method_7353((class_2561)class_2561.method_43470((String)("Warp '" + name + "' removed successfully!")).method_27692(class_124.field_1060), false);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private int warpTp(CommandContext<class_2168> ctx, String name) {
        try {
            if (!((class_2168)ctx.getSource()).method_43737()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Teleports must be done by a player!").method_27692(class_124.field_1061));
                return -1;
            }
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            if (!((Boolean)config.getValue("warps")).booleanValue()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Warps are disabled!").method_27692(class_124.field_1061), false);
                return -1;
            }
            List<Destination> warps = ((IDestinationComponent)WorldDataComponentInitializer.WARPS.get((Object)((class_2168)ctx.getSource()).method_9211().method_3847(class_3218.field_25179))).getDestinations();
            Optional<Destination> foundWarp = warps.stream().filter(h -> h.getName().equals(name)).findFirst();
            if (foundWarp.isEmpty()) {
                player.method_7353((class_2561)class_2561.method_43470((String)("There is no warp named '" + name + "'")).method_27692(class_124.field_1061), false);
                return -1;
            }
            if (this.checkCooldown(TPType.WARP, player)) {
                return -1;
            }
            if (this.activeChannels(player)) {
                return -1;
            }
            Destination warp = foundWarp.get();
            class_3218 world = warp.getWorld(((class_2168)ctx.getSource()).method_9211());
            TeleportUtils.genericTeleport((Boolean)config.getValue("bossbar"), (Boolean)config.getValue("particles"), (Boolean)config.getValue("sound"), (Integer)config.getValue("warps-warmup"), player, () -> {
                player.method_61275(new class_5454(world, warp.getPos(), class_243.field_1353, warp.getRotation().field_1342, warp.getRotation().field_1343, class_5454.field_52245));
                recentTeleports.add(new Teleport(player, TPType.WARP, System.currentTimeMillis()));
            });
            player.method_7353((class_2561)class_2561.method_43470((String)("Now warping to '" + name + "'")).method_27692(class_124.field_1076), false);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private static void onTick(MinecraftServer minecraftServer) {
        try {
            ArrayList<UUID> toRemove = new ArrayList<UUID>();
            for (Map.Entry<UUID, GenericTimer> entry : SERVER_TIMER_CALLBACKS.entrySet()) {
                GenericTimer t = entry.getValue();
                if (t.decreaseTimer() != 0) continue;
                t.onTimer();
                if (!t.autoRemove && !t.isTrash()) continue;
                toRemove.add(entry.getKey());
            }
            if (SERVER_TIMER_CALLBACKS_QUEUE.size() > 0) {
                SERVER_TIMER_CALLBACKS.putAll(SERVER_TIMER_CALLBACKS_QUEUE);
                SERVER_TIMER_CALLBACKS_QUEUE.clear();
            }
            for (UUID uuid : toRemove) {
                SERVER_TIMER_CALLBACKS.remove(uuid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void playerDied(class_3222 player) {
        try {
            activeTpas.entrySet().removeIf(entry -> {
                TPARequest req = (TPARequest)entry.getValue();
                if (req.tFrom.method_5667().equals(player.method_5667())) {
                    req.cancelTimeout();
                    return true;
                }
                if (req.tTo.method_5667().equals(player.method_5667())) {
                    req.cancelTimeout();
                    return true;
                }
                return false;
            });
            SERVER_TIMER_CALLBACKS.entrySet().removeIf(t -> {
                Object patt0$temp = t.getValue();
                if (!(patt0$temp instanceof TeleportTimer)) return false;
                TeleportTimer tp = (TeleportTimer)patt0$temp;
                if (!tp.player.method_5667().equals(player.method_5667())) return false;
                return true;
            });
            SERVER_TIMER_CALLBACKS_QUEUE.entrySet().removeIf(t -> {
                Object patt0$temp = t.getValue();
                if (!(patt0$temp instanceof TeleportTimer)) return false;
                TeleportTimer tp = (TeleportTimer)patt0$temp;
                if (!tp.player.method_5667().equals(player.method_5667())) return false;
                return true;
            });
            class_3004 bbm = player.method_51469().method_8503().method_3837();
            bbm.method_12969().stream().filter(b -> b.method_12959().toString().contains("standstill-" + String.valueOf(player.method_5667()))).toList().forEach(b -> {
                b.method_14094();
                bbm.method_12973(b);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean activeChannels(class_3222 player) {
        boolean active = SERVER_TIMER_CALLBACKS.entrySet().stream().anyMatch(t -> {
            Object patt0$temp = t.getValue();
            if (!(patt0$temp instanceof TeleportTimer)) return false;
            TeleportTimer tp = (TeleportTimer)patt0$temp;
            if (!tp.player.method_5667().equals(player.method_5667())) return false;
            return true;
        });
        if (active) {
            player.method_7353((class_2561)class_2561.method_43470((String)"You are already channeling a teleport!").method_27692(class_124.field_1061), false);
        }
        return active;
    }

    private boolean checkCooldown(TPType type, class_3222 player) {
        for (Teleport tp : recentTeleports) {
            if (!tp.player.method_5845().equals(player.method_5845()) || tp.type != type || System.currentTimeMillis() - tp.timestamp >= (long)this.readConfigCooldown(type) * 50L) continue;
            int remaining = (int)(((long)this.readConfigCooldown(type) * 50L - (System.currentTimeMillis() - tp.timestamp)) / 1000L);
            player.method_7353((class_2561)class_2561.method_43470((String)("You cannot /" + type.label + " for another " + remaining + " seconds.")).method_27692(class_124.field_1061), false);
            return true;
        }
        return false;
    }

    private boolean checkTPAHereCooldown(class_3222 tFrom, class_3222 tTo) {
        for (Teleport tp : recentTeleports) {
            if (!tp.player.method_5845().equals(tFrom.method_5845()) || tp.type != TPType.TPA || System.currentTimeMillis() - tp.timestamp >= (long)this.readConfigCooldown(TPType.TPA) * 50L) continue;
            int remaining = (int)(((long)this.readConfigCooldown(TPType.TPA) * 50L - (System.currentTimeMillis() - tp.timestamp)) / 1000L);
            tTo.method_7353((class_2561)class_2561.method_43470((String)("That player cannot /" + TPType.TPA.label + " for another " + remaining + " seconds.")).method_27692(class_124.field_1061), false);
            return true;
        }
        return false;
    }

    private int readConfigCooldown(TPType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> (Integer)config.getValue("tpa-cooldown");
            case 0 -> (Integer)config.getValue("homes-cooldown");
            case 2 -> (Integer)config.getValue("warps-cooldown");
            case 3 -> (Integer)config.getValue("spawn-cooldown");
            case 4 -> (Integer)config.getValue("rtp-cooldown");
        };
    }

    private TPARequest getTPARequest(class_3222 tFrom, class_3222 tTo, TPAAction action) {
        Optional<TPARequest> otr = activeTpas.values().stream().filter(tpaRequest -> tpaRequest.tFrom.equals((Object)tFrom) && tpaRequest.tTo.equals((Object)tTo)).findFirst();
        if (otr.isEmpty()) {
            if (action == TPAAction.CANCEL) {
                tFrom.method_7353((class_2561)class_2561.method_43470((String)"No ongoing request!").method_27692(class_124.field_1061), false);
            } else {
                tTo.method_7353((class_2561)class_2561.method_43470((String)"No ongoing request!").method_27692(class_124.field_1061), false);
            }
            return null;
        }
        return otr.get();
    }

    static {
        activeTpas = new HashMap();
        recentTeleports = new ArrayList();
    }

    private static enum TPType {
        HOME("home"),
        TPA("tpa"),
        WARP("warp"),
        SPAWN("spawn"),
        RTP("rtp");

        public final String label;

        private TPType(String name) {
            this.label = name;
        }
    }

    static class TPARequest {
        class_3222 tFrom;
        class_3222 tTo;
        boolean tpahere;
        UUID timerId;

        public TPARequest(class_3222 tFrom, class_3222 tTo, boolean tpahere) {
            this.tFrom = tFrom;
            this.tTo = tTo;
            this.tpahere = tpahere;
        }

        String getStr() {
            return this.tpahere ? "TPA Here" : "TPA";
        }

        public boolean isTPAhere() {
            return this.tpahere;
        }

        void setTimeoutCallback() {
            GenericTimer timer = new GenericTimer((Integer)config.getValue("tpa-timeout"), new TimerTask(){

                @Override
                public void run() {
                    activeTpas.remove(tFrom.method_5667());
                    tFrom.method_7353((class_2561)class_2561.method_43470((String)("Your " + this.getStr() + " request to " + tTo.method_5477().getString() + " has timed out!")).method_27692(class_124.field_1061), false);
                    tTo.method_7353((class_2561)class_2561.method_43470((String)(this.getStr() + " request from " + tFrom.method_5477().getString() + " has timed out!")).method_27692(class_124.field_1061), false);
                }
            });
            this.timerId = UUID.randomUUID();
            SERVER_TIMER_CALLBACKS.put(this.timerId, timer);
        }

        void cancelTimeout() {
            SERVER_TIMER_CALLBACKS.remove(this.timerId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TPARequest that = (TPARequest)o;
            return this.tFrom.equals((Object)that.tFrom) && this.tTo.equals((Object)that.tTo);
        }

        public int hashCode() {
            return Objects.hash(this.tFrom, this.tTo);
        }

        public String toString() {
            return "TPARequest{tFrom=" + String.valueOf(this.tFrom) + ", tTo=" + String.valueOf(this.tTo) + "}";
        }

        public void refreshPlayers() {
            this.tFrom = this.tFrom.method_51469().method_8503().method_3760().method_14602(this.tFrom.method_5667());
            this.tTo = this.tTo.method_51469().method_8503().method_3760().method_14602(this.tTo.method_5667());
            assert (this.tFrom != null && this.tTo != null);
        }
    }

    private static enum TPAAction {
        ACCEPT,
        DENY,
        CANCEL;

    }

    record Teleport(class_3222 player, TPType type, long timestamp) {
    }
}

