/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.endernexus.utils;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigUtils {
    public List<IConfigValue> values;
    private final File file;
    private final Logger logger;

    public ConfigUtils(File file, Logger logger, List<IConfigValue> values) {
        this.file = file;
        this.logger = logger;
        this.values = values;
        this.read();
        this.save();
    }

    public void read() {
        Properties props = new Properties();
        try (FileInputStream input = new FileInputStream(this.file);){
            this.logger.debug("Reading config...");
            props.load(input);
            for (IConfigValue value2 : this.values) {
                Object defaultValue = value2.defaultValue;
                try {
                    value2.value = value2.getFromProps(props);
                }
                catch (Exception e) {
                    value2.value = defaultValue;
                }
            }
        }
        catch (FileNotFoundException ignored) {
            this.logger.debug("Initialising config...");
            this.values.forEach(value -> {
                value.value = value.defaultValue;
            });
        }
        catch (IOException e) {
            this.logger.fatal("Failed to load config file!");
            e.printStackTrace();
        }
        catch (Exception e) {
            this.logger.fatal("Failed to parse the config!");
            e.printStackTrace();
        }
    }

    public void save() {
        Properties props = new Properties();
        this.values.forEach(value -> value.setToProps(props));
        this.logger.debug("Updating config...");
        try (FileOutputStream output = new FileOutputStream(this.file);){
            props.store(output, null);
        }
        catch (IOException e) {
            this.logger.fatal("Failed to load config file!");
            e.printStackTrace();
        }
    }

    public LiteralArgumentBuilder<class_2168> generateCommand(String commandName) {
        LiteralArgumentBuilder out = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandName).requires(source -> source.method_9259(4))).executes(ctx -> {
            this.values.stream().filter(v -> v.command != null).forEach(value -> ((class_2168)ctx.getSource()).method_9226(() -> class_5250.method_43477((class_7417)new class_2588(value.command.getterText, null, (Object[])new String[]{value.value.toString()})), false));
            return 1;
        });
        this.values.stream().filter(v -> v.command != null).forEach(value -> out.then(((LiteralArgumentBuilder)class_2170.method_9247((String)value.name).executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9226(() -> class_5250.method_43477((class_7417)new class_2588(value.command.getterText, null, (Object[])new String[]{value.value.toString()})), false);
            return 1;
        })).then(class_2170.method_9244((String)value.name, value.getArgumentType()).suggests(value.suggestions).executes(ctx -> {
            value.value = value.parseArgumentValue((CommandContext<class_2168>)ctx);
            ((class_2168)ctx.getSource()).method_9226(() -> class_5250.method_43477((class_7417)new class_2588(value.command.setterText, null, (Object[])new String[]{value.value.toString()})), true);
            this.save();
            return 1;
        }))));
        return out;
    }

    public Object getValue(String name) {
        return this.values.stream().filter(value -> value.name.equals(name)).findFirst().map(iConfigValue -> iConfigValue.value).orElse(null);
    }

    public static abstract class IConfigValue<T> {
        protected final T defaultValue;
        protected final String name;
        protected final String comment;
        protected final Command command;
        protected final SuggestionProvider<T> suggestions;
        protected T value;

        public IConfigValue(@NotNull String name, T defaultValue, @Nullable String comment, @Nullable Command command, @Nullable SuggestionProvider<T> suggestions) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.comment = comment;
            this.command = command;
            this.suggestions = suggestions;
        }

        public abstract T getFromProps(Properties var1);

        public void setToProps(Properties props) {
            props.setProperty(this.name, String.valueOf(this.value));
            if (this.comment != null) {
                props.setProperty(this.name + ".comment", this.comment);
            }
        }

        public abstract ArgumentType<?> getArgumentType();

        public abstract T parseArgumentValue(CommandContext<class_2168> var1);
    }

    public static class Command {
        protected String setterText;
        protected String getterText;
        protected String errorText;

        public Command(String getterText, String setterText, @Nullable String errorText) {
            this.getterText = getterText;
            this.setterText = setterText;
            this.errorText = errorText;
        }

        public Command(String getterText, String setterText) {
            this(getterText, setterText, null);
        }
    }

    public static class BooleanConfigValue
    extends IConfigValue<Boolean> {
        protected final boolean defaultValue;

        public BooleanConfigValue(@NotNull String name, boolean defaultValue, @Nullable String comment, @Nullable Command command, @Nullable SuggestionProvider<Boolean> suggestions) {
            super(name, defaultValue, comment, command, suggestions);
            this.defaultValue = defaultValue;
        }

        public BooleanConfigValue(@NotNull String name, boolean defaultValue, @Nullable Command command) {
            this(name, defaultValue, (String)null, command, (SuggestionProvider<Boolean>)null);
        }

        @Override
        public Boolean getFromProps(Properties props) {
            return Boolean.parseBoolean(props.getProperty(this.name));
        }

        @Override
        public ArgumentType<Boolean> getArgumentType() {
            return BoolArgumentType.bool();
        }

        @Override
        public Boolean parseArgumentValue(CommandContext<class_2168> ctx) {
            return BoolArgumentType.getBool(ctx, (String)this.name);
        }
    }

    public static class IntegerConfigValue
    extends IConfigValue<Integer> {
        protected final int defaultValue;
        private final IntLimits limits;

        public IntegerConfigValue(@NotNull String name, Integer defaultValue, IntLimits limits, @Nullable String comment, @Nullable Command command, SuggestionProvider<Integer> suggestions) {
            super(name, defaultValue, comment, command, suggestions);
            this.defaultValue = defaultValue;
            this.limits = limits;
        }

        public IntegerConfigValue(@NotNull String name, Integer defaultValue, IntLimits limits, @Nullable String comment, @Nullable Command command) {
            this(name, defaultValue, limits, comment, command, null);
        }

        public IntegerConfigValue(@NotNull String name, Integer defaultValue, IntLimits limits, @Nullable Command command) {
            this(name, defaultValue, limits, null, command, null);
        }

        @Override
        public Integer getFromProps(Properties props) {
            return Integer.parseInt(props.getProperty(this.name));
        }

        @Override
        public ArgumentType<Integer> getArgumentType() {
            return IntegerArgumentType.integer((int)this.limits.min, (int)this.limits.max);
        }

        @Override
        public Integer parseArgumentValue(CommandContext<class_2168> ctx) {
            return IntegerArgumentType.getInteger(ctx, (String)this.name);
        }

        public static class IntLimits {
            int min = Integer.MIN_VALUE;
            int max = Integer.MAX_VALUE;

            public IntLimits() {
            }

            public IntLimits(int min) {
                this.min = min;
            }

            public IntLimits(int min, int max) {
                this.min = min;
                this.max = max;
            }
        }
    }
}

