/*
 * Decompiled with CFR 0.152.
 */
package justparry;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Itempropreties {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Path CONFIG_FILE = FMLPaths.CONFIGDIR.get().resolve("justparry/itempropreties.txt");
    private static final String DEFAULT_ITEM = "just_parry:justparryiteminhand";
    private static final String DEFAULT_ENTRY = "item=just_parry:justparryiteminhand canparry=false itemknockback=0.8 itemparrydamage=2.0 canprojectileboost=false canprojectileparry=false itemspeedmultiplier=2.0 itemaccurancypercentage=0.0 parrydamageabsorptionpercentage=100.0 parrywindow=13.0 parrycooldown=65.0 damageformula=0.0";

    public static void ensureFileExists() {
        try {
            if (Files.notExists(CONFIG_FILE, new LinkOption[0])) {
                Files.writeString(CONFIG_FILE, (CharSequence)"item=just_parry:justparryiteminhand canparry=false itemknockback=0.8 itemparrydamage=2.0 canprojectileboost=false canprojectileparry=false itemspeedmultiplier=2.0 itemaccurancypercentage=0.0 parrydamageabsorptionpercentage=100.0 parrywindow=13.0 parrycooldown=65.0 damageformula=0.0\n", StandardOpenOption.CREATE);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to create config file {}", (Object)CONFIG_FILE, (Object)e);
        }
    }

    public static ItemPropertiesData getItemPropertiesData(String registryName) {
        Itempropreties.ensureFileExists();
        try {
            List<String> lines = Files.readAllLines(CONFIG_FILE);
            String searchPrefix = "item=" + registryName + " ";
            for (String line : lines) {
                if (!line.startsWith(searchPrefix)) continue;
                return Itempropreties.parseItemProperties(line);
            }
            if (registryName.equals(DEFAULT_ITEM)) {
                Itempropreties.addDefaultEntry();
                return Itempropreties.parseItemProperties(DEFAULT_ENTRY);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to read config file: {}", (Object)CONFIG_FILE, (Object)e);
        }
        return null;
    }

    private static void addDefaultEntry() {
        try {
            List<String> lines = Files.readAllLines(CONFIG_FILE);
            boolean exists = lines.stream().anyMatch(line -> line.startsWith("item=just_parry:justparryiteminhand "));
            if (!exists) {
                Files.writeString(CONFIG_FILE, (CharSequence)"item=just_parry:justparryiteminhand canparry=false itemknockback=0.8 itemparrydamage=2.0 canprojectileboost=false canprojectileparry=false itemspeedmultiplier=2.0 itemaccurancypercentage=0.0 parrydamageabsorptionpercentage=100.0 parrywindow=13.0 parrycooldown=65.0 damageformula=0.0\n", StandardOpenOption.APPEND);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to add default entry to config file: {}", (Object)CONFIG_FILE, (Object)e);
        }
    }

    private static ItemPropertiesData parseItemProperties(String line) {
        String[] tokens = line.split(" ");
        ItemPropertiesData data = new ItemPropertiesData();
        for (int i = 1; i < tokens.length; ++i) {
            String[] keyValue = tokens[i].split("=");
            if (keyValue.length != 2) continue;
            try {
                switch (keyValue[0]) {
                    case "canparry": {
                        data.canparry = Boolean.parseBoolean(keyValue[1]);
                        break;
                    }
                    case "itemknockback": {
                        data.itemknockback = Double.parseDouble(keyValue[1]);
                        break;
                    }
                    case "itemparrydamage": {
                        data.itemparrydamage = Double.parseDouble(keyValue[1]);
                        break;
                    }
                    case "canprojectileboost": {
                        data.canprojectileboost = Boolean.parseBoolean(keyValue[1]);
                        break;
                    }
                    case "canprojectileparry": {
                        data.canprojectileparry = Boolean.parseBoolean(keyValue[1]);
                        break;
                    }
                    case "itemspeedmultiplier": {
                        data.itemspeedmultiplier = Double.parseDouble(keyValue[1]);
                        break;
                    }
                    case "iteminaccurancypercentage": {
                        data.itemaccurancypercentage = Double.parseDouble(keyValue[1]);
                        break;
                    }
                    case "parrydamageabsorptionpercentage": {
                        data.parrydamageabsorptionpercentage = Double.parseDouble(keyValue[1]);
                        break;
                    }
                    case "parrywindow": {
                        data.parrywindow = Double.parseDouble(keyValue[1]);
                        break;
                    }
                    case "parrycooldown": {
                        data.parrycooldown = Double.parseDouble(keyValue[1]);
                        break;
                    }
                    case "damageformula": {
                        data.damageformula = Double.parseDouble(keyValue[1]);
                        break;
                    }
                }
                continue;
            }
            catch (NumberFormatException e) {
                LOGGER.error("Failed to parse property {} with value {}", (Object)keyValue[0], (Object)keyValue[1], (Object)e);
            }
        }
        return data;
    }

    public static void updateConfigFile(String newEntry) {
        Itempropreties.ensureFileExists();
        try {
            List<String> lines = Files.readAllLines(CONFIG_FILE);
            String itemKey = newEntry.split(" ")[0];
            boolean updated = false;
            for (int i = 0; i < lines.size(); ++i) {
                if (!lines.get(i).startsWith(itemKey)) continue;
                lines.set(i, newEntry);
                updated = true;
                break;
            }
            if (!updated) {
                lines.add(newEntry);
            }
            Files.write(CONFIG_FILE, lines, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.error("Failed to update config file: {}", (Object)CONFIG_FILE, (Object)e);
        }
    }

    public static class ItemPropertiesData {
        public boolean canparry = false;
        public double itemknockback = 0.8;
        public double itemparrydamage = 2.0;
        public boolean canprojectileboost = false;
        public boolean canprojectileparry = false;
        public double itemspeedmultiplier = 2.0;
        public double itemaccurancypercentage = 0.0;
        public double parrydamageabsorptionpercentage = 100.0;
        public double parrywindow = 13.0;
        public double parrycooldown = 65.0;
        public double damageformula = 0.0;

        public String toString() {
            return "ItemPropertiesData{canparry=" + this.canparry + ", itemknockback=" + this.itemknockback + ", itemparrydamage=" + this.itemparrydamage + ", canprojectileboost=" + this.canprojectileboost + ", canprojectileparry=" + this.canprojectileparry + ", itemspeedmultiplier=" + this.itemspeedmultiplier + ", iteminaccurancypercentage=" + this.itemaccurancypercentage + ", parrydamageabsorptionpercentage=" + this.parrydamageabsorptionpercentage + ", parrywindow=" + this.parrywindow + ", parrycooldown=" + this.parrycooldown + ", damageformula=" + this.damageformula + "}";
        }
    }
}

