/*
 * Decompiled with CFR 0.152.
 */
package com.github.tatercertified.lifesteal;

import com.github.tatercertified.lifesteal.block.ModBlocks;
import com.github.tatercertified.lifesteal.commands.AdminReviveCommand;
import com.github.tatercertified.lifesteal.commands.GiftCommand;
import com.github.tatercertified.lifesteal.commands.ReviveCommand;
import com.github.tatercertified.lifesteal.commands.WithdrawCommand;
import com.github.tatercertified.lifesteal.data.DeathData;
import com.github.tatercertified.lifesteal.effect.InvulnerableStatusEffect;
import com.github.tatercertified.lifesteal.gamerules.LifeStealGamerules;
import com.github.tatercertified.lifesteal.items.HeartItem;
import com.github.tatercertified.lifesteal.items.ModItems;
import com.github.tatercertified.lifesteal.mixin.ServerPlayerEntityServerAccessor;
import com.github.tatercertified.lifesteal.utils.PlayerInvulnerabilityInterface;
import com.github.tatercertified.lifesteal.utils.PlayerUtils;
import com.github.tatercertified.lifesteal.world.Ores;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class Lifesteal
implements ModInitializer {
    public static final String MOD_ID = "lifesteal";
    public static final Map<UUID, DeathData> DEAD_PLAYERS = new HashMap<UUID, DeathData>();
    public static final Path DEAD_PLAYERS_FILE_PATH = Path.of(FabricLoader.getInstance().getConfigDir().resolve("lifesteal-deaths.json").toString(), new String[0]);
    public static class_268 invulnerableTeam;

    public void onInitialize() {
        PolymerResourcePackUtils.addModAssets((String)MOD_ID);
        DeathData.loadDeathDataFromFile();
        ModItems.initialize();
        ModBlocks.registerBlocks();
        Ores.initOres();
        AdminReviveCommand.register();
        ReviveCommand.register();
        GiftCommand.register();
        WithdrawCommand.register();
        LifeStealGamerules.init();
        InvulnerableStatusEffect.register();
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, b) -> {
            if (((PlayerInvulnerabilityInterface)oldPlayer).isReviveInvulnerable()) {
                newPlayer.method_6092(new class_1293(InvulnerableStatusEffect.INVULNERABLE, ((PlayerInvulnerabilityInterface)oldPlayer).getRemaining(), 0, false, false, true));
                ((ServerPlayerEntityServerAccessor)newPlayer).getServer().method_3845().method_1172(newPlayer.method_5820(), invulnerableTeam);
            }
        });
        ServerLifecycleEvents.SERVER_STARTING.register(minecraftServer -> {
            LifeStealGamerules.serverInstance = minecraftServer;
        });
        ServerLifecycleEvents.SERVER_STARTED.register(minecraftServer -> {
            boolean containsTeam = minecraftServer.method_3845().method_1159().stream().anyMatch(team -> team.method_1197().equals("invulnerable"));
            if (!containsTeam) {
                invulnerableTeam = minecraftServer.method_3845().method_1171("invulnerable");
                invulnerableTeam.method_1141(class_124.field_1079);
                invulnerableTeam.method_1149(class_270.class_272.field_1442);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> PlayerUtils.handlePlayerJoin(handler.method_32311()));
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_3222 serverPlayer;
            MinecraftServer server;
            if (player instanceof class_3222 && (server = ((ServerPlayerEntityServerAccessor)(serverPlayer = (class_3222)player)).getServer()).method_3767().method_8355(LifeStealGamerules.ALTARS) && serverPlayer.method_5715() && hand == serverPlayer.method_6058() && serverPlayer.method_5998(hand).method_7960() && HeartItem.isAltar(world, hitResult.method_17777())) {
                PlayerUtils.convertHealthToHeartItems(serverPlayer, 1, server, true);
            }
            return class_1269.field_5811;
        });
    }
}

