/*
 * Decompiled with CFR 0.152.
 */
package com.github.tatercertified.lifesteal.commands;

import com.github.tatercertified.lifesteal.data.DeathData;
import com.github.tatercertified.lifesteal.gamerules.LifeStealGamerules;
import com.github.tatercertified.lifesteal.utils.LifeStealText;
import com.github.tatercertified.lifesteal.utils.OfflinePlayerData;
import com.github.tatercertified.lifesteal.utils.PlayerMaxHealthInterface;
import com.github.tatercertified.lifesteal.utils.PlayerUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_11560;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class GiftCommand {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, dedicated) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"gift").requires(class_2168::method_43737)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).then(class_2170.method_9244((String)"healthPoints", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(GiftCommand::gift)))));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int gift(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        class_1928 gameRules = server.method_3767();
        if (gameRules.method_8355(LifeStealGamerules.ALTARS)) {
            source.method_9213(LifeStealText.GIFT_ALTAR);
            return 0;
        }
        if (!gameRules.method_8355(LifeStealGamerules.GIFTHEARTS)) {
            source.method_9213(LifeStealText.GIFT_DISABLED);
            return 0;
        }
        int amount = IntegerArgumentType.getInteger(context, (String)"healthPoints");
        class_3222 player = source.method_9207();
        double maxHealth = ((PlayerMaxHealthInterface)player).getBaseMaxHealth();
        if (!PlayerUtils.canChangeHealth(maxHealth, -amount, gameRules)) {
            source.method_9213(LifeStealText.LOW_HEALTH);
            return 0;
        }
        Collection profiles = class_2191.method_9330(context, (String)"player");
        if (profiles.isEmpty()) {
            source.method_9213(LifeStealText.GIFT_NONE);
            return 0;
        }
        if (profiles.size() > 1) {
            source.method_9213(LifeStealText.GIFT_MULTIPLE);
            return 0;
        }
        class_11560 receiver = (class_11560)profiles.iterator().next();
        if (receiver.comp_4422() == player.method_5667()) {
            source.method_9213(LifeStealText.noSelfGifting(player.method_5477()));
            return 0;
        }
        if (DeathData.isPlayerDead(receiver.comp_4422(), gameRules.method_8356(LifeStealGamerules.AUTOREVIVAL))) {
            source.method_9213(LifeStealText.isDead(class_2561.method_30163((String)receiver.comp_4423())));
            return 0;
        }
        class_3222 receiverPlayer = server.method_3760().method_14602(receiver.comp_4422());
        if (receiverPlayer != null) {
            if (PlayerUtils.changeHealth(receiverPlayer, amount)) {
                PlayerUtils.changeHealthUnchecked(player, -amount);
                player.method_64398(LifeStealText.giftSuccess(amount, receiverPlayer.method_5477()));
                receiverPlayer.method_64398(LifeStealText.receiveGift(amount, player.method_5477()));
                return 1;
            }
            source.method_9213(LifeStealText.receiverTooMuchHealth(receiverPlayer.method_5477()));
            return 0;
        }
        OfflinePlayerData offlinePlayerData = OfflinePlayerData.getOfflinePlayerData(server, receiver);
        double offlineMaxHealth = offlinePlayerData.getMaxHealth();
        class_2561 receiverName = class_2561.method_30163((String)receiver.comp_4423());
        if (PlayerUtils.canChangeHealth(offlineMaxHealth, amount, gameRules)) {
            PlayerUtils.changeHealthUnchecked(player, -amount);
            offlinePlayerData.setMaxHealth(offlineMaxHealth + (double)amount);
            player.method_64398(LifeStealText.giftSuccess(amount, receiverName));
            return 1;
        }
        source.method_9213(LifeStealText.receiverTooMuchHealth(receiverName));
        return 0;
    }
}

