/*
 * Decompiled with CFR 0.152.
 */
package com.github.tatercertified.lifesteal.commands;

import com.github.tatercertified.lifesteal.Lifesteal;
import com.github.tatercertified.lifesteal.data.DeathData;
import com.github.tatercertified.lifesteal.gamerules.LifeStealGamerules;
import com.github.tatercertified.lifesteal.items.HeartItem;
import com.github.tatercertified.lifesteal.utils.LifeStealText;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_11560;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3965;
import net.minecraft.server.MinecraftServer;

public class ReviveCommand {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, dedicated) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"revive").requires(class_2168::method_43737)).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).suggests(ReviveCommand::suggestPlayers).executes(ReviveCommand::revive))));
    }

    private static CompletableFuture<Suggestions> suggestPlayers(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        for (UUID playerId : Lifesteal.DEAD_PLAYERS.keySet()) {
            Optional optionalGameProfile = server.method_73550().comp_4407().method_14512(playerId);
            optionalGameProfile.ifPresent(profile -> {
                if (DeathData.isPlayerDead(profile.comp_4422(), server.method_3767().method_8356(LifeStealGamerules.AUTOREVIVAL))) {
                    builder.suggest(profile.comp_4423());
                }
            });
        }
        return builder.buildFuture();
    }

    private static int revive(CommandContext<class_2168> context) {
        class_11560 profile;
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        class_2168 source = (class_2168)context.getSource();
        if (((class_1928.class_4310)server.method_3767().method_20746(LifeStealGamerules.ALTARS)).method_20753()) {
            source.method_9213(LifeStealText.REVIVE_ALTAR);
            return 0;
        }
        class_1799 holding = source.method_44023().method_6047();
        if (!(holding.method_7909() instanceof HeartItem)) {
            source.method_9213(LifeStealText.REVIVE_HOLD);
            return 0;
        }
        String name = StringArgumentType.getString(context, (String)"player");
        Optional optionalGameProfile = server.method_73550().comp_4407().method_14515(name);
        if (optionalGameProfile.isPresent()) {
            profile = (class_11560)optionalGameProfile.get();
            if (!DeathData.isPlayerDead(profile.comp_4422(), 0)) {
                source.method_9213(LifeStealText.playerIsAlive(class_2561.method_30163((String)profile.comp_4423())));
                return 0;
            }
        } else {
            source.method_9213(LifeStealText.notFound(name));
            return 0;
        }
        class_1838 usageContext = new class_1838((class_1657)source.method_44023(), class_1268.field_5808, new class_3965(source.method_44023().method_73189(), class_2350.field_11033, source.method_44023().method_24515(), true));
        HeartItem.revive(profile.comp_4422(), server, source.method_9225(), source.method_44023().method_24515(), source.method_44023(), Optional.of(usageContext));
        return 1;
    }
}

