/*
 * Decompiled with CFR 0.152.
 */
package com.github.tatercertified.lifesteal.data;

import com.github.tatercertified.lifesteal.Lifesteal;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class DeathData {
    private final UUID deadPlayerID;
    public UUID reviverPlayerID;
    public final long deathTime;

    public DeathData(UUID deadPlayerID) {
        this.deadPlayerID = deadPlayerID;
        this.deathTime = System.currentTimeMillis() / 1000L;
    }

    public void addToDeathDataList() {
        Lifesteal.DEAD_PLAYERS.put(this.deadPlayerID, this);
        DeathData.saveDeathDataToFile();
    }

    public static void removeFromDeathDataList(UUID playerID) {
        Lifesteal.DEAD_PLAYERS.remove(playerID);
        DeathData.saveDeathDataToFile();
    }

    public static void setReviver(UUID deadPlayer, UUID reviver) {
        Lifesteal.DEAD_PLAYERS.get((Object)deadPlayer).reviverPlayerID = reviver;
    }

    public static void saveDeathDataToFile() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        ArrayList<DeathData> deathData = new ArrayList<DeathData>(Lifesteal.DEAD_PLAYERS.values());
        String data = gson.toJson(deathData);
        if (Files.notExists(Lifesteal.DEAD_PLAYERS_FILE_PATH, new LinkOption[0])) {
            try {
                Files.createFile(Lifesteal.DEAD_PLAYERS_FILE_PATH, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Files.writeString(Lifesteal.DEAD_PLAYERS_FILE_PATH, (CharSequence)data, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write data to file: " + String.valueOf(Lifesteal.DEAD_PLAYERS_FILE_PATH), e);
        }
    }

    public static void loadDeathDataFromFile() {
        Gson gson = new Gson();
        try {
            String jsonData;
            List data;
            if (Files.notExists(Lifesteal.DEAD_PLAYERS_FILE_PATH, new LinkOption[0])) {
                Files.createFile(Lifesteal.DEAD_PLAYERS_FILE_PATH, new FileAttribute[0]);
            }
            if ((data = (List)gson.fromJson(jsonData = Files.readString(Lifesteal.DEAD_PLAYERS_FILE_PATH), new TypeToken<List<DeathData>>(){}.getType())) != null) {
                for (DeathData deathData : data) {
                    Lifesteal.DEAD_PLAYERS.put(deathData.deadPlayerID, deathData);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read data from file: " + String.valueOf(Lifesteal.DEAD_PLAYERS_FILE_PATH), e);
        }
    }

    public static boolean isPlayerDead(UUID player, int waitTime) {
        DeathData data = Lifesteal.DEAD_PLAYERS.get(player);
        if (data != null) {
            if (DeathData.shouldAutoRevive(data, waitTime)) {
                DeathData.removeFromDeathDataList(player);
                return false;
            }
            return data.reviverPlayerID == null;
        }
        return false;
    }

    public static boolean shouldAutoRevive(DeathData data, int waitTime) {
        if (waitTime == 0) {
            return false;
        }
        return (double)waitTime <= (double)System.currentTimeMillis() * 0.001 - (double)data.deathTime;
    }
}

