/*
 * Decompiled with CFR 0.152.
 */
package com.github.tatercertified.lifesteal.gametest;

import com.github.tatercertified.lifesteal.data.DeathData;
import com.github.tatercertified.lifesteal.gamerules.DeathAction;
import com.github.tatercertified.lifesteal.gamerules.LifeStealGamerules;
import com.github.tatercertified.lifesteal.gametest.GameTestUserCache;
import com.github.tatercertified.lifesteal.gametest.TestSubject;
import com.github.tatercertified.lifesteal.items.HeartItem;
import com.github.tatercertified.lifesteal.items.ModItems;
import com.github.tatercertified.lifesteal.utils.LifestealMixinConfig;
import java.util.UUID;
import mc.recraftors.unruled_api.rules.RegistryEntryRule;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.gamerule.v1.rule.EnumRule;
import net.fabricmc.fabric.api.gametest.v1.GameTest;
import net.minecraft.class_11561;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4516;
import net.minecraft.class_5544;
import net.minecraft.class_9334;

public class LifestealGameTest {
    public static final class_11561 gameTestUserCache = new GameTestUserCache();

    @GameTest
    public void testHeartConsumption(class_4516 context) {
        LifestealMixinConfig.TEST_LOGGER.info("Test 1: Heart Consumption");
        TestSubject player = this.spawnSinglePlayerTest(context);
        class_1799 heart = new class_1799((class_1935)ModItems.HEART, 1);
        ((class_1928.class_4312)context.method_35943().method_64395().method_20746(LifeStealGamerules.HEARTBONUS)).method_35236(2, context.method_35943().method_8503());
        context.method_36003(1L, () -> player.method_6122(class_1268.field_5808, heart.method_7972()));
        context.method_36003(2L, () -> this.use(player, heart.method_7972()));
        context.method_36003(3L, () -> {
            double maxHealth = player.getMaxBaseHealth();
            context.method_46226(maxHealth == 22.0, class_2561.method_30163((String)("Max Health Mismatch; Expected: 22.0, Got: " + maxHealth)));
        });
        context.method_36003(4L, () -> player.method_6122(class_1268.field_5808, heart.method_7972()));
        context.method_36003(5L, () -> ((class_1928.class_4312)context.method_35943().method_64395().method_20746(LifeStealGamerules.HEARTBONUS)).method_35236(4, context.method_35943().method_8503()));
        context.method_36003(6L, () -> this.use(player, heart.method_7972()));
        context.method_36003(7L, () -> {
            double maxHealth = player.getMaxBaseHealth();
            context.method_46226(maxHealth == 26.0, class_2561.method_30163((String)("Max Health Mismatch; Expected: 26.0, Got: " + maxHealth)));
        });
        context.method_36003(8L, () -> {
            ((class_1928.class_4312)context.method_35943().method_64395().method_20746(LifeStealGamerules.HEARTBONUS)).method_35236(2, context.method_35943().method_8503());
            this.end(context, player);
        });
    }

    @GameTest(setupTicks=10)
    public void testAltar(class_4516 context) {
        LifestealMixinConfig.TEST_LOGGER.info("Test 2: Altar");
        TestSubject player = this.spawnSinglePlayerTest(context);
        class_2338 altar_relative = new class_2338(2, 151, 2);
        class_2338 altar = this.spawnAltar(context, altar_relative);
        ((RegistryEntryRule)context.method_35943().method_64395().method_20746(LifeStealGamerules.ALTAR_BLOCK)).set((Object)class_2246.field_22108, context.method_35943().method_8503());
        context.method_46226(HeartItem.isAltar((class_1937)context.method_35943(), altar), class_2561.method_30163((String)"Altar failed to be created"));
        context.method_36003(1L, () -> {
            player.method_5660(true);
            player.method_5702(class_2183.class_2184.field_9853, altar.method_46558());
        });
        context.method_36003(2L, () -> ((UseBlockCallback)UseBlockCallback.EVENT.invoker()).interact((class_1657)player, (class_1937)player.method_51469(), class_1268.field_5808, new class_3965(class_243.method_24953((class_2382)altar), class_2350.field_11043, altar, true)));
        context.method_36003(3L, () -> {
            double maxHealth = player.getMaxBaseHealth();
            context.method_46226(maxHealth == 18.0, class_2561.method_30163((String)("Max Health Mismatch; Expected: 18.0, Got: " + maxHealth)));
        });
        context.method_36003(4L, () -> {
            ((RegistryEntryRule)context.method_35943().method_64395().method_20746(LifeStealGamerules.ALTAR_BLOCK)).set((Object)class_2246.field_10201, context.method_35943().method_8503());
            context.method_35943().method_8501(altar, class_2246.field_10201.method_9564());
        });
        context.method_36003(5L, () -> context.method_46226(HeartItem.isAltar((class_1937)context.method_35943(), altar), class_2561.method_30163((String)"Altar block failed to be set")));
        context.method_36003(6L, () -> {
            ((RegistryEntryRule)context.method_35943().method_64395().method_20746(LifeStealGamerules.ALTAR_BLOCK)).set((Object)class_2246.field_22108, context.method_35943().method_8503());
            this.end(context, player);
        });
    }

    @GameTest(setupTicks=20, maxTicks=15)
    public void testHeartSteal(class_4516 context) {
        LifestealMixinConfig.TEST_LOGGER.info("Test 3: Heart Stealing");
        TestSubject[] players = this.spawnDoublePlayerTest(context);
        ((class_1928.class_4310)context.method_35943().method_64395().method_20746(LifeStealGamerules.PLAYERRELATEDONLY)).method_20758(false, context.method_35943().method_8503());
        ((class_1928.class_4310)context.method_35943().method_64395().method_20746(class_1928.field_20638)).method_20758(true, context.method_35943().method_8503());
        context.method_36003(1L, () -> players[0].kill());
        context.method_36003(2L, () -> {
            double maxHealth = players[0].getMaxBaseHealth();
            context.method_46226(maxHealth == 18.0, class_2561.method_30163((String)("Max Health Mismatch; Expected: 18.0, Got: " + maxHealth)));
        });
        context.method_36003(3L, () -> players[0].respawn());
        context.method_36003(4L, () -> ((class_1928.class_4310)context.method_35943().method_64395().method_20746(LifeStealGamerules.PLAYERRELATEDONLY)).method_20758(true, context.method_35943().method_8503()));
        context.method_36003(5L, () -> players[0].kill(players[1]));
        context.method_36003(6L, () -> {
            double killedMaxHealth = players[0].getMaxBaseHealth();
            context.method_46226(killedMaxHealth == 16.0, class_2561.method_30163((String)("Max Health Mismatch; Expected: 16.0, Got: " + killedMaxHealth)));
            double attackerMaxHealth = players[1].getMaxBaseHealth();
            context.method_46226(attackerMaxHealth == 22.0, class_2561.method_30163((String)("Max Health Mismatch; Expected: 22.0, Got: " + attackerMaxHealth)));
        });
        context.method_36003(7L, () -> {
            players[0].respawn();
            ((class_1928.class_4312)context.method_35943().method_64395().method_20746(LifeStealGamerules.STEALAMOUNT)).method_35236(4, context.method_35943().method_8503());
        });
        context.method_36003(8L, () -> players[0].kill(players[1]));
        context.method_36003(9L, () -> {
            double killedMaxHealth = players[0].getMaxBaseHealth();
            context.method_46226(killedMaxHealth == 12.0, class_2561.method_30163((String)("Max Health Mismatch; Expected: 12.0, Got: " + killedMaxHealth)));
            double attackerMaxHealth = players[1].getMaxBaseHealth();
            context.method_46226(attackerMaxHealth == 26.0, class_2561.method_30163((String)("Max Health Mismatch; Expected: 26.0, Got: " + attackerMaxHealth)));
        });
        context.method_36003(10L, () -> {
            ((class_1928.class_4312)context.method_35943().method_64395().method_20746(LifeStealGamerules.STEALAMOUNT)).method_35236(2, context.method_35943().method_8503());
            this.end(context, players);
        });
    }

    @GameTest(setupTicks=35)
    public void testDeath(class_4516 context) {
        LifestealMixinConfig.TEST_LOGGER.info("Test 4: Death Consequences");
        TestSubject[] player = new TestSubject[]{this.spawnSinglePlayerTest(context)};
        class_243 playerPos = player[0].method_73189();
        player[0].setLowMaxHealth(context);
        ((class_1928.class_4310)context.method_35943().method_64395().method_20746(LifeStealGamerules.PLAYERRELATEDONLY)).method_20758(false, context.method_35943().method_8503());
        context.method_36003(1L, player[0]::kill);
        context.method_36003(2L, () -> context.method_46226(DeathData.isPlayerDead(player[0].method_5667(), 0), class_2561.method_30163((String)"Player should be banned")));
        context.method_36003(3L, () -> {
            player[0] = this.spawnPlayer(context, playerPos);
            player[0].setLowMaxHealth(context);
            ((EnumRule)context.method_35943().method_64395().method_20746(LifeStealGamerules.DEATH_ACTION)).set((Enum)DeathAction.SPECTATOR, context.method_35943().method_8503());
        });
        context.method_36003(4L, player[0]::kill);
        context.method_36003(5L, () -> {});
        context.method_36003(6L, () -> {
            player[0] = this.spawnPlayer(context, playerPos);
            player[0].setLowMaxHealth(context);
            ((EnumRule)context.method_35943().method_64395().method_20746(LifeStealGamerules.DEATH_ACTION)).set((Enum)DeathAction.REVIVE, context.method_35943().method_8503());
        });
        context.method_36003(7L, player[0]::kill);
        context.method_36003(8L, () -> {
            context.method_46226(player[0].method_5805(), class_2561.method_30163((String)"Player should be alive"));
            context.method_49994(DeathData.isPlayerDead(player[0].method_5667(), 0), class_2561.method_30163((String)"Player should not be banned"));
        });
        context.method_36003(9L, () -> {
            ((class_1928.class_4310)context.method_35943().method_64395().method_20746(LifeStealGamerules.PLAYERRELATEDONLY)).method_20758(true, context.method_35943().method_8503());
            ((EnumRule)context.method_35943().method_64395().method_20746(LifeStealGamerules.DEATH_ACTION)).set((Enum)DeathAction.BAN, context.method_35943().method_8503());
            this.end(context, player);
        });
    }

    @GameTest(setupTicks=45)
    public void testRevive(class_4516 context) {
        LifestealMixinConfig.TEST_LOGGER.info("Test 5: Revival");
        TestSubject[] players = this.spawnDoublePlayerTest(context);
        players[0].setLowMaxHealth(context);
        class_2561 name = players[0].method_5477();
        UUID uuid = players[0].method_5667();
        class_1799 heart = new class_1799((class_1935)ModItems.HEART);
        heart.method_57379(class_9334.field_49631, (Object)name);
        class_2338 altar_relative = new class_2338(2, 151, 2);
        class_2338 altar = this.spawnAltar(context, altar_relative);
        context.method_36003(1L, players[0]::kill);
        context.method_36003(2L, () -> {
            players[1].method_6122(class_1268.field_5808, heart.method_7972());
            players[1].method_5660(true);
            players[1].method_5702(class_2183.class_2184.field_9853, altar.method_46558());
        });
        context.method_36003(3L, () -> heart.method_7981(new class_1838((class_1657)players[1], class_1268.field_5808, new class_3965(class_243.method_24953((class_2382)altar), class_2350.field_11043, altar, true))));
        context.method_36003(5L, () -> context.method_49994(DeathData.isPlayerDead(uuid, 0), class_2561.method_30163((String)"Player was not revived")));
        context.method_36003(6L, () -> this.end(context, players));
    }

    @GameTest(setupTicks=55)
    public void testHeartStacks(class_4516 context) {
        LifestealMixinConfig.TEST_LOGGER.info("Test 6: Heart Stacking");
        TestSubject player = this.spawnSinglePlayerTest(context);
        class_1799 heart = new class_1799((class_1935)ModItems.HEART);
        context.method_36003(1L, () -> player.method_7270(heart.method_7972()));
        context.method_36003(2L, () -> player.method_7270(heart.method_7972()));
        context.method_36003(3L, () -> {
            context.method_46226(player.method_6047().method_7947() == 1, class_2561.method_30163((String)"Hearts stacked when unstackable"));
            ((class_1928.class_4312)context.method_35943().method_64395().method_20746(LifeStealGamerules.HEART_STACK_SIZE)).method_35236(2, context.method_35943().method_8503());
        });
        context.method_36003(4L, () -> player.method_7270(heart.method_7972()));
        context.method_36003(5L, () -> context.method_46226(player.method_6047().method_7947() == 2, class_2561.method_30163((String)"Hearts did not stack")));
        context.method_36003(6L, () -> {
            ((class_1928.class_4312)context.method_35943().method_64395().method_20746(LifeStealGamerules.HEART_STACK_SIZE)).method_35236(1, context.method_35943().method_8503());
            this.end(context, player);
        });
    }

    @GameTest(setupTicks=65)
    public void testWithdrawCommand(class_4516 context) {
        LifestealMixinConfig.TEST_LOGGER.info("Test 7: Heart Withdraw Command");
        TestSubject player = this.spawnSinglePlayerTest(context);
        context.method_36003(1L, () -> {
            ((class_1928.class_4312)context.method_35943().method_64395().method_20746(LifeStealGamerules.HEART_STACK_SIZE)).method_35236(2, context.method_35943().method_8503());
            ((class_1928.class_4310)context.method_35943().method_64395().method_20746(LifeStealGamerules.ALTARS)).method_20758(false, context.method_35943().method_8503());
        });
        context.method_36003(2L, () -> player.executeCommand("withdraw 2"));
        context.method_36003(3L, () -> {
            context.method_46226(player.method_6047().method_7947() == 2, class_2561.method_30163((String)("Expected 2 Hearts; Given " + player.method_6047().method_7947())));
            context.method_46226(player.getMaxBaseHealth() == 16.0, class_2561.method_30163((String)("Expected 16.0 Max Health; Has " + player.getMaxBaseHealth())));
        });
        context.method_36003(4L, () -> {
            player.method_31548().method_5448();
            context.method_35943().method_8503().method_3734().method_44252(player.method_64396(), "withdraw 16");
        });
        context.method_36003(5L, () -> {
            context.method_46226(player.method_6047().method_7960(), class_2561.method_30163((String)("Expected 0 Hearts; Given " + player.method_6047().method_7947())));
            context.method_46226(player.getMaxBaseHealth() == 16.0, class_2561.method_30163((String)("Expected 16.0 Max Health; Has " + player.getMaxBaseHealth())));
        });
        context.method_36003(6L, () -> {
            ((class_1928.class_4310)context.method_35943().method_64395().method_20746(LifeStealGamerules.ALTARS)).method_20758(true, context.method_35943().method_8503());
            ((class_1928.class_4312)context.method_35943().method_64395().method_20746(LifeStealGamerules.HEART_STACK_SIZE)).method_35236(1, context.method_35943().method_8503());
            this.end(context, player);
        });
    }

    @GameTest(setupTicks=75)
    public void testGiftCommand(class_4516 context) {
        LifestealMixinConfig.TEST_LOGGER.info("Test 8: Heart Gift Command");
        TestSubject[] players = this.spawnDoublePlayerTest(context);
        context.method_36003(1L, () -> {
            players[0].setMaxHealth(10.0);
            players[1].setMaxHealth(20.0);
            ((class_1928.class_4310)context.method_35943().method_64395().method_20746(LifeStealGamerules.GIFTHEARTS)).method_20758(true, context.method_35943().method_8503());
            ((class_1928.class_4310)context.method_35943().method_64395().method_20746(LifeStealGamerules.ALTARS)).method_20758(false, context.method_35943().method_8503());
        });
        context.method_36003(2L, () -> players[1].executeCommand("gift " + players[0].method_5845() + " 2"));
        context.method_36003(3L, () -> {
            context.method_46226(players[0].getMaxBaseHealth() == 12.0, class_2561.method_30163((String)("Expected 12.0 Max Health; Has " + players[0].getMaxBaseHealth())));
            context.method_46226(players[1].getMaxBaseHealth() == 18.0, class_2561.method_30163((String)("Expected 18.0 Max Health; Has " + players[1].getMaxBaseHealth())));
        });
        context.method_36003(5L, () -> this.end(context, players));
    }

    private TestSubject spawnSinglePlayerTest(class_4516 context) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                context.method_35984(new class_2338(i, 150, j), class_2246.field_9987);
            }
        }
        class_243 playerPos = context.method_35978(new class_243(2.5, 151.5, 2.5));
        return this.spawnPlayer(context, playerPos);
    }

    private TestSubject[] spawnDoublePlayerTest(class_4516 context) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                context.method_35984(new class_2338(i, 150, j), class_2246.field_9987);
            }
        }
        TestSubject[] players = new TestSubject[2];
        for (int i = 0; i < 2; ++i) {
            class_243 playerPos = context.method_35978(new class_243(2.5 + (double)i, 151.5, 2.5));
            players[i] = this.spawnPlayer(context, playerPos);
        }
        return players;
    }

    private TestSubject spawnPlayer(class_4516 context, class_243 pos) {
        TestSubject player = TestSubject.getRandomTestSubject(context.method_35943());
        player.method_51469().method_8649((class_1297)player);
        player.method_7336(class_1934.field_9215);
        player.method_23327(pos.method_10216(), pos.method_10214(), pos.method_10215());
        return player;
    }

    private void use(TestSubject player, class_1799 stack) {
        stack.method_7913((class_1937)player.method_51469(), (class_1657)player, class_1268.field_5808);
    }

    private void removePlayers(TestSubject ... players) {
        for (TestSubject player : players) {
            player.remove();
        }
    }

    private class_2338 spawnAltar(class_4516 context, class_2338 center) {
        context.method_35984(center, class_2246.field_22108);
        class_2680 candle = (class_2680)class_2246.field_27099.method_9564().method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(true));
        context.method_35986(center.method_10095(), candle);
        context.method_35986(center.method_10078(), candle);
        context.method_35986(center.method_10072(), candle);
        context.method_35986(center.method_10067(), candle);
        return context.method_36052(center);
    }

    private void end(class_4516 context, TestSubject ... players) {
        this.removePlayers(players);
        context.method_36036();
        LifestealMixinConfig.TEST_LOGGER.info("Test Passed");
    }
}

