/*
 * Decompiled with CFR 0.152.
 */
package com.github.tatercertified.lifesteal.gametest;

import com.github.tatercertified.lifesteal.gamerules.LifeStealGamerules;
import com.github.tatercertified.lifesteal.mixin.FakePlayerAccessor;
import com.github.tatercertified.lifesteal.utils.LifestealMixinConfig;
import com.github.tatercertified.lifesteal.utils.PlayerMaxHealthInterface;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_3218;
import net.minecraft.class_4516;
import net.minecraft.class_5134;

public class TestSubject
extends FakePlayer {
    protected TestSubject(class_3218 world, GameProfile profile) {
        super(world, profile);
    }

    public static TestSubject getRandomTestSubject(class_3218 world) {
        String name;
        do {
            name = "TEST" + ThreadLocalRandom.current().nextInt(0, 10000);
        } while (Arrays.asList(world.method_8503().method_3760().method_14580()).contains(name));
        return TestSubject.getNew(world, new GameProfile(UUID.randomUUID(), name));
    }

    public static TestSubject getNew(class_3218 world, GameProfile profile) {
        Object playerKey;
        Objects.requireNonNull(world, "World may not be null.");
        Objects.requireNonNull(profile, "Game profile may not be null.");
        try {
            playerKey = TestSubject.createFakePlayerKey(world, profile);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        class_3218 playerWorld = null;
        GameProfile playerProfile = null;
        try {
            Field worldField = playerKey.getClass().getDeclaredField("world");
            Field profileField = playerKey.getClass().getDeclaredField("profile");
            worldField.setAccessible(true);
            profileField.setAccessible(true);
            playerWorld = (class_3218)worldField.get(playerKey);
            playerProfile = (GameProfile)profileField.get(playerKey);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LifestealMixinConfig.TEST_LOGGER.error("Failed to create TestSubject instance", (Throwable)e);
        }
        class_3218 finalPlayerWorld = playerWorld;
        GameProfile finalPlayerProfile = playerProfile;
        return (TestSubject)FakePlayerAccessor.getPlayerMap().computeIfAbsent(playerKey, key -> new TestSubject(finalPlayerWorld, finalPlayerProfile));
    }

    private static Object createFakePlayerKey(class_3218 world, GameProfile profile) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName("net.fabricmc.fabric.api.entity.FakePlayer$FakePlayerKey");
        Constructor<?> constructor = clazz.getDeclaredConstructor(class_3218.class, GameProfile.class);
        constructor.setAccessible(true);
        return constructor.newInstance(world, profile);
    }

    public boolean method_5679(class_3218 world, class_1282 damageSource) {
        return false;
    }

    public void kill() {
        this.method_6033(0.0f);
        this.method_6078(this.method_48923().method_51847());
    }

    public void kill(TestSubject attacker) {
        this.method_6033(0.0f);
        this.method_6015((class_1309)attacker);
        this.method_6078(this.method_48923().method_48802((class_1657)attacker));
    }

    public void respawn() {
        this.method_6033((float)this.method_5996(class_5134.field_23716).method_6201());
    }

    public void remove() {
        this.method_31548().method_5448();
        this.method_6012();
        this.method_5996(class_5134.field_23716).method_6192(20.0);
        this.method_6033(20.0f);
        this.method_5650(class_1297.class_5529.field_26999);
    }

    public double getMaxBaseHealth() {
        return this.method_5996(class_5134.field_23716).method_6201();
    }

    public void setLowMaxHealth(class_4516 context) {
        this.setMaxHealth(((class_1928.class_4312)context.method_35943().method_64395().method_20746(LifeStealGamerules.MINPLAYERHEALTH)).method_20763());
    }

    public void setMaxHealth(double value) {
        ((PlayerMaxHealthInterface)((Object)this)).setBaseMaxHealth(value);
    }

    public void executeCommand(String command) {
        this.method_51469().method_8503().method_3734().method_44252(this.method_64396(), command);
    }
}

