/*
 * Decompiled with CFR 0.152.
 */
package com.github.tatercertified.lifesteal.items;

import com.github.tatercertified.lifesteal.data.DeathData;
import com.github.tatercertified.lifesteal.gamerules.LifeStealGamerules;
import com.github.tatercertified.lifesteal.utils.LifeStealText;
import com.github.tatercertified.lifesteal.utils.OfflinePlayerData;
import com.github.tatercertified.lifesteal.utils.PlayerReviveData;
import com.github.tatercertified.lifesteal.utils.PlayerUtils;
import de.olivermakesco.polyspring.api.BedrockItem;
import eu.pb4.polymer.core.api.item.PolymerItem;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11560;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_5454;
import net.minecraft.class_5544;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class HeartItem
extends class_1792
implements PolymerItem,
BedrockItem {
    public HeartItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (world.method_8608() || user.method_5715()) {
            return super.method_7836(world, user, hand);
        }
        class_1799 stack = user.method_5998(hand);
        class_3222 serverPlayer = (class_3222)user;
        int amount = ((class_3218)world).method_64395().method_8356(LifeStealGamerules.HEARTBONUS);
        if (!PlayerUtils.changeHealth(serverPlayer, amount)) {
            return class_1269.field_5814;
        }
        stack.method_7934(1);
        return class_1269.field_5812;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 class_19372 = context.method_8045();
        if (!(class_19372 instanceof class_3218)) {
            return super.method_7884(context);
        }
        class_3218 world = (class_3218)class_19372;
        MinecraftServer server = world.method_8503();
        if (!server.method_3767().method_8355(LifeStealGamerules.ALTARS)) {
            return super.method_7884(context);
        }
        class_3222 player = (class_3222)context.method_8036();
        if (player == null) {
            return super.method_7884(context);
        }
        String playerName = HeartItem.getCustomName(context.method_8041());
        if (playerName == null) {
            return super.method_7884(context);
        }
        class_2338 pos = context.method_8037();
        if (player.method_5715() && HeartItem.isAltar(context.method_8045(), pos)) {
            if (playerName.equalsIgnoreCase(player.method_5476().getString())) {
                player.method_7353(LifeStealText.noSelfReviving(player.method_5477()), true);
                HeartItem.failedSound((class_1937)world, pos);
                return class_1269.field_5814;
            }
            byte val = HeartItem.revive(playerName, server, world, pos, player, Optional.of(context));
            switch (val) {
                case 0: {
                    return class_1269.field_5812;
                }
                case 1: {
                    return class_1269.field_5814;
                }
            }
            player.method_7353(LifeStealText.notFound(playerName), true);
            HeartItem.failedSound((class_1937)world, pos);
            return class_1269.field_5814;
        }
        return super.method_7884(context);
    }

    public static byte revive(String playerName, MinecraftServer server, class_3218 world, class_2338 pos, class_3222 reviver, Optional<class_1838> contextOptional) {
        return HeartItem.revive(server.method_3760().method_14566(playerName), null, playerName, server, world, pos, reviver, contextOptional);
    }

    public static byte revive(UUID reviveeId, MinecraftServer server, class_3218 world, class_2338 pos, class_3222 reviver, Optional<class_1838> contextOptional) {
        return HeartItem.revive(server.method_3760().method_14602(reviveeId), reviveeId, null, server, world, pos, reviver, contextOptional);
    }

    private static byte revive(class_3222 revivee, @Nullable UUID reviveeId, @Nullable String reviveeName, MinecraftServer server, class_3218 world, class_2338 pos, class_3222 reviver, Optional<class_1838> contextOptional) {
        boolean fromHeart = contextOptional.isPresent();
        if (revivee != null) {
            if (HeartItem.reviveOnline(revivee, world, pos, (class_1657)reviver, fromHeart)) {
                contextOptional.ifPresent(itemUsageContext -> HeartItem.revived(reviver, itemUsageContext, revivee.method_5476()));
                return 0;
            }
            HeartItem.failed(reviver, pos, revivee.method_5476());
            return 1;
        }
        Optional profile = reviveeId != null ? server.method_73550().comp_4407().method_14512(reviveeId) : (reviveeName != null ? server.method_73550().comp_4407().method_14515(reviveeName) : Optional.empty());
        if (profile.isPresent()) {
            if (HeartItem.reviveOffline((class_11560)profile.get(), world, pos, (class_1657)reviver, fromHeart)) {
                contextOptional.ifPresent(itemUsageContext -> HeartItem.revived(reviver, itemUsageContext, class_2561.method_30163((String)((class_11560)profile.get()).comp_4423())));
                return 0;
            }
            HeartItem.failed(reviver, pos, class_2561.method_30163((String)((class_11560)profile.get()).comp_4423()));
            return 1;
        }
        return 2;
    }

    private static boolean reviveOnline(class_3222 player, class_3218 world, class_2338 alter, class_1657 reviver, boolean fromHeart) {
        if (!DeathData.isPlayerDead(player.method_5667(), world.method_64395().method_8356(LifeStealGamerules.AUTOREVIVAL))) {
            return false;
        }
        HeartItem.teleport((class_1657)player, world, alter);
        player.method_7336(class_1934.field_9215);
        player.method_64398(LifeStealText.onRevivalText(reviver.method_5476()));
        PlayerUtils.setMaxHealth(world.method_64395().method_8356(LifeStealGamerules.MINPLAYERHEALTH), player);
        DeathData.removeFromDeathDataList(player.method_5667());
        ((PlayerReviveData)player).setNewlyRevived(!fromHeart);
        return true;
    }

    private static boolean reviveOffline(class_11560 profile, class_3218 world, class_2338 alter, class_1657 reviver, boolean fromHeart) {
        if (!DeathData.isPlayerDead(profile.comp_4422(), world.method_64395().method_8356(LifeStealGamerules.AUTOREVIVAL))) {
            return false;
        }
        MinecraftServer server = world.method_8503();
        OfflinePlayerData playerData = OfflinePlayerData.getOfflinePlayerData(server, profile);
        playerData.setPosition(world, alter.method_10084().method_46558());
        playerData.setGamemode(class_1934.field_9215);
        playerData.setMaxHealth(world.method_64395().method_8356(LifeStealGamerules.MINPLAYERHEALTH));
        playerData.setNewlyRevived(!fromHeart);
        playerData.save();
        DeathData.setReviver(profile.comp_4422(), reviver.method_5667());
        return true;
    }

    private static void revived(class_3222 reviver, class_1838 context, class_2561 revived) {
        HeartItem.successSound(context.method_8045(), context.method_8037());
        context.method_8041().method_7934(1);
        reviver.method_7353(LifeStealText.revived(revived), true);
    }

    private static void successSound(class_1937 world, class_2338 alter) {
        world.method_8396(null, alter, class_3417.field_14703, class_3419.field_15248, 16.0f, 1.0f);
    }

    private static void failed(class_3222 reviver, class_2338 alter, class_2561 revived) {
        HeartItem.failedSound((class_1937)reviver.method_51469(), alter);
        reviver.method_7353(LifeStealText.playerIsAlive(revived), true);
    }

    private static void failedSound(class_1937 world, class_2338 alter) {
        world.method_8396(null, alter, class_3417.field_19344, class_3419.field_15248, 16.0f, 1.0f);
    }

    private static void teleport(class_1657 player, class_3218 target, class_2338 alterPos) {
        class_243 pos = alterPos.method_10084().method_46558();
        player.method_5731(new class_5454(target, pos, class_243.field_1353, player.method_36454(), player.method_36455(), class_5454.field_52245));
    }

    @Nullable
    private static String getCustomName(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            throw new AssertionError((Object)"stack is empty");
        }
        if (HeartItem.hasCustomName(stack)) {
            return stack.method_7964().getString();
        }
        return null;
    }

    private static boolean hasCustomName(class_1799 stack) {
        return stack.method_58694(class_9334.field_49631) != null;
    }

    public static boolean isAltar(class_1937 world, class_2338 pos) {
        if (!world.method_8320(pos).method_27852(LifeStealGamerules.getBlockFromGameRule(world.method_8503().method_3767()))) {
            return false;
        }
        class_2680 north = world.method_8320(pos.method_10095());
        class_2680 east = world.method_8320(pos.method_10078());
        class_2680 south = world.method_8320(pos.method_10072());
        class_2680 west = world.method_8320(pos.method_10067());
        return north.method_26164(class_3481.field_26983) && (Boolean)north.method_11654((class_2769)class_5544.field_27175) != false && east.method_26164(class_3481.field_26983) && (Boolean)east.method_11654((class_2769)class_5544.field_27175) != false && south.method_26164(class_3481.field_26983) && (Boolean)south.method_11654((class_2769)class_5544.field_27175) != false && west.method_26164(class_3481.field_26983) && (Boolean)west.method_11654((class_2769)class_5544.field_27175) != false;
    }

    public int method_7882() {
        return LifeStealGamerules.serverInstance != null ? LifeStealGamerules.serverInstance.method_3767().method_8356(LifeStealGamerules.HEART_STACK_SIZE) : 1;
    }

    public class_1792 getPolymerItem(class_1799 itemStack, PacketContext context) {
        return class_1802.field_8137;
    }

    public String bedrockName() {
        return class_2561.method_43471((String)this.method_7876()).method_54160();
    }

    public boolean bedrockEdible() {
        return true;
    }

    public boolean bedrockFoil() {
        return true;
    }
}

