/*
 * Decompiled with CFR 0.152.
 */
package com.github.tatercertified.lifesteal.mixin;

import com.github.tatercertified.lifesteal.data.DeathData;
import com.github.tatercertified.lifesteal.effect.InvulnerableStatusEffect;
import com.github.tatercertified.lifesteal.gamerules.LifeStealGamerules;
import com.github.tatercertified.lifesteal.utils.LifeStealText;
import com.github.tatercertified.lifesteal.utils.PlayerInvulnerabilityInterface;
import com.github.tatercertified.lifesteal.utils.PlayerMaxHealthInterface;
import com.github.tatercertified.lifesteal.utils.PlayerReviveData;
import com.github.tatercertified.lifesteal.utils.PlayerUtils;
import com.mojang.authlib.GameProfile;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657
implements PlayerReviveData,
PlayerInvulnerabilityInterface,
PlayerMaxHealthInterface {
    private boolean newlyRevived;
    private int invulnerableTicks = 0;
    @Shadow
    @Final
    private MinecraftServer field_13995;

    public ServerPlayerEntityMixin(class_1937 world, GameProfile profile) {
        super(world, profile);
    }

    @Shadow
    public abstract class_3218 method_51469();

    @Inject(method={"onDeath"}, at={@At(value="TAIL")})
    private void lifesteal$onDeath(class_1282 damageSource, CallbackInfo ci) {
        class_1297 attacker = damageSource.method_5529();
        if (attacker instanceof class_3222) {
            class_3222 playerAttacker = (class_3222)attacker;
            PlayerUtils.exchangeHealth((class_3222)this, playerAttacker);
        } else if (!this.method_51469().method_64395().method_8355(LifeStealGamerules.PLAYERRELATEDONLY)) {
            class_1324 killedMaxHealth = this.method_5996(class_5134.field_23716);
            PlayerUtils.changeHealthUnchecked((class_3222)this, -this.method_51469().method_64395().method_8356(LifeStealGamerules.STEALAMOUNT));
            int minHealth = this.field_13995.method_3767().method_8356(LifeStealGamerules.MINPLAYERHEALTH);
            if (killedMaxHealth.method_6201() <= (double)minHealth) {
                DeathData data = new DeathData(this.method_5667());
                data.addToDeathDataList();
                PlayerUtils.handleDeadPlayerAction((class_3222)this, data);
            }
        }
    }

    @Inject(method={"copyFrom"}, at={@At(value="TAIL")})
    private void lifesteal$copyNewlyRevived(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        this.setNewlyRevived(((PlayerReviveData)oldPlayer).newlyRevived());
        this.invulnerableTicks = ((PlayerInvulnerabilityInterface)oldPlayer).getRemaining();
    }

    @Inject(method={"readCustomData"}, at={@At(value="TAIL")})
    private void lifesteal$readRevivedData(class_11368 view, CallbackInfo ci) {
        this.setNewlyRevived(view.method_71433("newly_revived", false));
        this.invulnerableTicks = view.method_71424("invulnerability_ticks", 0);
    }

    @Inject(method={"writeCustomData"}, at={@At(value="TAIL")})
    private void lifesteal$writeRevivedData(class_11372 view, CallbackInfo ci) {
        view.method_71472("newly_revived", this.newlyRevived);
        view.method_71465("invulnerability_ticks", this.invulnerableTicks);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void lifesteal$tickInvulnerability(CallbackInfo ci) {
        if (this.isReviveInvulnerable()) {
            --this.invulnerableTicks;
        }
    }

    @Inject(method={"shouldDamagePlayer"}, at={@At(value="HEAD")}, cancellable=true)
    private void lifesteal$checkInvulnerability(class_1657 player, CallbackInfoReturnable<Boolean> cir) {
        if (this.isReviveInvulnerable()) {
            player.method_7353(LifeStealText.preventDamage(this.method_5477()), true);
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;attack(Lnet/minecraft/entity/Entity;)V")}, cancellable=true)
    private void lifesteal$preventAttackingPlayers(class_1297 target, CallbackInfo ci) {
        if (this.isReviveInvulnerable() && target instanceof class_3222) {
            this.method_7353(LifeStealText.PREVENT_ATTACK, true);
            ci.cancel();
        }
    }

    @Override
    public boolean newlyRevived() {
        return this.newlyRevived;
    }

    @Override
    public void setNewlyRevived(boolean set) {
        this.newlyRevived = set;
    }

    @Override
    public void setReviveInvulnerability() {
        this.invulnerableTicks = this.field_13995.method_3767().method_8356(LifeStealGamerules.RESPAWN_INVULNERABILITY) * 20;
        this.method_6092(new class_1293(InvulnerableStatusEffect.INVULNERABLE, this.getRemaining(), 0, false, false, true));
    }

    @Override
    public boolean isReviveInvulnerable() {
        return this.invulnerableTicks != 0;
    }

    @Override
    public int getRemaining() {
        return this.invulnerableTicks;
    }

    @Override
    public double getBaseMaxHealth() {
        return this.method_45326(class_5134.field_23716);
    }

    @Override
    public void setBaseMaxHealth(double value) {
        this.method_5996(class_5134.field_23716).method_6192(value);
    }
}

