/*
 * Decompiled with CFR 0.152.
 */
package com.github.tatercertified.lifesteal.utils;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.class_11560;
import net.minecraft.class_156;
import net.minecraft.class_1934;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class OfflinePlayerData {
    public final class_11560 holder;
    public final class_2487 root;
    private final Path dir;
    private static final Logger logger = LogUtils.getLogger();

    protected OfflinePlayerData(class_11560 holder, class_2487 root, Path dir) {
        this.holder = holder;
        this.root = root;
        this.dir = dir;
    }

    public void save() {
        String reference = String.valueOf(this.holder.comp_4422()) + ".dat";
        Path tmp = this.dir.resolve(reference + "_tmp");
        Path cur = this.dir.resolve(reference);
        Path old = this.dir.resolve(reference + "_old");
        try (OutputStream stream = Files.newOutputStream(tmp, new OpenOption[0]);){
            class_2507.method_10634((class_2487)this.root, (OutputStream)stream);
            class_156.method_30626((Path)cur, (Path)tmp, (Path)old);
        }
        catch (IOException ioe) {
            logger.warn("Cannot save data for {}", (Object)this.holder, (Object)ioe);
        }
    }

    public static OfflinePlayerData getOfflinePlayerData(MinecraftServer server, class_11560 profile) {
        Path dir = server.method_27050(class_5218.field_24182);
        Path dat = dir.resolve(String.valueOf(profile.comp_4422()) + ".dat");
        if (Files.exists(dat, new LinkOption[0]) && Files.isRegularFile(dat, new LinkOption[0])) {
            OfflinePlayerData offlinePlayerData;
            block9: {
                InputStream stream = Files.newInputStream(dat, new OpenOption[0]);
                try {
                    class_2487 compound = class_2507.method_10629((InputStream)stream, (class_2505)class_2505.method_53898());
                    offlinePlayerData = new OfflinePlayerData(profile, compound, dir);
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        logger.warn("Unable to read NBT for {}", (Object)profile, (Object)ioe);
                    }
                }
                stream.close();
            }
            return offlinePlayerData;
        }
        return null;
    }

    public void setPosition(class_3218 world, class_243 pos) {
        class_2499 nbtPos = this.root.method_68569("Pos");
        nbtPos.method_68585(0, (class_2520)class_2489.method_23241((double)pos.method_10216()));
        nbtPos.method_68585(1, (class_2520)class_2489.method_23241((double)pos.method_10214()));
        nbtPos.method_68585(2, (class_2520)class_2489.method_23241((double)pos.method_10215()));
        this.root.method_10582("Dimension", world.method_27983().method_29177().toString());
    }

    public void setNewlyRevived(boolean set) {
        this.root.method_10556("newly_revived", set);
    }

    public void setMaxHealth(double health) {
        class_2499 nbtAttributes = this.root.method_68569("Attributes");
        for (int i = 0; i < nbtAttributes.size(); ++i) {
            class_2487 compound = nbtAttributes.method_68582(i);
            if (!Objects.equals(compound.method_10558("Name"), "minecraft:generic.max_health")) continue;
            compound.method_10549("Base", health);
            return;
        }
        class_2487 compound = new class_2487();
        compound.method_10549("Base", health);
        compound.method_10582("Name", "minecraft:generic.max_health");
        nbtAttributes.add((Object)compound);
    }

    public double getMaxHealth() {
        class_2499 nbtAttributes = this.root.method_68569("Attributes");
        for (int i = 0; i < nbtAttributes.size(); ++i) {
            class_2487 compound = nbtAttributes.method_68582(i);
            if (!Objects.equals(compound.method_10558("Name"), "minecraft:generic.max_health")) continue;
            return compound.method_10574("Base").orElse(20.0);
        }
        return 20.0;
    }

    public void setGamemode(class_1934 gamemode) {
        this.root.method_10569("playerGameType", gamemode.method_8379());
    }
}

