/*
 * Decompiled with CFR 0.152.
 */
package com.github.tatercertified.lifesteal.utils;

import com.github.tatercertified.lifesteal.Lifesteal;
import com.github.tatercertified.lifesteal.data.DeathData;
import com.github.tatercertified.lifesteal.gamerules.DeathAction;
import com.github.tatercertified.lifesteal.gamerules.LifeStealGamerules;
import com.github.tatercertified.lifesteal.items.ModItems;
import com.github.tatercertified.lifesteal.mixin.ServerPlayerEntityServerAccessor;
import com.github.tatercertified.lifesteal.utils.LifeStealText;
import com.github.tatercertified.lifesteal.utils.PlayerGameModeInterface;
import com.github.tatercertified.lifesteal.utils.PlayerInvulnerabilityInterface;
import com.github.tatercertified.lifesteal.utils.PlayerMaxHealthInterface;
import com.github.tatercertified.lifesteal.utils.PlayerReviveData;
import net.fabricmc.fabric.api.gamerule.v1.rule.EnumRule;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.server.MinecraftServer;

public final class PlayerUtils {
    public static void handleDeadPlayerAction(class_3222 player, DeathData data) {
        class_1928 gameRules = player.method_51469().method_64395();
        DeathAction action = (DeathAction)((EnumRule)gameRules.method_20746(LifeStealGamerules.DEATH_ACTION)).get();
        switch (action) {
            case BAN: {
                if (((class_1928.class_4312)gameRules.method_20746(LifeStealGamerules.AUTOREVIVAL)).method_20763() == 0) {
                    player.field_13987.method_52396(LifeStealText.DEATH);
                    break;
                }
                player.field_13987.method_52396(LifeStealText.deathTime((int)((double)(data.deathTime + (long)((class_1928.class_4312)gameRules.method_20746(LifeStealGamerules.AUTOREVIVAL)).method_20763()) - (double)System.currentTimeMillis() * 0.001)));
                break;
            }
            case REVIVE: {
                PlayerUtils.setMaxHealth(gameRules.method_8356(LifeStealGamerules.MINPLAYERHEALTH), player);
                DeathData.removeFromDeathDataList(player.method_5667());
                ((PlayerReviveData)player).setNewlyRevived(true);
                break;
            }
            case SPECTATOR: {
                player.method_7336(class_1934.field_9219);
                ((PlayerGameModeInterface)player.field_13974).setPreviousGameMode(class_1934.field_9219);
            }
        }
    }

    public static void handlePlayerJoin(class_3222 player) {
        DeathData data = Lifesteal.DEAD_PLAYERS.get(player.method_5667());
        if (data != null) {
            if (data.reviverPlayerID == null) {
                if (DeathData.shouldAutoRevive(data, player.method_51469().method_64395().method_8356(LifeStealGamerules.AUTOREVIVAL))) {
                    PlayerUtils.handlePostRevival(data, player, true);
                } else {
                    PlayerUtils.handleDeadPlayerAction(player, data);
                }
            } else {
                PlayerUtils.handlePostRevival(data, player, false);
            }
        }
    }

    private static void handlePostRevival(DeathData data, class_3222 player, boolean autoRevived) {
        class_1928 gameRules = player.method_51469().method_64395();
        if (!autoRevived) {
            player.method_64398(LifeStealText.onRevivalText(data, ((ServerPlayerEntityServerAccessor)player).getServer()));
        } else {
            ((PlayerReviveData)player).setNewlyRevived(true);
        }
        int invulnerability = gameRules.method_8356(LifeStealGamerules.RESPAWN_INVULNERABILITY);
        if (invulnerability != 0) {
            ((PlayerInvulnerabilityInterface)player).setReviveInvulnerability();
        }
        DeathData.removeFromDeathDataList(player.method_5667());
    }

    public static void exchangeHealth(class_3222 killed, class_3222 attacker) {
        int minHealth;
        class_1324 killedMaxHealth = killed.method_5996(class_5134.field_23716);
        class_1928 gameRules = killed.method_51469().method_64395();
        double killedMaxHealthDouble = killedMaxHealth.method_6201();
        if (killedMaxHealthDouble <= (double)(minHealth = gameRules.method_8356(LifeStealGamerules.MINPLAYERHEALTH))) {
            DeathData data = new DeathData(killed.method_5667());
            data.addToDeathDataList();
            PlayerUtils.handleDeadPlayerAction(killed, data);
            if (((PlayerReviveData)killed).newlyRevived() && gameRules.method_8355(LifeStealGamerules.ANTIHEARTDUPE)) {
                return;
            }
        } else {
            PlayerUtils.changeHealthUnchecked(killed, -gameRules.method_8356(LifeStealGamerules.STEALAMOUNT));
        }
        if (!PlayerUtils.changeHealth(attacker, gameRules.method_8356(LifeStealGamerules.STEALAMOUNT))) {
            attacker.method_7353(LifeStealText.MAX_HEALTH, true);
            PlayerUtils.givePlayerHeart(attacker, 1);
        }
    }

    public static boolean canChangeHealth(double currentMaxHealth, float by, class_1928 gameRules) {
        double newMaxHealth = currentMaxHealth + (double)by;
        return newMaxHealth >= (double)gameRules.method_8356(LifeStealGamerules.MINPLAYERHEALTH) && newMaxHealth <= (double)gameRules.method_8356(LifeStealGamerules.MAXPLAYERHEALTH);
    }

    public static void changeHealthUnchecked(class_3222 player, float by) {
        double currentValue = ((PlayerMaxHealthInterface)player).getBaseMaxHealth();
        ((PlayerMaxHealthInterface)player).setBaseMaxHealth(currentValue + (double)by);
        float health = player.method_6032();
        player.method_6033(health + by);
        ((PlayerReviveData)player).setNewlyRevived(false);
        player.method_7353(LifeStealText.updateHealth(by), true);
    }

    public static boolean changeHealth(class_3222 player, float by) {
        double maxHealth = ((PlayerMaxHealthInterface)player).getBaseMaxHealth();
        if (PlayerUtils.canChangeHealth(maxHealth, by, player.method_51469().method_64395())) {
            PlayerUtils.changeHealthUnchecked(player, by);
            return true;
        }
        return false;
    }

    public static void setMaxHealth(double value, class_3222 player) {
        class_1324 maxHealth = player.method_5996(class_5134.field_23716);
        maxHealth.method_6192(value);
    }

    public static void convertHealthToHeartItems(class_3222 player, int hearts, MinecraftServer server, boolean action) {
        int health = hearts * server.method_3767().method_8356(LifeStealGamerules.HEARTBONUS);
        if (health < 0) {
            player.method_7353(LifeStealText.LOW_HEALTH, action);
            return;
        }
        if (health == 0) {
            player.method_7353(LifeStealText.HEART_DISABLED, action);
            return;
        }
        if (!PlayerUtils.changeHealth(player, -health)) {
            player.method_7353(LifeStealText.LOW_HEALTH, action);
            return;
        }
        PlayerUtils.givePlayerHeart(player, hearts);
        player.method_7353(LifeStealText.withdrawnHealth(health, hearts), action);
    }

    private static void givePlayerHeart(class_3222 player, int hearts) {
        class_1799 heartStack = new class_1799((class_1935)ModItems.HEART, 1);
        for (int i = 0; i < hearts; ++i) {
            if (player.method_7270(heartStack.method_7972())) continue;
            for (int j = i; j < hearts; ++j) {
                player.method_7329(heartStack.method_7972(), false, true);
            }
            break;
        }
    }
}

