/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs;

import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.command.GangCommands;
import su.nightexpress.excellentgangs.config.Config;
import su.nightexpress.excellentgangs.config.Lang;
import su.nightexpress.excellentgangs.config.Perms;
import su.nightexpress.excellentgangs.data.DataHandler;
import su.nightexpress.excellentgangs.dialog.GangDialogs;
import su.nightexpress.excellentgangs.gang.GangManager;
import su.nightexpress.excellentgangs.requirement.LevelRequirementFactory;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.commands.command.NightCommand;
import su.nightexpress.nightcore.config.PluginDetails;

public class GangsPlugin
extends NightPlugin {
    private LevelRequirementFactory requirementFactory;
    private DataHandler dataHandler;
    private GangManager gangManager;
    private GangDialogs gangDialogs;

    @NotNull
    protected PluginDetails getDefaultDetails() {
        return PluginDetails.create((String)"Gangs", (String[])new String[]{"gangs", "excellentgangs", "gangsadmin", "gangadmin"}).setConfigClass(Config.class).setPermissionsClass(Perms.class);
    }

    protected void addRegistries() {
        this.registerLang(Lang.class);
    }

    protected boolean disableCommandManager() {
        return true;
    }

    public void enable() {
        this.requirementFactory = new LevelRequirementFactory(this);
        this.requirementFactory.setup();
        this.dataHandler = new DataHandler(this);
        this.dataHandler.setup();
        this.gangDialogs = new GangDialogs(this);
        this.gangDialogs.setup();
        this.gangManager = new GangManager(this, this.requirementFactory);
        this.gangManager.setup();
        this.loadCommands();
    }

    private void loadCommands() {
        this.rootCommand = NightCommand.forPlugin((NightPlugin)this, builder -> GangCommands.load(this, builder));
    }

    public void disable() {
        if (this.gangManager != null) {
            this.gangManager.shutdown();
        }
        if (this.gangDialogs != null) {
            this.gangDialogs.shutdown();
        }
        if (this.dataHandler != null) {
            this.dataHandler.shutdown();
        }
        if (this.requirementFactory != null) {
            this.requirementFactory.shutdown();
        }
    }

    @NotNull
    public LevelRequirementFactory getRequirementFactory() {
        return this.requirementFactory;
    }

    @NotNull
    public DataHandler getDataHandler() {
        return this.dataHandler;
    }

    @NotNull
    public GangManager getGangManager() {
        return this.gangManager;
    }

    @NotNull
    public GangDialogs getGangDialogs() {
        return this.gangDialogs;
    }
}

