/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.command;

import java.util.ArrayList;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.GangsPlugin;
import su.nightexpress.excellentgangs.config.Config;
import su.nightexpress.excellentgangs.config.Lang;
import su.nightexpress.excellentgangs.config.Perms;
import su.nightexpress.excellentgangs.gang.Gang;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.commands.Commands;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.ExecutableNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.command.NightCommand;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.commands.exceptions.CommandSyntaxException;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.entry.MessageLocale;

public class GangCommands {
    public static final String DEF_ADMIN_ALIAS = "gangs";
    public static final String DEF_GANG = "gang";
    public static final String DEF_BRANCH_JOIN = "join";
    private static final String ARG_NAME = "name";
    private static final String ARG_PLAYER = "player";
    private static final String ARG_GANG = "gang";
    private static final String ARG_RANK = "rank";
    private static GangsPlugin plugin;
    private static NightCommand gangCommand;

    public static void load(@NotNull GangsPlugin gangsPlugin, @NotNull HubNodeBuilder builder) {
        plugin = gangsPlugin;
        GangCommands.loadAdminCommands(builder);
        GangCommands.loadGangCommands();
    }

    private static void loadAdminCommands(@NotNull HubNodeBuilder builder) {
        builder.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"reload").description(CoreLang.COMMAND_RELOAD_DESC)).permission((Permission)Perms.COMMAND_RELOAD)).executes((context, arguments) -> {
            plugin.doReload(context.getSender());
            return true;
        })});
    }

    private static void loadGangCommands() {
        gangCommand = NightCommand.hub((NightPlugin)plugin, (String[])((String[])Config.GENERAL_GANG_ALIASES.get()), builder -> {
            builder.description(Lang.COMMAND_GANG_DESC);
            builder.permission((Permission)Perms.COMMAND_GANG);
            builder.executes(GangCommands::openGangMenu);
            builder.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"create").description(Lang.COMMAND_GANG_CREATE_DESC)).permission((Permission)Perms.COMMAND_GANG_CREATE)).executes(GangCommands::createGang)});
            builder.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)DEF_BRANCH_JOIN).description(Lang.COMMAND_GANG_JOIN_DESC)).permission((Permission)Perms.COMMAND_GANG_JOIN)).withArguments(new ArgumentNodeBuilder[]{GangCommands.gangArgument().suggestions((reader, context) -> plugin.getGangManager().getGangs().stream().filter(gang -> context.isPlayer() && gang.hasInvite(context.getPlayerOrThrow())).map(Gang::getIdName).toList())}).executes(GangCommands::joinGang)});
            builder.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"menu").description(Lang.COMMAND_GANG_MENU_DESC)).permission((Permission)Perms.COMMAND_GANG_MENU)).executes(GangCommands::openGangMenu)});
        });
        gangCommand.register();
    }

    public static void clear() {
        if (gangCommand != null) {
            gangCommand.unregister();
            gangCommand = null;
        }
        plugin = null;
    }

    @NotNull
    private static ArgumentNodeBuilder<Gang> gangArgument() {
        return Commands.argument((String)"gang", (contextBuilder, string) -> plugin.getGangManager().gangByName(string).orElseThrow(() -> CommandSyntaxException.custom((MessageLocale)Lang.COMMAND_SYNTAX_INVALID_GANG))).localized(Lang.COMMAND_ARGUMENT_NAME_GANG).suggestions((reader, context) -> new ArrayList<String>(plugin.getGangManager().getGangByNameMap().keySet()));
    }

    private static boolean createGang(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        return plugin.getGangManager().openCreationDialog(player);
    }

    private static boolean openGangMenu(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        return plugin.getGangManager().openGangMenu(player);
    }

    private static boolean joinGang(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        Gang gang = (Gang)arguments.get("gang", Gang.class);
        return plugin.getGangManager().joinGang(player, gang);
    }
}

