/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.config;

import java.util.Set;
import su.nightexpress.excellentgangs.util.GangUtils;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class Config {
    public static final String DIR_MENU = "/menu/";
    public static final String FILE_RANKS = "ranks.yml";
    public static final String FILE_LEVELS = "levels.yml";
    public static final ConfigValue<String[]> GENERAL_GANG_ALIASES = ConfigValue.create((String)"General.GangAliases", (String[])new String[]{"gang"}, (String[])new String[]{"Command aliases for player gang-related commands."});
    public static final ConfigValue<Integer> GENERAL_GANG_SAVE_INTERVAL = ConfigValue.create((String)"General.GangSaveInterval", (int)10, (String[])new String[]{"How often (in seconds) to save gang changes to the database?", "[Default is 10 seconds]", "[Asynchronous]"});
    public static final ConfigValue<String> GANG_NAME_PATTERN = ConfigValue.create((String)"Gang.Name.Pattern", (String)"[\\p{L}0-9_ ]+", (String[])new String[]{"Sets allowed gang name pattern."}).whenRead(GangUtils::setNamePattern);
    public static final ConfigValue<Integer> GANG_NAME_LENGTH_MIN = ConfigValue.create((String)"Gang.Name.MinLength", (int)3, (String[])new String[]{"Sets the minimum number of characters for the gang name."});
    public static final ConfigValue<Integer> GANG_NAME_LENGTH_MAX = ConfigValue.create((String)"Gang.Name.MaxLength", (int)20, (String[])new String[]{"Sets the maximum number of characters for the gang name."});
    public static final ConfigValue<Integer> GANG_INVITE_EXPIRE_TIME = ConfigValue.create((String)"Gang.Invite.ExpireTime", (int)60, (String[])new String[]{"Sets gang invite expire time (in seconds)."});
    public static final ConfigValue<Boolean> GANG_PREFIX_ENABLED = ConfigValue.create((String)"Gang.Prefix.Enabled", (boolean)true, (String[])new String[]{"Controls whether internal gang messages should have its own prefix."});
    public static final ConfigValue<String> GANG_PREFIX_INTERNAL = ConfigValue.create((String)"Gang.Prefix.Internal", (String)TagWrappers.GRAY.wrap("[" + TagWrappers.WHITE.wrap("%gang_name%") + "] "), (String[])new String[]{"Sets prefix for internal gang messages."});
    public static final ConfigValue<String> CHAT_PREFIX = ConfigValue.create((String)"Chat.Prefix", (String)"#", (String[])new String[]{"Prefix for sending messages to the gang chat."});
    public static final ConfigValue<String> CHAT_FORMAT = ConfigValue.create((String)"Chat.Format", (String)("[" + TagWrappers.WHITE.wrap("%gang_name%") + "] %player_name%: %message%"), (String[])new String[]{"Gang chat format."});
    public static final ConfigValue<Set<String>> BANK_ALLOWED_CURRENCIES = ConfigValue.create((String)"Bank.Allowed_Currencies", Set.of("*"), (String[])new String[]{"List of allowed currencies for gang banks.", "Use '*' to allow all available currencies."}).onRead(set -> Lists.modify((Set)set, String::toLowerCase));
}

