/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.GangsPlugin;
import su.nightexpress.excellentgangs.data.DataQueries;
import su.nightexpress.excellentgangs.data.serialize.GangBankSerializer;
import su.nightexpress.excellentgangs.data.serialize.GangMemberSerializer;
import su.nightexpress.excellentgangs.data.serialize.ItemTagSerializer;
import su.nightexpress.excellentgangs.gang.Gang;
import su.nightexpress.excellentgangs.gang.GangMember;
import su.nightexpress.excellentgangs.gang.bank.GangBank;
import su.nightexpress.excellentgangs.gang.vault.GangVault;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.db.AbstractDataManager;
import su.nightexpress.nightcore.db.sql.column.Column;
import su.nightexpress.nightcore.db.sql.column.ColumnType;
import su.nightexpress.nightcore.util.ItemTag;

public class DataHandler
extends AbstractDataManager<GangsPlugin> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemTag.class, (Object)new ItemTagSerializer()).registerTypeAdapter(GangMember.class, (Object)new GangMemberSerializer()).registerTypeAdapter(GangBank.class, (Object)new GangBankSerializer()).create();
    static final Column COLUMN_GANG_ID = Column.of((String)"uniqueId", (ColumnType)ColumnType.STRING);
    static final Column COLUMN_GANG_ID_NAME = Column.of((String)"internalName", (ColumnType)ColumnType.STRING);
    static final Column COLUMN_GANG_NAME = Column.of((String)"name", (ColumnType)ColumnType.STRING);
    static final Column COLUMN_OWNER_ID = Column.of((String)"ownerId", (ColumnType)ColumnType.STRING);
    static final Column COLUMN_LEVEL = Column.of((String)"level", (ColumnType)ColumnType.INTEGER);
    static final Column COLUMN_FRIENDLY_FIRE = Column.of((String)"friendlyFire", (ColumnType)ColumnType.BOOLEAN);
    static final Column COLUMN_MEMBERS = Column.of((String)"members", (ColumnType)ColumnType.STRING);
    static final Column COLUMN_VAULT = Column.of((String)"vault", (ColumnType)ColumnType.STRING);
    static final Column COLUMN_BANK = Column.of((String)"bank", (ColumnType)ColumnType.STRING);
    private final String gangsTable = this.getTablePrefix() + "_gangs";

    public DataHandler(@NotNull GangsPlugin plugin) {
        super((NightPlugin)plugin);
    }

    @NotNull
    protected GsonBuilder registerAdapters(@NotNull GsonBuilder builder) {
        return builder;
    }

    protected void onInitialize() {
        this.createTable(this.gangsTable, List.of(COLUMN_GANG_ID, COLUMN_GANG_ID_NAME, COLUMN_GANG_NAME, COLUMN_OWNER_ID, COLUMN_LEVEL, COLUMN_FRIENDLY_FIRE, COLUMN_MEMBERS, COLUMN_VAULT, COLUMN_BANK));
    }

    protected void onClose() {
    }

    public void onPurge() {
    }

    public void onSynchronize() {
    }

    @NotNull
    public List<Gang> selectGangs() {
        return this.select(this.gangsTable, DataQueries.GANG_LOADER, query -> query.column(COLUMN_GANG_ID).column(COLUMN_GANG_ID_NAME).column(COLUMN_GANG_NAME).column(COLUMN_OWNER_ID).column(COLUMN_LEVEL).column(COLUMN_BANK).column(COLUMN_FRIENDLY_FIRE).column(COLUMN_MEMBERS));
    }

    @NotNull
    public List<GangVault> loadGangVaults() {
        return this.select(this.gangsTable, DataQueries.GANG_VAULT_LOADER, query -> query.column(COLUMN_GANG_ID).column(COLUMN_VAULT));
    }

    public void updateGangs(@NotNull Collection<Gang> gangs) {
        DataQueries.GANG_UPDATE.execute(this.connector, this.gangsTable, gangs);
    }

    public void updateGang(@NotNull Gang gang) {
        DataQueries.GANG_UPDATE.execute(this.connector, this.gangsTable, (Object)gang);
    }

    public void insertGang(@NotNull Gang gang) {
        DataQueries.GANG_INSERT.execute(this.connector, this.gangsTable, (Object)gang);
    }

    public void deleteGang(@NotNull Gang gang) {
        DataQueries.GANG_DELETE.execute(this.connector, this.gangsTable, (Object)gang);
    }
}

