/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.data;

import com.google.gson.reflect.TypeToken;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.data.DataHandler;
import su.nightexpress.excellentgangs.gang.Gang;
import su.nightexpress.excellentgangs.gang.GangMember;
import su.nightexpress.excellentgangs.gang.bank.GangBank;
import su.nightexpress.excellentgangs.gang.level.GangLevel;
import su.nightexpress.excellentgangs.gang.vault.GangVault;
import su.nightexpress.excellentgangs.registry.GangLevels;
import su.nightexpress.nightcore.db.query.type.DeleteQuery;
import su.nightexpress.nightcore.db.query.type.InsertQuery;
import su.nightexpress.nightcore.db.query.type.UpdateQuery;
import su.nightexpress.nightcore.db.sql.column.Column;
import su.nightexpress.nightcore.db.sql.util.WhereOperator;
import su.nightexpress.nightcore.util.ItemTag;

public class DataQueries {
    public static final Function<ResultSet, Gang> GANG_LOADER = resultSet -> {
        try {
            UUID gangId = UUID.fromString(resultSet.getString(DataHandler.COLUMN_GANG_ID.getName()));
            String idName = resultSet.getString(DataHandler.COLUMN_GANG_ID_NAME.getName());
            String name = resultSet.getString(DataHandler.COLUMN_GANG_NAME.getName());
            UUID ownerId = UUID.fromString(resultSet.getString(DataHandler.COLUMN_OWNER_ID.getName()));
            int levelValue = resultSet.getInt(DataHandler.COLUMN_LEVEL.getName());
            boolean friendlyFire = resultSet.getBoolean(DataHandler.COLUMN_FRIENDLY_FIRE.getName());
            GangBank bank = DataQueries.fromJson(resultSet, DataHandler.COLUMN_BANK, GangBank.class);
            Map memberMap = (Map)DataHandler.GSON.fromJson(resultSet.getString(DataHandler.COLUMN_MEMBERS.getName()), new TypeToken<Map<UUID, GangMember>>(){}.getType());
            GangLevel level = GangLevels.level(levelValue).orElse(GangLevels.flooring(levelValue));
            return new Gang(gangId, idName, name, ownerId, level, bank, friendlyFire, memberMap);
        }
        catch (SQLException exception) {
            exception.printStackTrace();
            return null;
        }
    };
    public static final Function<ResultSet, GangVault> GANG_VAULT_LOADER = resultSet -> {
        try {
            UUID gangId = UUID.fromString(resultSet.getString(DataHandler.COLUMN_GANG_ID.getName()));
            Map itemTags = (Map)DataHandler.GSON.fromJson(resultSet.getString(DataHandler.COLUMN_VAULT.getName()), new TypeToken<Map<Integer, ItemTag>>(){}.getType());
            HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
            itemTags.forEach((index, tag) -> {
                ItemStack itemStack = tag.getItemStack();
                if (itemStack == null || itemStack.getType().isAir()) {
                    return;
                }
                items.put((Integer)index, itemStack);
            });
            return new GangVault(gangId, items);
        }
        catch (IllegalStateException | SQLException exception) {
            exception.printStackTrace();
            return null;
        }
    };
    public static final InsertQuery<Gang> GANG_INSERT = new InsertQuery().setValue(DataHandler.COLUMN_GANG_ID, gang -> gang.getId().toString()).setValue(DataHandler.COLUMN_GANG_ID_NAME, Gang::getIdName).setValue(DataHandler.COLUMN_GANG_NAME, Gang::getName).setValue(DataHandler.COLUMN_OWNER_ID, gang -> gang.getOwnerId().toString()).setValue(DataHandler.COLUMN_LEVEL, gang -> String.valueOf(gang.getLevel().getValue())).setValue(DataHandler.COLUMN_FRIENDLY_FIRE, gang -> String.valueOf(gang.isFriendlyFire() ? 1 : 0)).setValue(DataHandler.COLUMN_MEMBERS, gang -> DataHandler.GSON.toJson(gang.getMemberByIdMap())).setValue(DataHandler.COLUMN_VAULT, gang -> DataQueries.vaultToJson(gang.getVault())).setValue(DataHandler.COLUMN_BANK, gang -> DataHandler.GSON.toJson((Object)gang.getBank()));
    public static final UpdateQuery<Gang> GANG_UPDATE = new UpdateQuery().setValue(DataHandler.COLUMN_GANG_ID_NAME, Gang::getIdName).setValue(DataHandler.COLUMN_GANG_NAME, Gang::getName).setValue(DataHandler.COLUMN_OWNER_ID, gang -> gang.getOwnerId().toString()).setValue(DataHandler.COLUMN_LEVEL, gang -> String.valueOf(gang.getLevel().getValue())).setValue(DataHandler.COLUMN_FRIENDLY_FIRE, gang -> String.valueOf(gang.isFriendlyFire() ? 1 : 0)).setValue(DataHandler.COLUMN_MEMBERS, gang -> DataHandler.GSON.toJson(gang.getMemberByIdMap())).setValue(DataHandler.COLUMN_VAULT, gang -> DataQueries.vaultToJson(gang.getVault())).setValue(DataHandler.COLUMN_BANK, gang -> DataHandler.GSON.toJson((Object)gang.getBank()));
    public static final DeleteQuery<Gang> GANG_DELETE = new DeleteQuery().where(DataHandler.COLUMN_GANG_ID, WhereOperator.EQUAL, gang -> gang.getId().toString());

    @NotNull
    public static <T> T fromJson(@NotNull ResultSet resultSet, @NotNull Column column, @NotNull Class<T> type) throws SQLException {
        return (T)DataHandler.GSON.fromJson(resultSet.getString(column.getName()), type);
    }

    @NotNull
    private static String vaultToJson(@NotNull GangVault vault) {
        HashMap itemTagMap = new HashMap();
        vault.getItems().forEach((index, itemStack) -> itemTagMap.put(index, ItemTag.of((ItemStack)itemStack)));
        return DataHandler.GSON.toJson(itemTagMap);
    }
}

