/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.data.serialize;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.UUID;
import su.nightexpress.excellentgangs.gang.GangMember;
import su.nightexpress.excellentgangs.gang.rank.GangRank;
import su.nightexpress.excellentgangs.registry.GangRanks;

public class GangMemberSerializer
implements JsonSerializer<GangMember>,
JsonDeserializer<GangMember> {
    public GangMember deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        String playerName = object.get("playerName").getAsString();
        UUID playerId = UUID.fromString(object.get("playerId").getAsString());
        String rankId = object.get("rank").getAsString();
        long lastLogin = object.get("lastLogin").getAsLong();
        GangRank rank = GangRanks.byId(rankId).orElse(GangRanks.getLowestRank());
        return new GangMember(playerId, playerName, rank, lastLogin);
    }

    public JsonElement serialize(GangMember member, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("playerName", member.getName());
        object.addProperty("playerId", member.getPlayerId().toString());
        object.addProperty("rank", member.getRank().getId());
        object.addProperty("lastLogin", (Number)member.getLastLogin());
        return object;
    }
}

