/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.data.serialize;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import su.nightexpress.nightcore.util.ItemTag;

public class ItemTagSerializer
implements JsonSerializer<ItemTag>,
JsonDeserializer<ItemTag> {
    public ItemTag deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        String tag = object.get("tag").getAsString();
        int dataVersion = object.get("dataVersion").getAsInt();
        return new ItemTag(tag, dataVersion);
    }

    public JsonElement serialize(ItemTag itemTag, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("tag", itemTag.getTag());
        object.addProperty("dataVersion", (Number)itemTag.getDataVersion());
        return object;
    }
}

