/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.dialog.gang;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.GangsPlugin;
import su.nightexpress.excellentgangs.dialog.GangDialog;
import su.nightexpress.excellentgangs.gang.Gang;
import su.nightexpress.excellentgangs.gang.bank.GangBank;
import su.nightexpress.excellentgangs.gang.rank.GangPermission;
import su.nightexpress.excellentgangs.util.GangUtils;
import su.nightexpress.nightcore.bridge.common.NightNbtHolder;
import su.nightexpress.nightcore.bridge.currency.Currency;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.action.WrappedDialogAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.single.WrappedSingleOptionEntry;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.integration.currency.EconomyBridge;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.ButtonLocale;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogActions;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class GangBankDialog
extends GangDialog<Gang> {
    private static final TextLocale TITLE = LangEntry.builder((String)"Dialog.Bank.Title").text(GangBankDialog.title("Gang", "Bank Management"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Dialog.Bank.Body.Main").dialogElement(400, new String[]{"Select the desired " + TagWrappers.SOFT_YELLOW.wrap("currency") + " and enter the " + TagWrappers.SOFT_YELLOW.wrap("amount") + " you want to withdraw or deposit into the bank.", "", TagWrappers.GREEN.and((TagWrapper)TagWrappers.BOLD).wrap("BANK BALANCE:"), "%balance%"});
    private static final TextLocale BODY_BALANCE_ENTRY = LangEntry.builder((String)"Dialog.Bank.Body.BalanceEntry").text("%currency_name%: " + TagWrappers.SOFT_YELLOW.wrap("%amount%"));
    private static final TextLocale INPUT_CURRENCY = LangEntry.builder((String)"Dialog.Bank.Input.Currency").text((String)TagWrappers.SPRITE_NO_ATLAS.apply("item/emerald") + " Currency");
    private static final TextLocale INPUT_AMOUNT = LangEntry.builder((String)"Dialog.Bank.Input.Amount").text("Amount");
    private static final ButtonLocale BUTTON_DEPOSIT = LangEntry.builder((String)"Dialog.Bank.Button.Deposit").button(TagWrappers.GREEN.wrap("\u2191") + " Deposit");
    private static final ButtonLocale BUTTON_WITHDRAW = LangEntry.builder((String)"Dialog.Bank.Button.Withdraw").button(TagWrappers.RED.wrap("\u2193") + " Withdraw");
    private static final String JSON_CURRENCY = "currency";
    private static final String JSON_AMOUNT = "amount";
    private static final String ACTION_DEPOSIT = "deposit";
    private static final String ACTION_WITHDRAW = "withdraw";
    private final GangsPlugin plugin;

    public GangBankDialog(@NotNull GangsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Gang gang) {
        ArrayList currencies = new ArrayList();
        ArrayList entries = new ArrayList();
        ArrayList<WrappedActionButton> buttons = new ArrayList<WrappedActionButton>();
        EconomyBridge.getCurrencies().stream().sorted(Comparator.comparing(Currency::getInternalId)).forEach(currency -> {
            if (GangUtils.isAllowedBankCurrency(currency)) {
                currencies.add(currency);
                entries.add(new WrappedSingleOptionEntry(currency.getInternalId(), currency.getName(), false));
            }
        });
        if (gang.isPermitted(player, GangPermission.DEPOSIT_TO_BANK)) {
            buttons.add(DialogButtons.action((ButtonLocale)BUTTON_DEPOSIT).action((WrappedDialogAction)DialogActions.customClick((String)ACTION_DEPOSIT)).build());
        }
        if (gang.isPermitted(player, GangPermission.WITHDRAW_FROM_BANK)) {
            buttons.add(DialogButtons.action((ButtonLocale)BUTTON_WITHDRAW).action((WrappedDialogAction)DialogActions.customClick((String)ACTION_WITHDRAW)).build());
        }
        GangBank bank = gang.getBank();
        String balances = currencies.stream().map(currency -> currency.applyFormat(BODY_BALANCE_ENTRY.text(), bank.getBalance((Currency)currency))).collect(Collectors.joining("\n"));
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY.replace(str -> str.replace("%balance%", balances)))}).inputs(new WrappedDialogInput[]{DialogInputs.singleOption((String)JSON_CURRENCY, (TextLocale)INPUT_CURRENCY, (List)entries).build(), DialogInputs.text((String)JSON_AMOUNT, (TextLocale)INPUT_AMOUNT).maxLength(8).initial("0").build()}).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((List)buttons).exitAction(DialogButtons.back()).columns(2).build());
            builder.handleResponse(ACTION_DEPOSIT, (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                this.handleAction(nbtHolder, (currency, amount) -> {
                    this.plugin.getGangManager().depositToBank(player, gang, (Currency)currency, (double)amount);
                    viewer.callback();
                });
            });
            builder.handleResponse(ACTION_WITHDRAW, (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                this.handleAction(nbtHolder, (currency, amount) -> {
                    this.plugin.getGangManager().withdrawFromBank(player, gang, (Currency)currency, (double)amount);
                    viewer.callback();
                });
            });
        });
    }

    private void handleAction(@NotNull NightNbtHolder nbtHolder, @NotNull BiConsumer<Currency, Double> consumer) {
        String currencyId = nbtHolder.getText(JSON_CURRENCY).orElse(null);
        if (currencyId == null) {
            return;
        }
        Currency currency = EconomyBridge.getCurrency((String)currencyId);
        if (currency == null || !GangUtils.isAllowedBankCurrency(currency)) {
            return;
        }
        double amount = nbtHolder.getDouble(JSON_AMOUNT, 0.0);
        if (amount <= 0.0) {
            return;
        }
        consumer.accept(currency, amount);
    }
}

