/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.dialog.gang;

import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.config.Config;
import su.nightexpress.excellentgangs.dialog.GangDialog;
import su.nightexpress.excellentgangs.gang.GangManager;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class GangCreateDialog
extends GangDialog<GangManager> {
    private static final TextLocale TITLE = LangEntry.builder((String)"Dialog.Gang.Creation.Title").text(GangCreateDialog.title("Gang", "Creation"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Dialog.Gang.Creation.Body").dialogElement(400, new String[]{"Enter a new name for your gang."});
    private static final TextLocale INPUT_NAME = LangEntry.builder((String)"Dialog.Gang.Creation.Input.Name").text((String)TagWrappers.SPRITE_NO_ATLAS.apply("item/name_tag") + " Name");
    private static final String JSON_NAME = "name";

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull GangManager manager) {
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.text((String)JSON_NAME, (TextLocale)INPUT_NAME).maxLength(((Integer)Config.GANG_NAME_LENGTH_MAX.get()).intValue()).build()}).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build());
            builder.handleResponse("ok", (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                String name = nbtHolder.getText(JSON_NAME).orElse(null);
                if (name == null || name.isBlank()) {
                    return;
                }
                manager.createGang(player, name);
                viewer.callback();
            });
        });
    }
}

