/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.dialog.gang;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.GangsPlugin;
import su.nightexpress.excellentgangs.dialog.GangDialog;
import su.nightexpress.excellentgangs.gang.Gang;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class GangInviteDialog
extends GangDialog<Gang> {
    private static final TextLocale TITLE = LangEntry.builder((String)"Dialog.Invite.Title").text(GangInviteDialog.title("Gang", "Invite Player"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Dialog.Invite.Body").dialogElement(400, new String[]{"Enter the name of the player you want to invite to your gang."});
    private static final TextLocale INPUT_NAME = LangEntry.builder((String)"Dialog.Invite.Input.PlayerName").text((String)TagWrappers.HEAD_HAT.apply("%player_name%") + " Player Name");
    private static final String JSON_NAME = "name";
    private final GangsPlugin plugin;

    public GangInviteDialog(@NotNull GangsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Gang gang) {
        return Dialogs.create(builder -> {
            builder.base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.text((String)JSON_NAME, (String)INPUT_NAME.text().replace("%player_name%", player.getName())).maxLength(16).build()}).build());
            builder.type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build());
            builder.handleResponse("ok", (viewer, identifier, nbtHolder) -> {
                if (nbtHolder == null) {
                    return;
                }
                String name = nbtHolder.getText(JSON_NAME).orElse(null);
                if (name == null || name.isBlank()) {
                    return;
                }
                Player target = Players.getPlayer((String)name);
                if (target == null) {
                    CoreLang.ERROR_INVALID_PLAYER.withPrefix((NightPlugin)this.plugin).send((CommandSender)player);
                    return;
                }
                this.plugin.getGangManager().inviteToGang(player, target);
                viewer.callback();
            });
        });
    }
}

